/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.external;

import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism._private.MechanismUtil;

public class ExternalAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    private final CallbackHandler callbackHandler;

    ExternalAuthenticationMechanism(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public String getMechanismName() {
        return "EXTERNAL";
    }

    @Override
    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        String remoteUser = request.getRemoteUser();
        if (remoteUser == null) {
            ElytronMessages.httpExternal.trace("The remote-user was not obtained from the request");
            request.noAuthenticationInProgress();
            return;
        }
        if (this.authorize(remoteUser)) {
            ElytronMessages.httpExternal.tracef("Authorization of user [%s] succeed", (Object)remoteUser);
            this.succeed(request);
        } else {
            ElytronMessages.httpExternal.tracef("Authorization of user [%s] failed", (Object)remoteUser);
            this.fail(request);
        }
    }

    private boolean authorize(String username) throws HttpAuthenticationException {
        ElytronMessages.httpExternal.tracef("Authorizing username: [%s]", (Object)username);
        AuthorizeCallback authorizeCallback = new AuthorizeCallback(username, username);
        try {
            MechanismUtil.handleCallbacks(ElytronMessages.httpExternal, this.callbackHandler, authorizeCallback);
            return authorizeCallback.isAuthorized();
        }
        catch (AuthenticationMechanismException e) {
            throw e.toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.httpExternal.mechCallbackHandlerFailedForUnknownReason(e).toHttpAuthenticationException();
        }
    }

    private void succeed(HttpServerRequest request) throws HttpAuthenticationException {
        try {
            MechanismUtil.handleCallbacks(ElytronMessages.httpExternal, this.callbackHandler, AuthenticationCompleteCallback.SUCCEEDED);
            request.authenticationComplete();
        }
        catch (AuthenticationMechanismException e) {
            ElytronMessages.httpExternal.trace("Failed to complete successful authentication", e);
            throw e.toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.httpExternal.mechCallbackHandlerFailedForUnknownReason(e).toHttpAuthenticationException();
        }
    }

    private void fail(HttpServerRequest request) throws HttpAuthenticationException {
        try {
            MechanismUtil.handleCallbacks(ElytronMessages.httpExternal, this.callbackHandler, AuthenticationCompleteCallback.FAILED);
            request.authenticationFailed(ElytronMessages.httpExternal.authenticationFailed(), response -> response.setStatusCode(403));
        }
        catch (AuthenticationMechanismException e) {
            ElytronMessages.httpExternal.trace("Failed authentication not completed", e);
            throw e.toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException e) {
            throw ElytronMessages.httpExternal.mechCallbackHandlerFailedForUnknownReason(e).toHttpAuthenticationException();
        }
    }
}

