/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.util;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFileSystem<T extends Path>
extends FileSystem {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FileSystemProvider fileSystemProvider;

    protected BaseFileSystem(FileSystemProvider fileSystemProvider) {
        this.fileSystemProvider = Objects.requireNonNull(fileSystemProvider, "No file system provider");
    }

    public T getDefaultDir() {
        return this.getPath("/", new String[0]);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public FileSystemProvider provider() {
        return this.fileSystemProvider;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singleton(this.create("/", new String[0]));
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        throw new UnsupportedOperationException("No file stores available");
    }

    public T getPath(String first, String ... more) {
        StringBuilder sb = new StringBuilder();
        if (!GenericUtils.isEmpty(first)) {
            this.appendDedupSep(sb, this.handleWindowsSeparator(first));
        }
        if (GenericUtils.length(more) > 0) {
            for (String segment : more) {
                if (sb.length() > 0 && sb.charAt(sb.length() - 1) != '/') {
                    sb.append('/');
                }
                this.appendDedupSep(sb, this.handleWindowsSeparator(segment));
            }
        }
        if (sb.length() > 1 && sb.charAt(sb.length() - 1) == '/') {
            sb.setLength(sb.length() - 1);
        }
        String path = sb.toString();
        String root = null;
        if (path.startsWith("/")) {
            root = "/";
            path = path.substring(1);
        }
        String[] names = GenericUtils.split(path, '/');
        T p = this.create(root, names);
        if (this.log.isTraceEnabled()) {
            this.log.trace("getPath({}, {}): {}", first, Arrays.toString(more), p);
        }
        return p;
    }

    protected void appendDedupSep(StringBuilder sb, CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '/' && sb.length() != 0 && sb.charAt(sb.length() - 1) == '/') continue;
            sb.append(ch);
        }
    }

    protected String handleWindowsSeparator(String name) {
        if (this.hostFsHasWindowsSeparator()) {
            return name.replace('\\', '/');
        }
        return name;
    }

    protected boolean hostFsHasWindowsSeparator() {
        return OsUtils.isWin32();
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        String expr;
        int colonIndex = Objects.requireNonNull(syntaxAndPattern, "No argument").indexOf(58);
        if (colonIndex <= 0 || colonIndex == syntaxAndPattern.length() - 1) {
            throw new IllegalArgumentException("syntaxAndPattern must have form \"syntax:pattern\" but was \"" + syntaxAndPattern + "\"");
        }
        String syntax = syntaxAndPattern.substring(0, colonIndex);
        String pattern = syntaxAndPattern.substring(colonIndex + 1);
        switch (syntax) {
            case "glob": {
                expr = this.globToRegex(pattern);
                break;
            }
            case "regex": {
                expr = pattern;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported path matcher syntax: '" + syntax + "'");
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("getPathMatcher({}): {}", (Object)syntaxAndPattern, (Object)expr);
        }
        Pattern regex = Pattern.compile(expr);
        return path -> {
            Matcher m = regex.matcher(path.toString());
            return m.matches();
        };
    }

    protected String globToRegex(String pattern) {
        StringBuilder sb = new StringBuilder(Objects.requireNonNull(pattern, "No pattern").length());
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        block16: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append("\\\\");
                            break;
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    continue block16;
                }
                case '*': {
                    sb.append(inClass == 0 ? ".*" : "*");
                    continue block16;
                }
                case '?': {
                    sb.append(inClass == 0 ? (char)'.' : '?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    sb.append(firstIndexInClass == i ? (char)'^' : '!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    sb.append(inGroup > 0 ? (char)'|' : ',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        String regex = sb.toString();
        if (this.log.isTraceEnabled()) {
            this.log.trace("globToRegex({}): {}", (Object)pattern, (Object)regex);
        }
        return regex;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException("Watch service N/A");
    }

    protected T create(String root, String ... names) {
        return this.create(root, GenericUtils.unmodifiableList(names));
    }

    protected T create(String root, Collection<String> names) {
        return this.create(root, GenericUtils.unmodifiableList(names));
    }

    protected abstract T create(String var1, List<String> var2);
}

