/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.boot.actuate.autoconfigure;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.togglz.core.metadata.FeatureGroup;
import org.togglz.core.metadata.FeatureMetaData;

public class TogglzFeatureMetaData {
    private final String label;
    private final Set<String> groups;
    private final boolean enabledByDefault;
    private final Map<String, String> attributes;

    public TogglzFeatureMetaData(FeatureMetaData metaData) {
        this.label = metaData.getLabel();
        this.groups = metaData.getGroups().stream().map(FeatureGroup::getLabel).collect(Collectors.toSet());
        this.enabledByDefault = metaData.getDefaultFeatureState().isEnabled();
        this.attributes = new HashMap<String, String>(metaData.getAttributes());
    }

    public String getLabel() {
        return this.label;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

