/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.support;

import javax.servlet.ServletContext;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;

public class WebSocketHandlerMapping
extends SimpleUrlHandlerMapping
implements SmartLifecycle {
    private volatile boolean running;

    protected void initServletContext(ServletContext servletContext) {
        for (Object handler : this.getUrlMap().values()) {
            if (!(handler instanceof ServletContextAware)) continue;
            ((ServletContextAware)handler).setServletContext(servletContext);
        }
    }

    public void start() {
        if (!this.isRunning()) {
            this.running = true;
            for (Object handler : this.getUrlMap().values()) {
                if (!(handler instanceof Lifecycle)) continue;
                ((Lifecycle)handler).start();
            }
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.running = false;
            for (Object handler : this.getUrlMap().values()) {
                if (!(handler instanceof Lifecycle)) continue;
                ((Lifecycle)handler).stop();
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

