/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.web.servlet.function.ChangePathPatternParserVisitor;
import org.springframework.web.servlet.function.HandlerFilterFunction;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.PathResourceLookupFunction;
import org.springframework.web.servlet.function.PredicateResourceLookupFunction;
import org.springframework.web.servlet.function.RequestPredicate;
import org.springframework.web.servlet.function.ResourceHandlerFunction;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctionBuilder;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import org.springframework.web.servlet.function.ToStringVisitor;
import org.springframework.web.util.pattern.PathPatternParser;

public abstract class RouterFunctions {
    private static final Log logger = LogFactory.getLog(RouterFunctions.class);
    public static final String REQUEST_ATTRIBUTE = RouterFunctions.class.getName() + ".request";
    public static final String URI_TEMPLATE_VARIABLES_ATTRIBUTE = RouterFunctions.class.getName() + ".uriTemplateVariables";
    public static final String MATCHING_PATTERN_ATTRIBUTE = RouterFunctions.class.getName() + ".matchingPattern";

    public static Builder route() {
        return new RouterFunctionBuilder();
    }

    public static <T extends ServerResponse> RouterFunction<T> route(RequestPredicate predicate, HandlerFunction<T> handlerFunction) {
        return new DefaultRouterFunction<T>(predicate, handlerFunction);
    }

    public static <T extends ServerResponse> RouterFunction<T> nest(RequestPredicate predicate, RouterFunction<T> routerFunction) {
        return new DefaultNestedRouterFunction<T>(predicate, routerFunction);
    }

    public static RouterFunction<ServerResponse> resource(RequestPredicate predicate, Resource resource) {
        return RouterFunctions.resources(new PredicateResourceLookupFunction(predicate, resource), (Resource consumerResource, HttpHeaders httpHeaders) -> {});
    }

    public static RouterFunction<ServerResponse> resource(RequestPredicate predicate, Resource resource, BiConsumer<Resource, HttpHeaders> headersConsumer) {
        return RouterFunctions.resources(new PredicateResourceLookupFunction(predicate, resource), headersConsumer);
    }

    public static RouterFunction<ServerResponse> resources(String pattern, Resource location) {
        return RouterFunctions.resources(RouterFunctions.resourceLookupFunction(pattern, location), (Resource resource, HttpHeaders httpHeaders) -> {});
    }

    public static RouterFunction<ServerResponse> resources(String pattern, Resource location, BiConsumer<Resource, HttpHeaders> headersConsumer) {
        return RouterFunctions.resources(RouterFunctions.resourceLookupFunction(pattern, location), headersConsumer);
    }

    public static Function<ServerRequest, Optional<Resource>> resourceLookupFunction(String pattern, Resource location) {
        return new PathResourceLookupFunction(pattern, location);
    }

    public static RouterFunction<ServerResponse> resources(Function<ServerRequest, Optional<Resource>> lookupFunction) {
        return new ResourcesRouterFunction(lookupFunction, (resource, httpHeaders) -> {});
    }

    public static RouterFunction<ServerResponse> resources(Function<ServerRequest, Optional<Resource>> lookupFunction, BiConsumer<Resource, HttpHeaders> headersConsumer) {
        return new ResourcesRouterFunction(lookupFunction, headersConsumer);
    }

    public static <T extends ServerResponse> RouterFunction<T> changeParser(RouterFunction<T> routerFunction, PathPatternParser parser) {
        Assert.notNull(routerFunction, (String)"RouterFunction must not be null");
        Assert.notNull((Object)parser, (String)"Parser must not be null");
        ChangePathPatternParserVisitor visitor = new ChangePathPatternParserVisitor(parser);
        routerFunction.accept(visitor);
        return routerFunction;
    }

    private static final class DefaultRouterFunction<T extends ServerResponse>
    extends AbstractRouterFunction<T> {
        private final RequestPredicate predicate;
        private final HandlerFunction<T> handlerFunction;

        public DefaultRouterFunction(RequestPredicate predicate, HandlerFunction<T> handlerFunction) {
            Assert.notNull((Object)predicate, (String)"Predicate must not be null");
            Assert.notNull(handlerFunction, (String)"HandlerFunction must not be null");
            this.predicate = predicate;
            this.handlerFunction = handlerFunction;
        }

        @Override
        public Optional<HandlerFunction<T>> route(ServerRequest request) {
            if (this.predicate.test(request)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)String.format("Predicate \"%s\" matches against \"%s\"", this.predicate, request));
                }
                return Optional.of(this.handlerFunction);
            }
            return Optional.empty();
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.route(this.predicate, this.handlerFunction);
        }
    }

    private static final class DefaultNestedRouterFunction<T extends ServerResponse>
    extends AbstractRouterFunction<T> {
        private final RequestPredicate predicate;
        private final RouterFunction<T> routerFunction;

        public DefaultNestedRouterFunction(RequestPredicate predicate, RouterFunction<T> function) {
            Assert.notNull((Object)predicate, (String)"Predicate must not be null");
            Assert.notNull(function, (String)"RouterFunction must not be null");
            this.predicate = predicate;
            this.routerFunction = function;
        }

        @Override
        public Optional<HandlerFunction<T>> route(ServerRequest serverRequest) {
            return this.predicate.nest(serverRequest).map(nestedRequest -> {
                Optional<HandlerFunction<T>> result;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)String.format("Nested predicate \"%s\" matches against \"%s\"", this.predicate, serverRequest));
                }
                if ((result = this.routerFunction.route((ServerRequest)nestedRequest)).isPresent() && nestedRequest != serverRequest) {
                    LinkedHashMap<String, Object> newAttributes = new LinkedHashMap<String, Object>(nestedRequest.attributes());
                    Map<String, Object> oldAttributes = serverRequest.attributes();
                    oldAttributes.clear();
                    oldAttributes.putAll(newAttributes);
                }
                return result;
            }).orElseGet(Optional::empty);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.startNested(this.predicate);
            this.routerFunction.accept(visitor);
            visitor.endNested(this.predicate);
        }
    }

    private static class ResourcesRouterFunction
    extends AbstractRouterFunction<ServerResponse> {
        private final Function<ServerRequest, Optional<Resource>> lookupFunction;
        private final BiConsumer<Resource, HttpHeaders> headersConsumer;

        public ResourcesRouterFunction(Function<ServerRequest, Optional<Resource>> lookupFunction, BiConsumer<Resource, HttpHeaders> headersConsumer) {
            Assert.notNull(lookupFunction, (String)"Lookup function must not be null");
            Assert.notNull(headersConsumer, (String)"Headers consumer must not be null");
            this.lookupFunction = lookupFunction;
            this.headersConsumer = headersConsumer;
        }

        @Override
        public Optional<HandlerFunction<ServerResponse>> route(ServerRequest request) {
            return this.lookupFunction.apply(request).map(resource -> new ResourceHandlerFunction((Resource)resource, this.headersConsumer));
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.resources(this.lookupFunction);
        }
    }

    public static interface Visitor {
        public void startNested(RequestPredicate var1);

        public void endNested(RequestPredicate var1);

        public void route(RequestPredicate var1, HandlerFunction<?> var2);

        public void resources(Function<ServerRequest, Optional<Resource>> var1);

        public void attributes(Map<String, Object> var1);

        public void unknown(RouterFunction<?> var1);
    }

    static final class AttributesRouterFunction<T extends ServerResponse>
    extends AbstractRouterFunction<T> {
        private final RouterFunction<T> delegate;
        private final Map<String, Object> attributes;

        public AttributesRouterFunction(RouterFunction<T> delegate, Map<String, Object> attributes) {
            this.delegate = delegate;
            this.attributes = AttributesRouterFunction.initAttributes(attributes);
        }

        private static Map<String, Object> initAttributes(Map<String, Object> attributes) {
            return attributes.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(attributes));
        }

        @Override
        public Optional<HandlerFunction<T>> route(ServerRequest request) {
            return this.delegate.route(request);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.attributes(this.attributes);
            this.delegate.accept(visitor);
        }

        @Override
        public RouterFunction<T> withAttribute(String name, Object value) {
            Assert.hasLength((String)name, (String)"Name must not be empty");
            Assert.notNull((Object)value, (String)"Value must not be null");
            LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>(this.attributes);
            attributes.put(name, value);
            return new AttributesRouterFunction<T>(this.delegate, attributes);
        }

        @Override
        public RouterFunction<T> withAttributes(Consumer<Map<String, Object>> attributesConsumer) {
            Assert.notNull(attributesConsumer, (String)"AttributesConsumer must not be null");
            LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>(this.attributes);
            attributesConsumer.accept(attributes);
            return new AttributesRouterFunction<T>(this.delegate, attributes);
        }
    }

    static final class FilteredRouterFunction<T extends ServerResponse, S extends ServerResponse>
    implements RouterFunction<S> {
        private final RouterFunction<T> routerFunction;
        private final HandlerFilterFunction<T, S> filterFunction;

        public FilteredRouterFunction(RouterFunction<T> routerFunction, HandlerFilterFunction<T, S> filterFunction) {
            this.routerFunction = routerFunction;
            this.filterFunction = filterFunction;
        }

        @Override
        public Optional<HandlerFunction<S>> route(ServerRequest request) {
            return this.routerFunction.route(request).map(this.filterFunction::apply);
        }

        @Override
        public void accept(Visitor visitor) {
            this.routerFunction.accept(visitor);
        }

        public String toString() {
            return this.routerFunction.toString();
        }
    }

    static final class DifferentComposedRouterFunction
    extends AbstractRouterFunction<ServerResponse> {
        private final RouterFunction<?> first;
        private final RouterFunction<?> second;

        public DifferentComposedRouterFunction(RouterFunction<?> first, RouterFunction<?> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public Optional<HandlerFunction<ServerResponse>> route(ServerRequest request) {
            Optional<HandlerFunction<ServerResponse>> firstRoute = this.first.route(request);
            if (firstRoute.isPresent()) {
                return firstRoute;
            }
            Optional<HandlerFunction<ServerResponse>> secondRoute = this.second.route(request);
            return secondRoute;
        }

        @Override
        public void accept(Visitor visitor) {
            this.first.accept(visitor);
            this.second.accept(visitor);
        }
    }

    static final class SameComposedRouterFunction<T extends ServerResponse>
    extends AbstractRouterFunction<T> {
        private final RouterFunction<T> first;
        private final RouterFunction<T> second;

        public SameComposedRouterFunction(RouterFunction<T> first, RouterFunction<T> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public Optional<HandlerFunction<T>> route(ServerRequest request) {
            Optional<HandlerFunction<T>> firstRoute = this.first.route(request);
            if (firstRoute.isPresent()) {
                return firstRoute;
            }
            return this.second.route(request);
        }

        @Override
        public void accept(Visitor visitor) {
            this.first.accept(visitor);
            this.second.accept(visitor);
        }
    }

    static abstract class AbstractRouterFunction<T extends ServerResponse>
    implements RouterFunction<T> {
        AbstractRouterFunction() {
        }

        public String toString() {
            ToStringVisitor visitor = new ToStringVisitor();
            this.accept(visitor);
            return visitor.toString();
        }
    }

    public static interface Builder {
        public <T extends ServerResponse> Builder GET(HandlerFunction<T> var1);

        public <T extends ServerResponse> Builder GET(String var1, HandlerFunction<T> var2);

        public <T extends ServerResponse> Builder GET(RequestPredicate var1, HandlerFunction<T> var2);

        public <T extends ServerResponse> Builder GET(String var1, RequestPredicate var2, HandlerFunction<T> var3);

        public <T extends ServerResponse> Builder HEAD(HandlerFunction<T> var1);

        public <T extends ServerResponse> Builder HEAD(String var1, HandlerFunction<T> var2);

        public <T extends ServerResponse> Builder HEAD(RequestPredicate var1, HandlerFunction<T> var2);

        public <T extends ServerResponse> Builder HEAD(String var1, RequestPredicate var2, HandlerFunction<T> var3);

        public <T extends ServerResponse> Builder POST(HandlerFunction<T> var1);

        public <T extends ServerResponse> Builder POST(String var1, HandlerFunction<T> var2);

        public <T extends ServerResponse> Builder POST(RequestPredicate var1, HandlerFunction<T> var2);

        public <T extends ServerResponse> Builder POST(String var1, RequestPredicate var2, HandlerFunction<T> var3);

        public <T extends ServerResponse> Builder PUT(HandlerFunction<T> var1);

        public <T extends ServerResponse> Builder PUT(String var1, HandlerFunction<T> var2);

        public <T extends ServerResponse> Builder PUT(RequestPredicate var1, HandlerFunction<T> var2);

        public <T extends ServerResponse> Builder PUT(String var1, RequestPredicate var2, HandlerFunction<T> var3);

        public <T extends ServerResponse> Builder PATCH(HandlerFunction<T> var1);

        public <T extends ServerResponse> Builder PATCH(String var1, HandlerFunction<T> var2);

        public <T extends ServerResponse> Builder PATCH(RequestPredicate var1, HandlerFunction<T> var2);

        public <T extends ServerResponse> Builder PATCH(String var1, RequestPredicate var2, HandlerFunction<T> var3);

        public <T extends ServerResponse> Builder DELETE(HandlerFunction<T> var1);

        public <T extends ServerResponse> Builder DELETE(String var1, HandlerFunction<T> var2);

        public <T extends ServerResponse> Builder DELETE(RequestPredicate var1, HandlerFunction<T> var2);

        public <T extends ServerResponse> Builder DELETE(String var1, RequestPredicate var2, HandlerFunction<T> var3);

        public <T extends ServerResponse> Builder OPTIONS(HandlerFunction<T> var1);

        public <T extends ServerResponse> Builder OPTIONS(String var1, HandlerFunction<T> var2);

        public <T extends ServerResponse> Builder OPTIONS(RequestPredicate var1, HandlerFunction<T> var2);

        public <T extends ServerResponse> Builder OPTIONS(String var1, RequestPredicate var2, HandlerFunction<T> var3);

        public <T extends ServerResponse> Builder route(RequestPredicate var1, HandlerFunction<T> var2);

        public <T extends ServerResponse> Builder add(RouterFunction<T> var1);

        public Builder resource(RequestPredicate var1, Resource var2);

        public Builder resource(RequestPredicate var1, Resource var2, BiConsumer<Resource, HttpHeaders> var3);

        public Builder resources(String var1, Resource var2);

        public Builder resources(String var1, Resource var2, BiConsumer<Resource, HttpHeaders> var3);

        public Builder resources(Function<ServerRequest, Optional<Resource>> var1);

        public Builder resources(Function<ServerRequest, Optional<Resource>> var1, BiConsumer<Resource, HttpHeaders> var2);

        public <T extends ServerResponse> Builder nest(RequestPredicate var1, Supplier<RouterFunction<T>> var2);

        public Builder nest(RequestPredicate var1, Consumer<Builder> var2);

        public <T extends ServerResponse> Builder path(String var1, Supplier<RouterFunction<T>> var2);

        public Builder path(String var1, Consumer<Builder> var2);

        public <T extends ServerResponse, R extends ServerResponse> Builder filter(HandlerFilterFunction<T, R> var1);

        public Builder before(Function<ServerRequest, ServerRequest> var1);

        public <T extends ServerResponse, R extends ServerResponse> Builder after(BiFunction<ServerRequest, T, R> var1);

        public <T extends ServerResponse> Builder onError(Predicate<Throwable> var1, BiFunction<Throwable, ServerRequest, T> var2);

        public <T extends ServerResponse> Builder onError(Class<? extends Throwable> var1, BiFunction<Throwable, ServerRequest, T> var2);

        public Builder withAttribute(String var1, Object var2);

        public Builder withAttributes(Consumer<Map<String, Object>> var1);

        public RouterFunction<ServerResponse> build();
    }
}

