/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.HttpHeadResponseDecorator;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServletServerHttpRequest;
import org.springframework.http.server.reactive.ServletServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@WebServlet(asyncSupported=true)
public class ServletHttpHandlerAdapter
implements Servlet {
    private static final Log logger = LogFactory.getLog(ServletHttpHandlerAdapter.class);
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final HttpHandler httpHandler;
    private int bufferSize = 8192;
    private DataBufferFactory dataBufferFactory = new DefaultDataBufferFactory(false);
    private static final AsyncListener ERROR_LISTENER = new AsyncListener(){

        public void onTimeout(AsyncEvent event) throws IOException {
            AsyncContext context = event.getAsyncContext();
            ServletHttpHandlerAdapter.runIfAsyncNotComplete(context, () -> ((AsyncContext)context).complete());
        }

        public void onError(AsyncEvent event) throws IOException {
            AsyncContext context = event.getAsyncContext();
            ServletHttpHandlerAdapter.runIfAsyncNotComplete(context, () -> ((AsyncContext)context).complete());
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    };

    public ServletHttpHandlerAdapter(HttpHandler httpHandler) {
        Assert.notNull((Object)httpHandler, (String)"HttpHandler must not be null");
        this.httpHandler = httpHandler;
    }

    public void setBufferSize(int bufferSize) {
        Assert.isTrue((bufferSize > 0 ? 1 : 0) != 0, (String)"Buffer size must be larger than zero");
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setDataBufferFactory(DataBufferFactory dataBufferFactory) {
        Assert.notNull((Object)dataBufferFactory, (String)"DataBufferFactory must not be null");
        this.dataBufferFactory = dataBufferFactory;
    }

    public DataBufferFactory getDataBufferFactory() {
        return this.dataBufferFactory;
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException {
        AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(-1L);
        ServerHttpRequest httpRequest = this.createRequest((HttpServletRequest)request, asyncContext);
        ServerHttpResponse httpResponse = this.createResponse((HttpServletResponse)response, asyncContext);
        if (HttpMethod.HEAD.equals((Object)httpRequest.getMethod())) {
            httpResponse = new HttpHeadResponseDecorator(httpResponse);
        }
        asyncContext.addListener(ERROR_LISTENER);
        HandlerResultSubscriber subscriber = new HandlerResultSubscriber(asyncContext);
        this.httpHandler.handle(httpRequest, httpResponse).subscribe((Subscriber)subscriber);
    }

    protected ServerHttpRequest createRequest(HttpServletRequest request, AsyncContext context) throws IOException {
        return new ServletServerHttpRequest(request, context, this.getDataBufferFactory(), this.getBufferSize());
    }

    protected ServerHttpResponse createResponse(HttpServletResponse response, AsyncContext context) throws IOException {
        return new ServletServerHttpResponse(response, context, this.getDataBufferFactory(), this.getBufferSize());
    }

    public void init(ServletConfig config) {
    }

    @Nullable
    public ServletConfig getServletConfig() {
        return null;
    }

    public String getServletInfo() {
        return "";
    }

    public void destroy() {
    }

    private static void runIfAsyncNotComplete(AsyncContext asyncContext, Runnable task) {
        try {
            if (asyncContext.getRequest().isAsyncStarted()) {
                task.run();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private class HandlerResultSubscriber
    implements Subscriber<Void> {
        private final AsyncContext asyncContext;

        HandlerResultSubscriber(AsyncContext asyncContext) {
            this.asyncContext = asyncContext;
        }

        public void onSubscribe(Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        public void onNext(Void aVoid) {
        }

        public void onError(Throwable ex) {
            ServletHttpHandlerAdapter.runIfAsyncNotComplete(this.asyncContext, () -> {
                logger.error((Object)"Could not complete request", ex);
                HttpServletResponse response = (HttpServletResponse)this.asyncContext.getResponse();
                response.setStatus(500);
                this.asyncContext.complete();
            });
        }

        public void onComplete() {
            ServletHttpHandlerAdapter.runIfAsyncNotComplete(this.asyncContext, () -> {
                logger.debug((Object)"Successfully completed request");
                this.asyncContext.complete();
            });
        }
    }
}

