/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.authentication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.AuthenticationSource;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.ldap.userdetails.LdapUserDetails;
import org.springframework.util.Assert;

public class SpringSecurityAuthenticationSource
implements AuthenticationSource {
    private static final Log log = LogFactory.getLog(SpringSecurityAuthenticationSource.class);
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();

    public String getPrincipal() {
        Authentication authentication = this.securityContextHolderStrategy.getContext().getAuthentication();
        if (authentication == null) {
            log.debug((Object)"Returning empty String as Principal since authentication is null");
            return "";
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof LdapUserDetails) {
            LdapUserDetails details = (LdapUserDetails)principal;
            return details.getDn();
        }
        if (authentication instanceof AnonymousAuthenticationToken) {
            log.debug((Object)"Returning empty String as Principal since authentication is anonymous");
            return "";
        }
        throw new IllegalArgumentException("The principal property of the authentication objectneeds to be an LdapUserDetails.");
    }

    public String getCredentials() {
        Authentication authentication = this.securityContextHolderStrategy.getContext().getAuthentication();
        if (authentication == null) {
            log.debug((Object)"Returning empty String as Credentials since authentication is null");
            return "";
        }
        return (String)authentication.getCredentials();
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }
}

