/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.sql.PreparedStatement;
import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.jdbc.ExpressionEvaluatingSqlParameterSourceFactory;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;

public class JdbcPollingChannelAdapter
extends AbstractMessageSource<Object> {
    private final NamedParameterJdbcOperations jdbcOperations;
    private final String selectQuery;
    private RowMapper<?> rowMapper;
    private SqlParameterSource sqlQueryParameterSource;
    private boolean updatePerRow = false;
    private String updateSql;
    private SqlParameterSourceFactory sqlParameterSourceFactory = new ExpressionEvaluatingSqlParameterSourceFactory();
    private boolean sqlParameterSourceFactorySet;
    private int maxRows = 0;

    public JdbcPollingChannelAdapter(DataSource dataSource, String selectQuery) {
        this((JdbcOperations)new JdbcTemplate(dataSource), selectQuery);
    }

    public JdbcPollingChannelAdapter(JdbcOperations jdbcOperations, String selectQuery) {
        Assert.hasText((String)selectQuery, (String)"'selectQuery' must be specified.");
        this.jdbcOperations = new NamedParameterJdbcTemplate(jdbcOperations){

            protected PreparedStatementCreator getPreparedStatementCreator(String sql, SqlParameterSource paramSource, Consumer<PreparedStatementCreatorFactory> customizer) {
                PreparedStatementCreator preparedStatementCreator = super.getPreparedStatementCreator(sql, paramSource, customizer);
                return con -> {
                    PreparedStatement preparedStatement = preparedStatementCreator.createPreparedStatement(con);
                    preparedStatement.setMaxRows(JdbcPollingChannelAdapter.this.maxRows);
                    return preparedStatement;
                };
            }
        };
        this.selectQuery = selectQuery;
    }

    public void setRowMapper(RowMapper<?> rowMapper) {
        this.rowMapper = rowMapper;
    }

    public void setUpdateSql(String updateSql) {
        this.updateSql = updateSql;
    }

    public void setUpdatePerRow(boolean updatePerRow) {
        this.updatePerRow = updatePerRow;
    }

    public void setUpdateSqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        this.sqlParameterSourceFactory = sqlParameterSourceFactory;
        this.sqlParameterSourceFactorySet = true;
    }

    public void setSelectSqlParameterSource(SqlParameterSource sqlQueryParameterSource) {
        this.sqlQueryParameterSource = sqlQueryParameterSource;
    }

    @Deprecated
    public void setMaxRowsPerPoll(int maxRows) {
        this.setMaxRows(maxRows);
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    protected void onInit() {
        if (!this.sqlParameterSourceFactorySet && this.getBeanFactory() != null) {
            ((ExpressionEvaluatingSqlParameterSourceFactory)this.sqlParameterSourceFactory).setBeanFactory(this.getBeanFactory());
        }
    }

    public String getComponentType() {
        return "jdbc:inbound-channel-adapter";
    }

    protected Object doReceive() {
        List<?> payload = this.doPoll(this.sqlQueryParameterSource);
        if (payload.size() < 1) {
            payload = null;
        }
        if (payload != null && this.updateSql != null) {
            if (this.updatePerRow) {
                for (Object row : payload) {
                    this.executeUpdateQuery(row);
                }
            } else {
                this.executeUpdateQuery(payload);
            }
        }
        return payload;
    }

    protected List<?> doPoll(SqlParameterSource sqlQueryParameterSource) {
        ColumnMapRowMapper rowMapper;
        ColumnMapRowMapper columnMapRowMapper = rowMapper = this.rowMapper == null ? new ColumnMapRowMapper() : this.rowMapper;
        if (sqlQueryParameterSource != null) {
            return this.jdbcOperations.query(this.selectQuery, sqlQueryParameterSource, (RowMapper)rowMapper);
        }
        return this.jdbcOperations.query(this.selectQuery, (RowMapper)rowMapper);
    }

    private void executeUpdateQuery(Object obj) {
        SqlParameterSource updateParameterSource = this.sqlParameterSourceFactory.createParameterSource(obj);
        this.jdbcOperations.update(this.updateSql, updateParameterSource);
    }
}

