/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionException;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ExpressionEvaluatingSqlParameterSourceFactory
extends AbstractExpressionEvaluator
implements SqlParameterSourceFactory {
    private static final Log logger = LogFactory.getLog(ExpressionEvaluatingSqlParameterSourceFactory.class);
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private static final Object ERROR = new Object();
    private volatile Map<String, ?> staticParameters = Collections.unmodifiableMap(new HashMap());
    private volatile Map<String, Integer> sqlParametersTypes;
    private volatile Map<String, Expression[]> parameterExpressions = new HashMap<String, Expression[]>();

    public void setStaticParameters(Map<String, ?> staticParameters) {
        this.staticParameters = staticParameters;
    }

    public void setParameterExpressions(Map<String, String> parameterExpressions) {
        HashMap<String, Expression[]> paramExpressions = new HashMap<String, Expression[]>(parameterExpressions.size());
        for (Map.Entry<String, String> entry : parameterExpressions.entrySet()) {
            String key = entry.getKey();
            String expression = entry.getValue();
            Expression[] expressions = new Expression[]{PARSER.parseExpression(expression), PARSER.parseExpression("#root.![" + expression + "]")};
            paramExpressions.put(key, expressions);
        }
        this.parameterExpressions = paramExpressions;
    }

    public void setSqlParameterTypes(Map<String, Integer> sqlParametersTypes) {
        this.sqlParametersTypes = sqlParametersTypes;
    }

    @Override
    public SqlParameterSource createParameterSource(Object input) {
        return new ExpressionEvaluatingSqlParameterSource(input, this.staticParameters, this.parameterExpressions, true);
    }

    public SqlParameterSource createParameterSourceNoCache(Object input) {
        return new ExpressionEvaluatingSqlParameterSource(input, this.staticParameters, this.parameterExpressions, false);
    }

    protected void onInit() {
        this.getEvaluationContext().setVariable("staticParameters", this.staticParameters);
    }

    private final class ExpressionEvaluatingSqlParameterSource
    extends AbstractSqlParameterSource {
        private final Object input;
        private final Map<String, Object> values = new HashMap<String, Object>();
        private final Map<String, Expression[]> parameterExpressions;
        private final boolean cache;

        ExpressionEvaluatingSqlParameterSource(Object input, Map<String, ?> staticParameters, Map<String, Expression[]> parameterExpressions, boolean cache) {
            this.input = input;
            this.parameterExpressions = parameterExpressions;
            this.values.putAll(staticParameters);
            this.cache = cache;
            if (ExpressionEvaluatingSqlParameterSourceFactory.this.sqlParametersTypes != null) {
                ExpressionEvaluatingSqlParameterSourceFactory.this.sqlParametersTypes.forEach((arg_0, arg_1) -> ((ExpressionEvaluatingSqlParameterSource)this).registerSqlType(arg_0, arg_1));
            }
        }

        public Object getValue(String paramName) throws IllegalArgumentException {
            return this.doGetValue(paramName, false);
        }

        public Object doGetValue(String paramName, boolean calledFromHasValue) throws IllegalArgumentException {
            if (this.values.containsKey(paramName)) {
                Object cachedByHasValue = this.values.get(paramName);
                if (!this.cache) {
                    this.values.remove(paramName);
                }
                return cachedByHasValue;
            }
            if (!this.parameterExpressions.containsKey(paramName)) {
                Expression[] expressions = new Expression[]{PARSER.parseExpression(paramName), PARSER.parseExpression("#root.![" + paramName + "]")};
                ExpressionEvaluatingSqlParameterSourceFactory.this.parameterExpressions.put(paramName, expressions);
                this.parameterExpressions.put(paramName, expressions);
            }
            Expression expression = null;
            expression = this.input instanceof Collection ? this.parameterExpressions.get(paramName)[1] : this.parameterExpressions.get(paramName)[0];
            Object value = ExpressionEvaluatingSqlParameterSourceFactory.this.evaluateExpression(expression, this.input);
            if (this.cache || calledFromHasValue) {
                this.values.put(paramName, value);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resolved expression " + expression + " to " + value));
            }
            return value;
        }

        public boolean hasValue(String paramName) {
            try {
                Object value = this.doGetValue(paramName, true);
                if (value == ERROR) {
                    return false;
                }
            }
            catch (ExpressionException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Could not evaluate expression", (Throwable)e);
                }
                if (this.cache) {
                    this.values.put(paramName, ERROR);
                }
                return false;
            }
            return true;
        }
    }
}

