/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.jspecify.annotations.Nullable;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Values;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.ExpressionVisitor;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;

class ValuesVisitor
extends TypedSubtreeVisitor<Values> {
    private final RenderTarget parent;
    private final StringBuilder builder = new StringBuilder();
    private final RenderContext context;
    private @Nullable ExpressionVisitor current;
    private boolean first = true;

    ValuesVisitor(RenderContext context, RenderTarget parent) {
        this.context = context;
        this.parent = parent;
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        if (segment instanceof Expression) {
            this.current = new ExpressionVisitor(this.context);
            return DelegatingVisitor.Delegation.delegateTo(this.current);
        }
        return super.enterNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (this.current != null) {
            if (this.first) {
                this.first = false;
            } else {
                this.builder.append(", ");
            }
            this.builder.append(this.current.getRenderedPart());
            this.current = null;
        }
        return super.leaveNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(Values segment) {
        this.parent.onRendered(this.builder);
        return super.leaveMatched(segment);
    }
}

