/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.PartTreeMongoQuery;
import org.springframework.data.mongodb.repository.query.StringBasedAggregation;
import org.springframework.data.mongodb.repository.query.StringBasedMongoQuery;
import org.springframework.data.mongodb.repository.support.CrudMethodMetadataPostProcessor;
import org.springframework.data.mongodb.repository.support.MongoEntityInformationSupport;
import org.springframework.data.mongodb.repository.support.QuerydslMongoPredicateExecutor;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodValueEvaluationContextAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MongoRepositoryFactory
extends RepositoryFactorySupport {
    private final CrudMethodMetadataPostProcessor crudMethodMetadataPostProcessor = new CrudMethodMetadataPostProcessor();
    private final MongoOperations operations;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    @Nullable
    private QueryMethodValueEvaluationContextAccessor accessor;

    public MongoRepositoryFactory(MongoOperations mongoOperations) {
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null");
        this.operations = mongoOperations;
        this.mappingContext = mongoOperations.getConverter().getMappingContext();
        this.addRepositoryProxyPostProcessor(this.crudMethodMetadataPostProcessor);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        this.crudMethodMetadataPostProcessor.setBeanClassLoader(classLoader);
    }

    protected ProjectionFactory getProjectionFactory(ClassLoader classLoader, BeanFactory beanFactory) {
        return this.operations.getConverter().getProjectionFactory();
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleMongoRepository.class;
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        return this.getRepositoryFragments(metadata, this.operations);
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata, MongoOperations operations) {
        boolean isQueryDslRepository;
        boolean bl = isQueryDslRepository = QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(metadata.getRepositoryInterface());
        if (isQueryDslRepository) {
            if (metadata.isReactiveRepository()) {
                throw new InvalidDataAccessApiUsageException("Cannot combine Querydsl and reactive repository support in a single interface");
            }
            return RepositoryComposition.RepositoryFragments.just((Object[])new Object[]{new QuerydslMongoPredicateExecutor(this.getEntityInformation(metadata.getDomainType()), operations)});
        }
        return RepositoryComposition.RepositoryFragments.empty();
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        MongoEntityInformation entityInformation = this.getEntityInformation(information.getDomainType(), (RepositoryMetadata)information);
        Object targetRepository = this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.operations});
        if (targetRepository instanceof SimpleMongoRepository) {
            SimpleMongoRepository repository = (SimpleMongoRepository)targetRepository;
            repository.setRepositoryMethodMetadata(this.crudMethodMetadataPostProcessor.getCrudMethodMetadata());
        }
        return targetRepository;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        return Optional.of(new MongoQueryLookupStrategy(this.operations, this.mappingContext, valueExpressionDelegate));
    }

    public <T, ID> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return this.getEntityInformation(domainClass, null);
    }

    private <T, ID> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass, @Nullable RepositoryMetadata metadata) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return MongoEntityInformationSupport.entityInformationFor(entity, metadata != null ? metadata.getIdType() : null);
    }

    private record MongoQueryLookupStrategy(MongoOperations operations, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, ValueExpressionDelegate expressionSupport) implements QueryLookupStrategy
    {
        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            MongoQueryMethod queryMethod = new MongoQueryMethod(method, metadata, factory, this.mappingContext);
            queryMethod.verify();
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedMongoQuery(namedQuery, queryMethod, this.operations, this.expressionSupport);
            }
            if (queryMethod.hasAnnotatedAggregation()) {
                return new StringBasedAggregation(queryMethod, this.operations, this.expressionSupport);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedMongoQuery(queryMethod, this.operations, this.expressionSupport);
            }
            return new PartTreeMongoQuery(queryMethod, this.operations, this.expressionSupport);
        }
    }
}

