/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.query.QueryInformationHolder;
import org.springframework.data.jpa.repository.query.QueryToken;

class QueryInformation {
    @Nullable
    private final String alias;
    private final List<QueryToken> projection;
    private final boolean hasConstructorExpression;
    private final StatementType statementType;

    QueryInformation(QueryInformationHolder introspection) {
        this.alias = introspection.getAlias();
        this.projection = introspection.getProjection();
        this.hasConstructorExpression = introspection.hasConstructorExpression();
        this.statementType = introspection.getStatementType();
    }

    @Nullable
    public String getAlias() {
        return this.alias;
    }

    public List<QueryToken> getProjection() {
        return this.projection;
    }

    public boolean hasConstructorExpression() {
        return this.hasConstructorExpression;
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public boolean isSelectStatement() {
        return this.statementType == StatementType.SELECT;
    }

    static enum StatementType {
        SELECT,
        INSERT,
        UPDATE,
        DELETE,
        MERGE,
        OTHER;

    }
}

