/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.ParameterBinding;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryEnhancerFactory;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.ValueExpressionQueryRewriter;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class StringQuery
implements DeclaredQuery {
    private final String query;
    private final List<ParameterBinding> bindings;
    private final boolean containsPageableInSpel;
    private final boolean usesJdbcStyleParameters;
    private final boolean isNative;
    private final QueryEnhancer queryEnhancer;
    private final boolean hasNamedParameters;

    public StringQuery(String query, boolean isNative) {
        this(query, isNative, it -> {});
    }

    private StringQuery(String query, boolean isNative, Consumer<List<ParameterBinding>> parameterPostProcessor) {
        Assert.hasText((String)query, (String)"Query must not be null or empty");
        this.isNative = isNative;
        this.bindings = new ArrayList<ParameterBinding>();
        this.containsPageableInSpel = query.contains("#pageable");
        Metadata queryMeta = new Metadata();
        this.query = ParameterBindingParser.INSTANCE.parseParameterBindingsOfQueryIntoBindingsAndReturnCleanedQuery(query, this.bindings, queryMeta);
        this.usesJdbcStyleParameters = queryMeta.usesJdbcStyleParameters;
        this.queryEnhancer = QueryEnhancerFactory.forQuery(this);
        parameterPostProcessor.accept(this.bindings);
        boolean hasNamedParameters = false;
        for (ParameterBinding parameterBinding : this.getParameterBindings()) {
            if (!parameterBinding.getIdentifier().hasName() || !parameterBinding.getOrigin().isMethodArgument()) continue;
            hasNamedParameters = true;
            break;
        }
        this.hasNamedParameters = hasNamedParameters;
    }

    boolean hasParameterBindings() {
        return !this.bindings.isEmpty();
    }

    String getProjection() {
        return this.queryEnhancer.getProjection();
    }

    @Override
    public List<ParameterBinding> getParameterBindings() {
        return this.bindings;
    }

    @Override
    public DeclaredQuery deriveCountQuery(@Nullable String countQueryProjection) {
        return new StringQuery(this.queryEnhancer.createCountQueryFor(countQueryProjection), this.isNative, derivedBindings -> {
            if (this.hasParameterBindings() && !this.getParameterBindings().equals(derivedBindings)) {
                for (ParameterBinding binding : this.bindings) {
                    Predicate<ParameterBinding> identifier = binding::bindsTo;
                    Predicate<ParameterBinding> notCompatible = Predicate.not(binding::isCompatibleWith);
                    if (!derivedBindings.removeIf(it -> identifier.test((ParameterBinding)it) && notCompatible.test((ParameterBinding)it))) continue;
                    derivedBindings.add(binding);
                }
            }
        });
    }

    @Override
    public boolean usesJdbcStyleParameters() {
        return this.usesJdbcStyleParameters;
    }

    @Override
    public String getQueryString() {
        return this.query;
    }

    @Override
    @Nullable
    public String getAlias() {
        return this.queryEnhancer.detectAlias();
    }

    @Override
    public boolean hasConstructorExpression() {
        return this.queryEnhancer.hasConstructorExpression();
    }

    @Override
    public boolean isDefaultProjection() {
        return this.getProjection().equalsIgnoreCase(this.getAlias());
    }

    @Override
    public boolean hasNamedParameter() {
        return this.hasNamedParameters;
    }

    @Override
    public boolean usesPaging() {
        return this.containsPageableInSpel;
    }

    @Override
    public boolean isNativeQuery() {
        return this.isNative;
    }

    static class IndexedParameterLabels {
        private final TreeSet<Integer> usedLabels;
        private final boolean sequential;

        public IndexedParameterLabels(Set<Integer> usedLabels) {
            TreeSet<Integer> treeSet;
            if (usedLabels instanceof TreeSet) {
                TreeSet ts = (TreeSet)usedLabels;
                treeSet = ts;
            } else {
                treeSet = new TreeSet<Integer>(usedLabels);
            }
            this.usedLabels = treeSet;
            this.sequential = IndexedParameterLabels.isSequential(usedLabels);
        }

        private static boolean isSequential(Set<Integer> usedLabels) {
            int i = 0;
            while (i < usedLabels.size()) {
                if (!usedLabels.contains(i + 1)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int allocate() {
            if (this.sequential) {
                int index = this.usedLabels.size() + 1;
                this.usedLabels.add(index);
                return index;
            }
            int attempts = this.usedLabels.last() + 1;
            int index = this.attemptAllocate(attempts);
            if (index == -1) {
                throw new IllegalStateException("Unable to allocate a unique parameter label. All possible labels have been used.");
            }
            this.usedLabels.add(index);
            return index;
        }

        private int attemptAllocate(int attempts) {
            int i = 0;
            while (i < attempts) {
                if (!this.usedLabels.contains(i + 1)) {
                    return i + 1;
                }
                ++i;
            }
            return -1;
        }

        public boolean hasLabels() {
            return !this.usedLabels.isEmpty();
        }
    }

    static class Metadata {
        private boolean usesJdbcStyleParameters = false;

        Metadata() {
        }
    }

    static enum ParameterBindingParser {
        INSTANCE;

        private static final String EXPRESSION_PARAMETER_PREFIX = "__$synthetic$__";
        public static final String POSITIONAL_OR_INDEXED_PARAMETER = "\\?(\\d*+(?![\\&\\|#\\w]))";
        private static final Pattern PARAMETER_BINDING_BY_INDEX;
        private static final Pattern PARAMETER_BINDING_PATTERN;
        private static final Pattern JDBC_STYLE_PARAM;
        private static final Pattern NUMBERED_STYLE_PARAM;
        private static final Pattern NAMED_STYLE_PARAM;
        private static final String MESSAGE = "Already found parameter binding with same index / parameter name but differing binding type; Already have: %s, found %s; If you bind a parameter multiple times make sure they use the same binding";
        private static final int INDEXED_PARAMETER_GROUP = 4;
        private static final int NAMED_PARAMETER_GROUP = 6;
        private static final int COMPARISION_TYPE_GROUP = 1;

        static {
            PARAMETER_BINDING_BY_INDEX = Pattern.compile(POSITIONAL_OR_INDEXED_PARAMETER);
            JDBC_STYLE_PARAM = Pattern.compile("(?!\\\\)\\?(?!\\d)");
            NUMBERED_STYLE_PARAM = Pattern.compile("(?!\\\\)\\?\\d");
            NAMED_STYLE_PARAM = Pattern.compile("(?!\\\\):\\w+");
            ArrayList<String> keywords = new ArrayList<String>();
            ParameterBindingType[] parameterBindingTypeArray = ParameterBindingType.values();
            int n = parameterBindingTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterBindingType type = parameterBindingTypeArray[n2];
                if (type.getKeyword() != null) {
                    keywords.add(type.getKeyword());
                }
                ++n2;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            builder.append(StringUtils.collectionToDelimitedString(keywords, (String)"|"));
            builder.append(")?");
            builder.append("(?: )?");
            builder.append("\\(?");
            builder.append("(");
            builder.append("%?(\\?(\\d*+(?![\\&\\|#\\w])))%?");
            builder.append("|");
            builder.append("%?((?<![:\\\\]):" + QueryUtils.IDENTIFIER_GROUP + ")%?");
            builder.append(")");
            builder.append("\\)?");
            PARAMETER_BINDING_PATTERN = Pattern.compile(builder.toString(), 2);
        }

        String parseParameterBindingsOfQueryIntoBindingsAndReturnCleanedQuery(String query, List<ParameterBinding> bindings, Metadata queryMeta) {
            IndexedParameterLabels parameterLabels = new IndexedParameterLabels(ParameterBindingParser.findParameterIndices(query));
            boolean parametersShouldBeAccessedByIndex = parameterLabels.hasLabels();
            if (!parametersShouldBeAccessedByIndex && query.contains("?#{")) {
                parametersShouldBeAccessedByIndex = true;
            }
            ValueExpressionQueryRewriter.ParsedQuery parsedQuery = ParameterBindingParser.createSpelExtractor(query, parametersShouldBeAccessedByIndex, parameterLabels);
            String resultingQuery = parsedQuery.getQueryString();
            Matcher matcher = PARAMETER_BINDING_PATTERN.matcher(resultingQuery);
            ParameterBindings parameterBindings = new ParameterBindings(bindings, it -> ParameterBindingParser.checkAndRegister(it, bindings));
            int currentIndex = 0;
            boolean usesJpaStyleParameters = false;
            while (matcher.find()) {
                Object result;
                if (parsedQuery.isQuoted(matcher.start())) continue;
                String parameterIndexString = matcher.group(4);
                String parameterName = parameterIndexString != null ? null : matcher.group(6);
                Integer parameterIndex = ParameterBindingParser.getParameterIndex(parameterIndexString);
                String match = matcher.group(0);
                Matcher jdbcStyleMatcher = JDBC_STYLE_PARAM.matcher(match);
                if (jdbcStyleMatcher.find()) {
                    queryMeta.usesJdbcStyleParameters = true;
                }
                if (NUMBERED_STYLE_PARAM.matcher(match).find() || NAMED_STYLE_PARAM.matcher(match).find()) {
                    usesJpaStyleParameters = true;
                }
                if (usesJpaStyleParameters && queryMeta.usesJdbcStyleParameters) {
                    throw new IllegalArgumentException("Mixing of ? parameters and other forms like ?1 is not supported");
                }
                String typeSource = matcher.group(1);
                Assert.isTrue((parameterIndexString != null || parameterName != null ? 1 : 0) != 0, () -> String.format("We need either a name or an index; Offending query string: %s", query));
                ValueExpression expression = parsedQuery.getParameter(parameterName == null ? parameterIndexString : parameterName);
                String replacement = null;
                if ("".equals(parameterIndexString)) {
                    parameterIndex = parameterLabels.allocate();
                }
                ParameterBinding.BindingIdentifier queryParameter = parameterIndex != null ? ParameterBinding.BindingIdentifier.of(parameterIndex) : ParameterBinding.BindingIdentifier.of(parameterName);
                Record origin = ObjectUtils.isEmpty((Object)expression) ? ParameterBinding.ParameterOrigin.ofParameter(parameterName, parameterIndex) : ParameterBinding.ParameterOrigin.ofExpression(expression);
                ParameterBinding.BindingIdentifier targetBinding = queryParameter;
                Function<ParameterBinding.BindingIdentifier, ParameterBinding> bindingFactory = switch (ParameterBindingType.of(typeSource)) {
                    case ParameterBindingType.LIKE -> {
                        Part.Type likeType = ParameterBinding.LikeParameterBinding.getLikeTypeFrom(matcher.group(2));
                        yield arg_0 -> ParameterBindingParser.lambda$2((ParameterBinding.ParameterOrigin)((Object)origin), likeType, arg_0);
                    }
                    case ParameterBindingType.IN -> arg_0 -> ParameterBindingParser.lambda$3((ParameterBinding.ParameterOrigin)((Object)origin), arg_0);
                    default -> arg_0 -> ParameterBindingParser.lambda$4((ParameterBinding.ParameterOrigin)((Object)origin), arg_0);
                };
                if (origin.isExpression()) {
                    parameterBindings.register(bindingFactory.apply(queryParameter));
                } else {
                    targetBinding = parameterBindings.register(queryParameter, (ParameterBinding.ParameterOrigin)((Object)origin), bindingFactory, parameterLabels);
                }
                replacement = targetBinding.hasName() ? ":" + targetBinding.getName() : (!usesJpaStyleParameters && queryMeta.usesJdbcStyleParameters ? "?" : "?" + targetBinding.getPosition());
                String substring = matcher.group(2);
                int index = resultingQuery.indexOf(substring, currentIndex);
                if (index < 0) {
                    result = resultingQuery;
                } else {
                    currentIndex = index + replacement.length();
                    result = resultingQuery.substring(0, index) + replacement + resultingQuery.substring(index + substring.length());
                }
                resultingQuery = result;
            }
            return resultingQuery;
        }

        private static ValueExpressionQueryRewriter.ParsedQuery createSpelExtractor(String queryWithSpel, boolean parametersShouldBeAccessedByIndex, IndexedParameterLabels parameterLabels) {
            BiFunction<Integer, String, String> indexToParameterName = parametersShouldBeAccessedByIndex ? (index, expression) -> String.valueOf(parameterLabels.allocate()) : (index, expression) -> EXPRESSION_PARAMETER_PREFIX + (index + 1);
            String fixedPrefix = parametersShouldBeAccessedByIndex ? "?" : ":";
            BiFunction<String, String, String> parameterNameToReplacement = (prefix, name) -> fixedPrefix + name;
            ValueExpressionQueryRewriter rewriter = ValueExpressionQueryRewriter.of((ValueExpressionParser)ValueExpressionParser.create(), indexToParameterName, parameterNameToReplacement);
            return rewriter.parse(queryWithSpel);
        }

        @Nullable
        private static Integer getParameterIndex(@Nullable String parameterIndexString) {
            if (parameterIndexString == null || parameterIndexString.isEmpty()) {
                return null;
            }
            return Integer.valueOf(parameterIndexString);
        }

        private static Set<Integer> findParameterIndices(String query) {
            Matcher parameterIndexMatcher = PARAMETER_BINDING_BY_INDEX.matcher(query);
            TreeSet<Integer> usedParameterIndices = new TreeSet<Integer>();
            while (parameterIndexMatcher.find()) {
                String parameterIndexString = parameterIndexMatcher.group(1);
                Integer parameterIndex = ParameterBindingParser.getParameterIndex(parameterIndexString);
                if (parameterIndex == null) continue;
                usedParameterIndices.add(parameterIndex);
            }
            return usedParameterIndices;
        }

        private static void checkAndRegister(ParameterBinding binding, List<ParameterBinding> bindings) {
            bindings.stream().filter(it -> it.bindsTo(binding)).forEach(it -> Assert.isTrue((boolean)it.equals(binding), (String)String.format(MESSAGE, it, binding)));
            if (!bindings.contains(binding)) {
                bindings.add(binding);
            }
        }

        private static /* synthetic */ ParameterBinding lambda$2(ParameterBinding.ParameterOrigin parameterOrigin, Part.Type type, ParameterBinding.BindingIdentifier identifier) {
            return new ParameterBinding.LikeParameterBinding(identifier, parameterOrigin, type);
        }

        private static /* synthetic */ ParameterBinding lambda$3(ParameterBinding.ParameterOrigin parameterOrigin, ParameterBinding.BindingIdentifier identifier) {
            return new ParameterBinding.InParameterBinding(identifier, parameterOrigin);
        }

        private static /* synthetic */ ParameterBinding lambda$4(ParameterBinding.ParameterOrigin parameterOrigin, ParameterBinding.BindingIdentifier identifier) {
            return new ParameterBinding(identifier, parameterOrigin);
        }

        private static enum ParameterBindingType {
            LIKE("like "),
            IN("in "),
            AS_IS(null);

            @Nullable
            private final String keyword;

            private ParameterBindingType(String keyword) {
                this.keyword = keyword;
            }

            @Nullable
            public String getKeyword() {
                return this.keyword;
            }

            static ParameterBindingType of(String typeSource) {
                if (!StringUtils.hasText((String)typeSource)) {
                    return AS_IS;
                }
                ParameterBindingType[] parameterBindingTypeArray = ParameterBindingType.values();
                int n = parameterBindingTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ParameterBindingType type = parameterBindingTypeArray[n2];
                    if (type.name().equalsIgnoreCase(typeSource.trim())) {
                        return type;
                    }
                    ++n2;
                }
                throw new IllegalArgumentException(String.format("Unsupported parameter binding type %s", typeSource));
            }
        }
    }

    static class ParameterBindings {
        private final MultiValueMap<ParameterBinding.BindingIdentifier, ParameterBinding> methodArgumentToLikeBindings = new LinkedMultiValueMap();
        private final Consumer<ParameterBinding> registration;

        public ParameterBindings(List<ParameterBinding> bindings, Consumer<ParameterBinding> registration) {
            for (ParameterBinding binding : bindings) {
                this.methodArgumentToLikeBindings.put((Object)binding.getIdentifier(), new ArrayList<ParameterBinding>(List.of(binding)));
            }
            this.registration = registration;
        }

        public boolean isBound(ParameterBinding.BindingIdentifier identifier) {
            return !this.getBindings(identifier).isEmpty();
        }

        ParameterBinding.BindingIdentifier register(ParameterBinding.BindingIdentifier identifier, ParameterBinding.ParameterOrigin origin, Function<ParameterBinding.BindingIdentifier, ParameterBinding> bindingFactory, IndexedParameterLabels parameterLabels) {
            ParameterBinding.BindingIdentifier syntheticIdentifier;
            Assert.isInstanceOf(ParameterBinding.MethodInvocationArgument.class, (Object)origin);
            ParameterBinding.BindingIdentifier methodArgument = ((ParameterBinding.MethodInvocationArgument)origin).identifier();
            List<ParameterBinding> bindingsForOrigin = this.getBindings(methodArgument);
            if (!this.isBound(identifier)) {
                ParameterBinding binding = bindingFactory.apply(identifier);
                this.registration.accept(binding);
                bindingsForOrigin.add(binding);
                return binding.getIdentifier();
            }
            ParameterBinding binding = bindingFactory.apply(identifier);
            for (ParameterBinding existing : bindingsForOrigin) {
                if (!existing.isCompatibleWith(binding)) continue;
                return existing.getIdentifier();
            }
            if (identifier.hasName() && methodArgument.hasName()) {
                int index = 0;
                Object newName = methodArgument.getName();
                while (this.existsBoundParameter((String)newName)) {
                    newName = methodArgument.getName() + "_" + ++index;
                }
                syntheticIdentifier = ParameterBinding.BindingIdentifier.of((String)newName);
            } else {
                syntheticIdentifier = ParameterBinding.BindingIdentifier.of(parameterLabels.allocate());
            }
            ParameterBinding newBinding = bindingFactory.apply(syntheticIdentifier);
            this.registration.accept(newBinding);
            bindingsForOrigin.add(newBinding);
            return newBinding.getIdentifier();
        }

        private boolean existsBoundParameter(String key) {
            return this.methodArgumentToLikeBindings.values().stream().flatMap(Collection::stream).anyMatch(it -> key.equals(it.getName()));
        }

        private List<ParameterBinding> getBindings(ParameterBinding.BindingIdentifier identifier) {
            return (List)this.methodArgumentToLikeBindings.computeIfAbsent((Object)identifier, s -> new ArrayList());
        }

        public void register(ParameterBinding parameterBinding) {
            this.registration.accept(parameterBinding);
        }
    }
}

