/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.SpelQueryContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SpelEvaluator {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    @NonNull
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    @NonNull
    private final Parameters<?, ?> parameters;
    @NonNull
    private final SpelQueryContext.SpelExtractor extractor;

    public Map<String, Object> evaluate(Object[] values) {
        Assert.notNull((Object)values, (String)"Values must not be null.");
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext(this.parameters, values);
        return this.extractor.getParameters().collect(Collectors.toMap(it -> (String)it.getKey(), it -> SpelEvaluator.getSpElValue(evaluationContext, (String)it.getValue())));
    }

    public String getQueryString() {
        return this.extractor.getQueryString();
    }

    @Nullable
    private static Object getSpElValue(EvaluationContext evaluationContext, String expression) {
        return PARSER.parseExpression(expression).getValue(evaluationContext);
    }

    public SpelEvaluator(@NonNull QueryMethodEvaluationContextProvider evaluationContextProvider, @NonNull Parameters<?, ?> parameters, @NonNull SpelQueryContext.SpelExtractor extractor) {
        if (evaluationContextProvider == null) {
            throw new IllegalArgumentException("evaluationContextProvider is marked @NonNull but is null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("parameters is marked @NonNull but is null");
        }
        if (extractor == null) {
            throw new IllegalArgumentException("extractor is marked @NonNull but is null");
        }
        this.evaluationContextProvider = evaluationContextProvider;
        this.parameters = parameters;
        this.extractor = extractor;
    }
}

