/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.Objects;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.springframework.cloud.sleuth.instrument.reactor.TraceContextPropagator;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.GroupedFlux;
import reactor.util.annotation.Nullable;

final class SleuthGroupedLift<K, I, O>
extends GroupedFlux<K, O>
implements Scannable,
TraceContextPropagator {
    final BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter;
    final GroupedFlux<K, I> source;

    SleuthGroupedLift(GroupedFlux<K, I> p, BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter) {
        this.source = Objects.requireNonNull(p, "source");
        this.lifter = lifter;
    }

    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    public K key() {
        return (K)this.source.key();
    }

    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }

    public String stepName() {
        if (this.source instanceof Scannable) {
            return Scannable.from(this.source).stepName();
        }
        return super.stepName();
    }

    public void subscribe(CoreSubscriber<? super O> actual) {
        CoreSubscriber<? super I> input = this.lifter.apply((Publisher)this.source, (CoreSubscriber<O>)actual);
        Objects.requireNonNull(input, "Lifted subscriber MUST NOT be null");
        this.source.subscribe(input);
    }
}

