/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Function;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.MessageHeaderPropagatorSetter;
import org.springframework.cloud.sleuth.instrument.messaging.MessageSpanCustomizer;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class TracingChannelInterceptor
implements ExecutorChannelInterceptor,
ApplicationContextAware {
    public static final String STREAM_DIRECT_CHANNEL = "org.springframework.cloud.stream.messaging.DirectWithAttributesChannel";
    private static final LogAccessor log = new LogAccessor(TracingChannelInterceptor.class);
    private static final String REMOTE_SERVICE_NAME = "broker";
    private static final boolean hasDirectChannelClass = ClassUtils.isPresent((String)"org.springframework.integration.channel.DirectChannel", null);
    private static final boolean hasBinderTypeRegistry = ClassUtils.isPresent((String)"org.springframework.cloud.stream.binder.BinderTypeRegistry", null);
    private static final Class<?> directWithAttributesChannelClass = ClassUtils.isPresent((String)"org.springframework.cloud.stream.messaging.DirectWithAttributesChannel", null) ? ClassUtils.resolveClassName((String)"org.springframework.cloud.stream.messaging.DirectWithAttributesChannel", null) : null;
    private final ThreadLocalSpan threadLocalSpan = new ThreadLocalSpan();
    private final Tracer tracer;
    private final Propagator.Setter<MessageHeaderAccessor> injector;
    private final Propagator.Getter<MessageHeaderAccessor> extractor;
    private final MessageSpanCustomizer messageSpanCustomizer;
    private final Propagator propagator;
    private final Function<String, String> remoteServiceNameMapper;
    private ApplicationContext applicationContext;

    public TracingChannelInterceptor(Tracer tracer, Propagator propagator, Propagator.Setter<MessageHeaderAccessor> setter, Propagator.Getter<MessageHeaderAccessor> getter, Function<String, String> remoteServiceNameMapper, MessageSpanCustomizer messageSpanCustomizer) {
        this.tracer = tracer;
        this.propagator = propagator;
        this.injector = setter;
        this.extractor = getter;
        this.remoteServiceNameMapper = remoteServiceNameMapper;
        this.messageSpanCustomizer = messageSpanCustomizer;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        Message<?> retrievedMessage = TracingChannelInterceptor.getMessage(message);
        log.debug(() -> "Received a message in pre-send " + retrievedMessage);
        MessageHeaderAccessor headers = TracingChannelInterceptor.mutableHeaderAccessor(retrievedMessage);
        Span.Builder spanBuilder = this.propagator.extract((Object)headers, this.extractor);
        MessageHeaderPropagatorSetter.removeAnyTraceHeaders(headers, this.propagator.fields());
        spanBuilder = spanBuilder.kind(Span.Kind.PRODUCER);
        spanBuilder = this.messageSpanCustomizer.customizeSend(spanBuilder, message, channel).remoteServiceName(TracingChannelInterceptor.toRemoteServiceName(headers, this.remoteServiceNameMapper, this.applicationContext));
        Span span = spanBuilder.start();
        log.debug(() -> "Extracted result from headers " + span);
        this.setSpanInScope(span);
        this.propagator.inject(span.context(), (Object)headers, this.injector);
        log.debug(() -> "Created a new span in pre send " + span);
        Message<?> outputMessage = this.outputMessage(message, retrievedMessage, headers);
        if (TracingChannelInterceptor.isDirectChannel(channel)) {
            this.beforeHandle(outputMessage, channel, null);
        }
        return outputMessage;
    }

    private void setSpanInScope(Span span) {
        Tracer.SpanInScope spanInScope = this.tracer.withSpan(span);
        this.threadLocalSpan.set(new SpanAndScope(span, spanInScope));
        log.debug(() -> "Put span in scope " + span);
    }

    private static String toRemoteServiceName(MessageHeaderAccessor headers, Function<String, String> remoteServiceNameMapper, ApplicationContext applicationContext) {
        for (String key : headers.getMessageHeaders().keySet()) {
            String remoteServiceName = remoteServiceNameMapper.apply(key);
            if (!StringUtils.hasText((String)remoteServiceName)) continue;
            return remoteServiceName;
        }
        if (hasBinderTypeRegistry && applicationContext != null) {
            BinderTypeRegistry typeRegistry = (BinderTypeRegistry)applicationContext.getBean(BinderTypeRegistry.class);
            Set binderNames = typeRegistry.getAll().keySet();
            for (String binderName : binderNames) {
                String remoteServiceName = remoteServiceNameMapper.apply(binderName);
                if (!StringUtils.hasText((String)remoteServiceName)) continue;
                return remoteServiceName;
            }
        }
        return REMOTE_SERVICE_NAME;
    }

    private Message<?> outputMessage(Message<?> originalMessage, Message<?> retrievedMessage, MessageHeaderAccessor additionalHeaders) {
        MessageHeaderAccessor headers = TracingChannelInterceptor.mutableHeaderAccessor(originalMessage);
        if (originalMessage instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)originalMessage;
            headers.copyHeaders(MessageHeaderPropagatorSetter.propagationHeaders(additionalHeaders.getMessageHeaders(), this.propagator.fields()));
            return new ErrorMessage((Throwable)errorMessage.getPayload(), TracingChannelInterceptor.isWebSockets(headers) ? headers.getMessageHeaders() : new MessageHeaders((Map)headers.getMessageHeaders()), errorMessage.getOriginalMessage());
        }
        headers.copyHeaders((Map)additionalHeaders.getMessageHeaders());
        return new GenericMessage(retrievedMessage.getPayload(), TracingChannelInterceptor.isWebSockets(headers) ? headers.getMessageHeaders() : new MessageHeaders((Map)headers.getMessageHeaders()));
    }

    private static boolean isWebSockets(MessageHeaderAccessor headerAccessor) {
        return headerAccessor.getMessageHeaders().containsKey((Object)"stompCommand") || headerAccessor.getMessageHeaders().containsKey((Object)"simpMessageType");
    }

    private static boolean isDirectChannel(MessageChannel channel) {
        Class targetClass = AopUtils.getTargetClass((Object)channel);
        return (directWithAttributesChannelClass == null || !directWithAttributesChannelClass.isAssignableFrom(targetClass)) && hasDirectChannelClass && DirectChannel.class.isAssignableFrom(targetClass);
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        if (TracingChannelInterceptor.isDirectChannel(channel)) {
            this.afterMessageHandled(message, channel, null, ex);
        }
        log.debug(() -> "Will finish the current span after completion " + this.tracer.currentSpan());
        this.finishSpan(ex);
    }

    public Message<?> postReceive(Message<?> message, MessageChannel channel) {
        MessageHeaderAccessor headers = TracingChannelInterceptor.mutableHeaderAccessor(message);
        log.debug(() -> "Received a message in post-receive " + message);
        Span result = this.propagator.extract((Object)headers, this.extractor).start();
        log.debug(() -> "Extracted result from headers " + result);
        Span span = this.consumerSpanReceive(message, channel, headers, result);
        this.setSpanInScope(span);
        log.debug(() -> "Created a new span that will be injected in the headers " + span);
        this.propagator.inject(span.context(), (Object)headers, this.injector);
        log.debug(() -> "Created a new span in post receive " + span);
        headers.setImmutable();
        if (message instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)message;
            return new ErrorMessage((Throwable)errorMessage.getPayload(), headers.getMessageHeaders(), errorMessage.getOriginalMessage());
        }
        return new GenericMessage(message.getPayload(), headers.getMessageHeaders());
    }

    private Span consumerSpanReceive(Message<?> message, MessageChannel channel, MessageHeaderAccessor headers, Span result) {
        Span.Builder builder = this.tracer.spanBuilder().setParent(result.context());
        MessageHeaderPropagatorSetter.removeAnyTraceHeaders(headers, this.propagator.fields());
        builder = builder.kind(Span.Kind.CONSUMER);
        builder = this.messageSpanCustomizer.customizeReceive(builder, message, channel);
        builder = builder.remoteServiceName(TracingChannelInterceptor.toRemoteServiceName(headers, this.remoteServiceNameMapper, this.applicationContext));
        return builder.start();
    }

    public void afterReceiveCompletion(Message<?> message, MessageChannel channel, Exception ex) {
        log.debug(() -> "Will finish the current span after receive completion " + this.tracer.currentSpan());
        this.finishSpan(ex);
    }

    public Message<?> beforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
        MessageHeaderAccessor headers = TracingChannelInterceptor.mutableHeaderAccessor(message);
        log.debug(() -> "Received a message in before handle " + message);
        Span consumerSpan = this.consumerSpan(message, channel, headers);
        Span handle = this.tracer.nextSpan(consumerSpan);
        handle = this.messageSpanCustomizer.customizeHandle(handle, message, channel).start();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Created consumer span " + handle));
        }
        this.setSpanInScope(handle);
        MessageHeaderPropagatorSetter.removeAnyTraceHeaders(headers, this.propagator.fields());
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Created a new span in before handle " + handle));
        }
        if (message instanceof ErrorMessage) {
            return new ErrorMessage((Throwable)message.getPayload(), headers.getMessageHeaders());
        }
        headers.setImmutable();
        return new GenericMessage(message.getPayload(), headers.getMessageHeaders());
    }

    private Span consumerSpan(Message<?> message, MessageChannel channel, MessageHeaderAccessor headers) {
        Span.Builder consumerSpanBuilder = this.propagator.extract((Object)headers, this.extractor);
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Extracted result from headers - will finish it immediately " + consumerSpanBuilder));
        }
        consumerSpanBuilder.kind(Span.Kind.CONSUMER).start();
        consumerSpanBuilder.remoteServiceName(REMOTE_SERVICE_NAME);
        consumerSpanBuilder = this.messageSpanCustomizer.customizeHandle(consumerSpanBuilder, message, channel);
        Span consumerSpan = consumerSpanBuilder.start();
        consumerSpan.end();
        return consumerSpan;
    }

    public void afterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception ex) {
        log.debug(() -> "Will finish the current span after message handled " + this.tracer.currentSpan());
        this.finishSpan(ex);
    }

    void finishSpan(Exception error) {
        SpanAndScope spanAndScope = this.getSpanFromThreadLocal();
        if (spanAndScope == null) {
            return;
        }
        Span span = spanAndScope.span;
        Tracer.SpanInScope scope = spanAndScope.scope;
        if (span.isNoop()) {
            log.debug(() -> "Span " + span + " is noop - will stop the scope");
            scope.close();
            return;
        }
        if (error != null) {
            String message = error.getMessage();
            if (message == null) {
                message = error.getClass().getSimpleName();
            }
            span.tag("error", message);
        }
        log.debug(() -> "Will finish the and its corresponding scope " + span);
        span.end();
        scope.close();
    }

    private SpanAndScope getSpanFromThreadLocal() {
        SpanAndScope span = this.threadLocalSpan.get();
        log.debug(() -> "Took span [" + span + "] from thread local");
        this.threadLocalSpan.remove();
        return span;
    }

    private static MessageHeaderAccessor mutableHeaderAccessor(Message<?> message) {
        MessageHeaderAccessor accessor = MessageHeaderAccessor.getAccessor(message, MessageHeaderAccessor.class);
        if (accessor != null && accessor.isMutable()) {
            return accessor;
        }
        MessageHeaderAccessor headers = MessageHeaderAccessor.getMutableAccessor(message);
        headers.setLeaveMutable(true);
        return headers;
    }

    private static Message<?> getMessage(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof MessagingException) {
            MessagingException e = (MessagingException)payload;
            Message<?> failedMessage = e.getFailedMessage();
            return failedMessage != null ? failedMessage : message;
        }
        return message;
    }

    private static class ThreadLocalSpan {
        private static final LogAccessor log = new LogAccessor(ThreadLocalSpan.class);
        private final ThreadLocal<SpanAndScope> threadLocalSpan = new ThreadLocal();
        private final LinkedBlockingDeque<SpanAndScope> spans = new LinkedBlockingDeque();

        ThreadLocalSpan() {
        }

        void set(SpanAndScope spanAndScope) {
            SpanAndScope scope = this.threadLocalSpan.get();
            if (scope != null) {
                this.spans.addFirst(scope);
            }
            this.threadLocalSpan.set(spanAndScope);
        }

        SpanAndScope get() {
            return this.threadLocalSpan.get();
        }

        void remove() {
            this.threadLocalSpan.remove();
            if (this.spans.isEmpty()) {
                return;
            }
            try {
                SpanAndScope span = this.spans.removeFirst();
                log.debug(() -> "Took span [" + span + "] from thread local");
                this.threadLocalSpan.set(span);
            }
            catch (NoSuchElementException ex) {
                log.trace((Throwable)ex, () -> "Failed to remove a span from the queue");
            }
        }
    }

    private static class SpanAndScope {
        final Span span;
        final Tracer.SpanInScope scope;

        SpanAndScope(Span span, Tracer.SpanInScope scope) {
            this.span = span;
            this.scope = scope;
        }
    }
}

