/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.noop;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierReceiver;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierSender;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierObjectMapper;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpStubMessages;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureOrder(value=0x7FFFFFFF)
public class NoOpContractVerifierAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MessageVerifierSender.class})
    public MessageVerifierSender<Object> noOpContractVerifierMessageSender() {
        final NoOpStubMessages noOpStubMessages = new NoOpStubMessages();
        return new MessageVerifierSender<Object>(){

            @Override
            public void send(Object message, String destination, @Nullable YamlContract contract) {
                noOpStubMessages.send(message, destination, contract);
            }

            @Override
            public <T> void send(T payload, Map<String, Object> headers, String destination, @Nullable YamlContract contract) {
                noOpStubMessages.send(payload, headers, destination, contract);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={MessageVerifierReceiver.class})
    public MessageVerifierReceiver<Object> noOpContractVerifierMessageReceiver() {
        final NoOpStubMessages noOpStubMessages = new NoOpStubMessages();
        return new MessageVerifierReceiver<Object>(){

            @Override
            public Object receive(String destination, long timeout, TimeUnit timeUnit, @Nullable YamlContract contract) {
                return noOpStubMessages.receive(destination, timeout, timeUnit, contract);
            }

            @Override
            public Object receive(String destination, YamlContract contract) {
                return noOpStubMessages.receive(destination, contract);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={ContractVerifierMessaging.class})
    public ContractVerifierMessaging<Object> contractVerifierMessaging() {
        return new ContractVerifierMessaging<Object>(new NoOpStubMessages(), new NoOpStubMessages());
    }

    @Bean
    @ConditionalOnMissingBean
    public ContractVerifierObjectMapper contractVerifierObjectMapper(ObjectProvider<ObjectMapper> objectMapper) {
        ObjectMapper mapper = (ObjectMapper)objectMapper.getIfAvailable();
        if (mapper != null) {
            return new ContractVerifierObjectMapper(mapper);
        }
        return new ContractVerifierObjectMapper();
    }
}

