/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webservices.client;

import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.util.Assert;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.http.ClientHttpRequestMessageSender;

@FunctionalInterface
public interface WebServiceMessageSenderFactory {
    public WebServiceMessageSender getWebServiceMessageSender();

    public static WebServiceMessageSenderFactory http() {
        return WebServiceMessageSenderFactory.http(ClientHttpRequestFactoryBuilder.detect(), null);
    }

    public static WebServiceMessageSenderFactory http(ClientHttpRequestFactorySettings requestFactorySettings) {
        return WebServiceMessageSenderFactory.http(ClientHttpRequestFactoryBuilder.detect(), requestFactorySettings);
    }

    public static WebServiceMessageSenderFactory http(ClientHttpRequestFactoryBuilder<?> requestFactoryBuilder, ClientHttpRequestFactorySettings requestFactorySettings) {
        Assert.notNull(requestFactoryBuilder, (String)"'requestFactoryBuilder' must not be null");
        return () -> new ClientHttpRequestMessageSender(requestFactoryBuilder.build(requestFactorySettings));
    }
}

