/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.servlet.context;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.test.http.server.LocalTestWebServer;
import org.springframework.boot.web.server.AbstractConfigurableWebServerFactory;
import org.springframework.boot.web.server.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.ApplicationContext;

class ServletWebServerApplicationContextLocalTestWebServerProvider
implements LocalTestWebServer.Provider {
    private final @Nullable ServletWebServerApplicationContext context;

    ServletWebServerApplicationContextLocalTestWebServerProvider(ApplicationContext context) {
        this.context = ServletWebServerApplicationContextLocalTestWebServerProvider.getWebServerApplicationContextIfPossible(context);
    }

    static @Nullable ServletWebServerApplicationContext getWebServerApplicationContextIfPossible(ApplicationContext context) {
        try {
            return (ServletWebServerApplicationContext)context;
        }
        catch (ClassCastException | NoClassDefFoundError ex) {
            return null;
        }
    }

    public @Nullable LocalTestWebServer getLocalTestWebServer() {
        if (this.context == null) {
            return null;
        }
        return LocalTestWebServer.of((LocalTestWebServer.Scheme)(this.isSslEnabled(this.context) ? LocalTestWebServer.Scheme.HTTPS : LocalTestWebServer.Scheme.HTTP), () -> {
            int port = (Integer)this.context.getEnvironment().getProperty("local.server.port", Integer.class, (Object)8080);
            String path = this.context.getEnvironment().getProperty("server.servlet.context-path", "");
            return new LocalTestWebServer.BaseUriDetails(port, path);
        });
    }

    private boolean isSslEnabled(ServletWebServerApplicationContext context) {
        try {
            AbstractConfigurableWebServerFactory webServerFactory = (AbstractConfigurableWebServerFactory)context.getBean(AbstractConfigurableWebServerFactory.class);
            return webServerFactory.getSsl() != null && webServerFactory.getSsl().isEnabled();
        }
        catch (NoSuchBeanDefinitionException ex) {
            return false;
        }
    }
}

