/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.json.builder;

import org.springframework.batch.item.json.JsonItemReader;
import org.springframework.batch.item.json.JsonObjectReader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JsonItemReaderBuilder<T> {
    private JsonObjectReader<T> jsonObjectReader;
    private Resource resource;
    private String name;
    private boolean strict = true;
    private boolean saveState = true;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public JsonItemReaderBuilder<T> jsonObjectReader(JsonObjectReader<T> jsonObjectReader) {
        this.jsonObjectReader = jsonObjectReader;
        return this;
    }

    public JsonItemReaderBuilder<T> resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public JsonItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public JsonItemReaderBuilder<T> strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public JsonItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public JsonItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public JsonItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public JsonItemReader<T> build() {
        Assert.notNull(this.jsonObjectReader, (String)"A json object reader is required.");
        Assert.notNull((Object)this.resource, (String)"A resource is required.");
        if (this.saveState) {
            Assert.state((boolean)StringUtils.hasText((String)this.name), (String)"A name is required when saveState is set to true.");
        }
        JsonItemReader<T> reader = new JsonItemReader<T>(this.resource, this.jsonObjectReader);
        reader.setName(this.name);
        reader.setStrict(this.strict);
        reader.setSaveState(this.saveState);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setCurrentItemCount(this.currentItemCount);
        return reader;
    }
}

