/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbitmq.client.config;

import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.config.BaseRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.ContainerCustomizer;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.MethodRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.rabbitmq.client.AmqpConnectionFactory;
import org.springframework.amqp.rabbitmq.client.listener.RabbitAmqpListenerContainer;
import org.springframework.amqp.rabbitmq.client.listener.RabbitAmqpMessageListenerAdapter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.utils.JavaUtils;
import org.springframework.scheduling.TaskScheduler;

public class RabbitAmqpListenerContainerFactory
extends BaseRabbitListenerContainerFactory<RabbitAmqpListenerContainer> {
    private final AmqpConnectionFactory connectionFactory;
    private @Nullable ContainerCustomizer<RabbitAmqpListenerContainer> containerCustomizer;
    private MessagePostProcessor @Nullable [] afterReceivePostProcessors;
    private @Nullable Integer batchSize;
    private @Nullable Long batchReceiveTimeout;
    private @Nullable TaskScheduler taskScheduler;
    private @Nullable MessageConverter messageConverter;

    public RabbitAmqpListenerContainerFactory(AmqpConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setContainerCustomizer(ContainerCustomizer<RabbitAmqpListenerContainer> containerCustomizer) {
        this.containerCustomizer = containerCustomizer;
    }

    public void setAfterReceivePostProcessors(MessagePostProcessor ... afterReceivePostProcessors) {
        this.afterReceivePostProcessors = Arrays.copyOf(afterReceivePostProcessors, afterReceivePostProcessors.length);
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchReceiveTimeout(Long batchReceiveTimeout) {
        this.batchReceiveTimeout = batchReceiveTimeout;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public RabbitAmqpListenerContainer createListenerContainer(@Nullable RabbitListenerEndpoint endpoint) {
        if (endpoint instanceof MethodRabbitListenerEndpoint) {
            MethodRabbitListenerEndpoint methodRabbitListenerEndpoint = (MethodRabbitListenerEndpoint)endpoint;
            JavaUtils.INSTANCE.acceptIfCondition(this.batchSize != null && this.batchSize > 1, (Object)true, arg_0 -> ((MethodRabbitListenerEndpoint)methodRabbitListenerEndpoint).setBatchListener(arg_0));
            methodRabbitListenerEndpoint.setAdapterProvider((batch, bean, method, returnExceptions, errorHandler, batchingStrategy) -> new RabbitAmqpMessageListenerAdapter(bean, method, returnExceptions, errorHandler, batch));
        }
        if (this.messageConverter != null && endpoint != null && endpoint.getMessageConverter() == null) {
            endpoint.setMessageConverter(this.messageConverter);
        }
        RabbitAmqpListenerContainer container = this.createContainerInstance();
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.getAdviceChain(), container::setAdviceChain).acceptIfNotNull((Object)this.getDefaultRequeueRejected(), container::setDefaultRequeue).acceptIfNotNull((Object)this.afterReceivePostProcessors, container::setAfterReceivePostProcessors).acceptIfNotNull((Object)this.batchSize, container::setBatchSize).acceptIfNotNull((Object)this.batchReceiveTimeout, container::setBatchReceiveTimeout).acceptIfNotNull((Object)this.taskScheduler, container::setTaskScheduler);
        this.applyCommonOverrides(endpoint, container);
        if (endpoint != null) {
            JavaUtils.INSTANCE.acceptIfNotNull((Object)endpoint.getAckMode(), ackMode -> container.setAutoSettle(!ackMode.isManual())).acceptIfNotNull((Object)endpoint.getConcurrency(), concurrency -> container.setConsumersPerQueue(Integer.parseInt(concurrency)));
        }
        if (this.containerCustomizer != null) {
            this.containerCustomizer.configure((MessageListenerContainer)container);
        }
        return container;
    }

    protected RabbitAmqpListenerContainer createContainerInstance() {
        return new RabbitAmqpListenerContainer(this.connectionFactory);
    }
}

