/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.browsingcontext.BrowsingContextInfo;
import org.openqa.selenium.bidi.browsingcontext.CaptureScreenshotParameters;
import org.openqa.selenium.bidi.browsingcontext.LocateNodeParameters;
import org.openqa.selenium.bidi.browsingcontext.Locator;
import org.openqa.selenium.bidi.browsingcontext.NavigationResult;
import org.openqa.selenium.bidi.browsingcontext.ReadinessState;
import org.openqa.selenium.bidi.script.RemoteValue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;
import org.openqa.selenium.print.PrintOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;

public class BrowsingContext {
    private static final Json JSON = new Json();
    private final String id;
    private final BiDi bidi;
    private final WebDriver driver;
    private static final String CONTEXT = "context";
    private static final String RELOAD = "browsingContext.reload";
    private static final String HANDLE_USER_PROMPT = "browsingContext.handleUserPrompt";
    protected static final Type LIST_OF_BROWSING_CONTEXT_INFO = new TypeToken<List<BrowsingContextInfo>>(){}.getType();
    private final Function<JsonInput, String> browsingContextIdMapper = jsonInput -> {
        Map result = (Map)jsonInput.read(Map.class);
        return result.getOrDefault(CONTEXT, "").toString();
    };
    private final Function<JsonInput, NavigationResult> navigationInfoMapper = jsonInput -> (NavigationResult)jsonInput.read(NavigationResult.class);
    private final Function<JsonInput, List<BrowsingContextInfo>> browsingContextInfoListMapper = jsonInput -> {
        Map result = (Map)jsonInput.read(Map.class);
        List contexts = result.getOrDefault("contexts", new ArrayList());
        if (contexts.isEmpty()) {
            return new ArrayList();
        }
        Json json = new Json();
        String dtr = json.toJson((Object)contexts);
        return (List)json.toType(dtr, LIST_OF_BROWSING_CONTEXT_INFO);
    };

    public BrowsingContext(WebDriver driver, String id) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"Browsing Context id", (Object)id);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        Require.precondition((!id.isEmpty() ? 1 : 0) != 0, (String)"Browsing Context id cannot be empty", (Object[])new Object[0]);
        this.driver = driver;
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.id = id;
    }

    public BrowsingContext(WebDriver driver, WindowType type) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.driver = driver;
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.id = this.create(type);
    }

    public BrowsingContext(WebDriver driver, WindowType type, String referenceContextId) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"Reference browsing context id", (Object)referenceContextId);
        Require.precondition((!referenceContextId.isEmpty() ? 1 : 0) != 0, (String)"Reference Context id cannot be empty", (Object[])new Object[0]);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.driver = driver;
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.id = this.create(type, referenceContextId);
    }

    public String getId() {
        return this.id;
    }

    private String create(WindowType type) {
        return this.bidi.send(new Command<String>("browsingContext.create", Map.of("type", type.toString()), this.browsingContextIdMapper));
    }

    private String create(WindowType type, String referenceContext) {
        return this.bidi.send(new Command<String>("browsingContext.create", Map.of("type", type.toString(), "referenceContext", referenceContext), this.browsingContextIdMapper));
    }

    public NavigationResult navigate(String url) {
        return this.bidi.send(new Command<NavigationResult>("browsingContext.navigate", Map.of(CONTEXT, this.id, "url", url), this.navigationInfoMapper));
    }

    public NavigationResult navigate(String url, ReadinessState readinessState) {
        return this.bidi.send(new Command<NavigationResult>("browsingContext.navigate", Map.of(CONTEXT, this.id, "url", url, "wait", readinessState.toString()), this.navigationInfoMapper));
    }

    public List<BrowsingContextInfo> getTree() {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", Map.of("root", this.id), this.browsingContextInfoListMapper));
    }

    public List<BrowsingContextInfo> getTree(int maxDepth) {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", Map.of("root", this.id, "maxDepth", maxDepth), this.browsingContextInfoListMapper));
    }

    public List<BrowsingContextInfo> getTopLevelContexts() {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", new HashMap<String, Object>(), this.browsingContextInfoListMapper));
    }

    public NavigationResult reload() {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, Map.of(CONTEXT, this.id), this.navigationInfoMapper));
    }

    private NavigationResult reload(boolean ignoreCache) {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, Map.of(CONTEXT, this.id, "ignoreCache", ignoreCache), this.navigationInfoMapper));
    }

    public NavigationResult reload(ReadinessState readinessState) {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, Map.of(CONTEXT, this.id, "wait", readinessState.toString()), this.navigationInfoMapper));
    }

    private NavigationResult reload(boolean ignoreCache, ReadinessState readinessState) {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, Map.of(CONTEXT, this.id, "ignoreCache", ignoreCache, "wait", readinessState.toString()), this.navigationInfoMapper));
    }

    public void handleUserPrompt() {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, Map.of(CONTEXT, this.id)));
    }

    public void handleUserPrompt(boolean accept) {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, Map.of(CONTEXT, this.id, "accept", accept)));
    }

    public void handleUserPrompt(String userText) {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, Map.of(CONTEXT, this.id, "userText", userText)));
    }

    public void handleUserPrompt(boolean accept, String userText) {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, Map.of(CONTEXT, this.id, "accept", accept, "userText", userText)));
    }

    public String captureScreenshot() {
        return this.bidi.send(new Command<String>("browsingContext.captureScreenshot", Map.of(CONTEXT, this.id), jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            return (String)result.get("data");
        }));
    }

    public String captureScreenshot(CaptureScreenshotParameters parameters) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CONTEXT, this.id);
        params.putAll(parameters.toMap());
        return this.bidi.send(new Command<String>("browsingContext.captureScreenshot", params, jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            return (String)result.get("data");
        }));
    }

    public String captureBoxScreenshot(double x, double y, double width, double height) {
        return this.bidi.send(new Command<String>("browsingContext.captureScreenshot", Map.of(CONTEXT, this.id, "clip", Map.of("type", "box", "x", x, "y", y, "width", width, "height", height)), jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            return (String)result.get("data");
        }));
    }

    public String captureElementScreenshot(String elementId) {
        return this.bidi.send(new Command<String>("browsingContext.captureScreenshot", Map.of(CONTEXT, this.id, "clip", Map.of("type", "element", "element", Map.of("sharedId", elementId))), jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            return (String)result.get("data");
        }));
    }

    public String captureElementScreenshot(String elementId, String handle) {
        return this.bidi.send(new Command<String>("browsingContext.captureScreenshot", Map.of(CONTEXT, this.id, "clip", Map.of("type", "element", "element", Map.of("sharedId", elementId, "handle", handle))), jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            return (String)result.get("data");
        }));
    }

    public void setViewport(double width, double height) {
        Require.positive((String)"Viewport width", (Double)width);
        Require.positive((String)"Viewport height", (Double)height);
        this.bidi.send(new Command("browsingContext.setViewport", Map.of(CONTEXT, this.id, "viewport", Map.of("width", width, "height", height))));
    }

    public void setViewport(double width, double height, double devicePixelRatio) {
        Require.positive((String)"Viewport width", (Double)width);
        Require.positive((String)"Viewport height", (Double)height);
        Require.positive((String)"Device pixel ratio.", (Double)devicePixelRatio);
        this.bidi.send(new Command("browsingContext.setViewport", Map.of(CONTEXT, this.id, "viewport", Map.of("width", width, "height", height), "devicePixelRatio", devicePixelRatio)));
    }

    public void activate() {
        this.bidi.send(new Command("browsingContext.activate", Map.of(CONTEXT, this.id)));
    }

    public String print(PrintOptions printOptions) {
        Map printOptionsParams = printOptions.toMap();
        printOptionsParams.put(CONTEXT, this.id);
        return this.bidi.send(new Command<String>("browsingContext.print", (Map<String, Object>)printOptionsParams, jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            return (String)result.get("data");
        }));
    }

    public void traverseHistory(long delta) {
        this.bidi.send(new Command("browsingContext.traverseHistory", Map.of(CONTEXT, this.id, "delta", delta)));
    }

    public void back() {
        this.traverseHistory(-1L);
    }

    public void forward() {
        this.traverseHistory(1L);
    }

    public List<RemoteValue> locateNodes(LocateNodeParameters parameters) {
        HashMap<String, Object> params = new HashMap<String, Object>(parameters.toMap());
        params.put(CONTEXT, this.id);
        return this.bidi.send(new Command<List>("browsingContext.locateNodes", params, jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            try (StringReader reader = new StringReader(JSON.toJson(result.get("nodes")));){
                List list;
                block11: {
                    JsonInput input = JSON.newInput((Reader)reader);
                    try {
                        list = (List)input.read(new TypeToken<List<RemoteValue>>(){}.getType());
                        if (input == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    input.close();
                }
                return list;
            }
        }));
    }

    public List<RemoteValue> locateNodes(Locator locator) {
        return this.bidi.send(new Command<List>("browsingContext.locateNodes", Map.of(CONTEXT, this.id, "locator", locator.toMap()), jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            try (StringReader reader = new StringReader(JSON.toJson(result.get("nodes")));){
                List list;
                block11: {
                    JsonInput input = JSON.newInput((Reader)reader);
                    try {
                        list = (List)input.read(new TypeToken<List<RemoteValue>>(){}.getType());
                        if (input == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    input.close();
                }
                return list;
            }
        }));
    }

    public RemoteValue locateNode(Locator locator) {
        List remoteValues = this.bidi.send(new Command<List>("browsingContext.locateNodes", Map.of(CONTEXT, this.id, "locator", locator.toMap(), "maxNodeCount", 1), jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            try (StringReader reader = new StringReader(JSON.toJson(result.get("nodes")));){
                List list;
                block11: {
                    JsonInput input = JSON.newInput((Reader)reader);
                    try {
                        list = (List)input.read(new TypeToken<List<RemoteValue>>(){}.getType());
                        if (input == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    input.close();
                }
                return list;
            }
        }));
        return (RemoteValue)remoteValues.get(0);
    }

    public WebElement locateElement(Locator locator) {
        List remoteValues = this.bidi.send(new Command<List>("browsingContext.locateNodes", Map.of(CONTEXT, this.id, "locator", locator.toMap(), "maxNodeCount", 1), jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            try (StringReader reader = new StringReader(JSON.toJson(result.get("nodes")));){
                List list;
                block11: {
                    JsonInput input = JSON.newInput((Reader)reader);
                    try {
                        list = (List)input.read(new TypeToken<List<RemoteValue>>(){}.getType());
                        if (input == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    input.close();
                }
                return list;
            }
        }));
        List<WebElement> elements = this.nodeRemoteValueToWebElementConverter(remoteValues);
        return elements.get(0);
    }

    public void close() {
        this.bidi.send(new Command("browsingContext.close", Map.of(CONTEXT, this.id)));
    }

    private List<WebElement> nodeRemoteValueToWebElementConverter(List<RemoteValue> remoteValues) {
        return remoteValues.stream().map(remoteValue -> {
            RemoteWebElement element = new RemoteWebElement();
            element.setParent((RemoteWebDriver)this.driver);
            element.setFileDetector(((RemoteWebDriver)this.driver).getFileDetector());
            remoteValue.getSharedId().ifPresent(sharedId -> ((RemoteWebElement)element).setId((String)sharedId));
            return element;
        }).collect(Collectors.toList());
    }
}

