/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.writer.xmlgraphics;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.MultiImageWriter;
import org.apache.xmlgraphics.image.writer.internal.TIFFImageWriter;
import org.sejda.core.writer.model.ImageWriter;
import org.sejda.core.writer.xmlgraphics.BaseTiffImageWriterAdapter;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.parameter.image.PdfToSingleTiffParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SingleOutputTiffImageWriterAdapter
extends BaseTiffImageWriterAdapter<PdfToSingleTiffParameters> {
    private MultiImageWriter adaptedWriter = null;

    private SingleOutputTiffImageWriterAdapter() {
    }

    @Override
    public void openWriteDestination(OutputStream destination, PdfToSingleTiffParameters params) throws TaskIOException {
        this.setOutputStream(destination);
        try {
            this.adaptedWriter = new TIFFImageWriter().createMultiImageWriter(destination);
        }
        catch (IOException e) {
            throw new TaskIOException((Throwable)e);
        }
    }

    @Override
    public void write(RenderedImage image, PdfToSingleTiffParameters params) throws TaskIOException {
        if (this.adaptedWriter == null || this.getOutputDestination() == null) {
            throw new TaskIOException("Cannot call write before opening the write destination");
        }
        ImageWriterParams imageWriterParams = this.newImageWriterParams(params, params.getCompressionType());
        try {
            this.adaptedWriter.writeImage(image, imageWriterParams);
        }
        catch (IOException e) {
            throw new TaskIOException((Throwable)e);
        }
    }

    @Override
    public boolean supportMultiImage() {
        return true;
    }

    @Override
    public void closeDestination() throws TaskIOException {
        try {
            this.nullSafeCloseMultiImageWriter();
        }
        catch (IOException e) {
            throw new TaskIOException((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.nullSafeCloseMultiImageWriter();
        this.adaptedWriter = null;
        super.close();
    }

    private void nullSafeCloseMultiImageWriter() throws IOException {
        if (this.adaptedWriter != null) {
            this.adaptedWriter.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SingleOutputTiffImageWriterAdapterBuilder
    implements ImageWriter.ImageWriterBuilder<PdfToSingleTiffParameters> {
        SingleOutputTiffImageWriterAdapterBuilder() {
        }

        public SingleOutputTiffImageWriterAdapter build() {
            return new SingleOutputTiffImageWriterAdapter();
        }
    }
}

