/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.request;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.richfaces.exception.FileUploadException;
import org.richfaces.model.UploadedFile;

public abstract class BaseUploadedFile
implements UploadedFile {
    private String parameterName;

    public BaseUploadedFile(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getName() {
        return this.getHeader("filename");
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public byte[] getData() {
        long size = this.getSize();
        if (size > Integer.MAX_VALUE) {
            throw new FileUploadException("Resource content is too long to be allocated as byte[]");
        }
        InputStream is = null;
        try {
            is = this.getInputStream();
            byte[] result = new byte[(int)size];
            ByteStreams.readFully((InputStream)is, (byte[])result);
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            throw new FileUploadException(e.getMessage(), (Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)is);
        }
    }
}

