/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.assembly.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.ops4j.io.ListerUtils;
import org.ops4j.pax.url.assembly.internal.ImmutableSource;
import org.ops4j.pax.url.assembly.internal.MergePolicy;
import org.ops4j.pax.url.assembly.internal.Parser;
import org.ops4j.pax.url.assembly.internal.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AssemblyDescriptorParser
implements Parser {
    private String m_manifest;
    private Source[] m_sources;
    private MergePolicy m_mergePolicy;

    AssemblyDescriptorParser(String url) throws IOException {
        if (url == null) {
            throw new MalformedURLException("Url cannot be null. Syntax assembly:dir|assembly-file-url");
        }
        if ("".equals(url.trim()) || "/".equals(url.trim())) {
            throw new MalformedURLException("Url cannot be empty. Syntax assembly:dir|assembly-file-url");
        }
        this.m_sources = new Source[0];
        this.m_mergePolicy = MergePolicy.FIRST;
        this.parseDescriptor(new URL(url));
    }

    @Override
    public String manifest() {
        return this.m_manifest;
    }

    @Override
    public Source[] sources() {
        return this.m_sources;
    }

    @Override
    public MergePolicy mergePolicy() {
        return this.m_mergePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDescriptor(URL url) throws IOException {
        JsonFactory jFactory = new JsonFactory();
        jFactory.enable(JsonParser.Feature.ALLOW_COMMENTS);
        JsonParser jp = jFactory.createJsonParser(url);
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new IOException(String.format("Descriptor [%s] not in JSON format", url.toExternalForm()));
        }
        HashSet<Source> sources = new HashSet<Source>();
        try {
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String currentName = jp.getCurrentName();
                jp.nextToken();
                if ("manifest".equals(currentName)) {
                    this.m_manifest = jp.getText();
                    continue;
                }
                if ("assembly".equals(currentName)) {
                    sources.addAll(this.parseAssembly(jp));
                    continue;
                }
                if (!"mergePolicy".equals(currentName)) continue;
                this.m_mergePolicy = "last".equalsIgnoreCase(jp.getText()) ? MergePolicy.LAST : MergePolicy.FIRST;
            }
        }
        finally {
            jp.close();
        }
        this.m_sources = sources.toArray(new Source[sources.size()]);
    }

    private Collection<Source> parseAssembly(JsonParser jp) throws IOException {
        HashSet<Source> sources = new HashSet<Source>();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String currentName = jp.getCurrentName();
            jp.nextToken();
            if (!"directory".equals(currentName) && !"jar".equals(currentName) && !"zip".equals(currentName)) continue;
            Source source = this.parseDirectory(jp);
            sources.add(source);
        }
        return sources;
    }

    private Source parseDirectory(JsonParser jp) throws IOException {
        String path = null;
        HashSet<Pattern> includes = new HashSet<Pattern>();
        HashSet<Pattern> excludes = new HashSet<Pattern>();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String currentName = jp.getCurrentName();
            jp.nextToken();
            if ("path".equals(currentName)) {
                path = jp.getText();
                continue;
            }
            if ("include".equals(currentName)) {
                includes.add(ListerUtils.parseFilter(jp.getText()));
                continue;
            }
            if (!"exclude".equals(currentName)) continue;
            excludes.add(ListerUtils.parseFilter(jp.getText()));
        }
        if (path == null) {
            throw new IOException("Invalid descriptor file");
        }
        return new ImmutableSource(path, includes.toArray(new Pattern[includes.size()]), excludes.toArray(new Pattern[excludes.size()]));
    }
}

