/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.runner.platform.JavaRunner;
import org.ops4j.pax.runner.platform.PlatformException;
import org.ops4j.pax.runner.platform.internal.CommandLineBuilder;

public class ScriptJavaRunner
implements JavaRunner {
    private static final Log LOG = LogFactory.getLog(ScriptJavaRunner.class);

    public synchronized void exec(String[] vmOptions, String[] classpath, String mainClass, String[] programOptions, String javaHome, File workingDirectory) throws PlatformException {
        StringBuilder cp = new StringBuilder();
        for (String path : classpath) {
            if (cp.length() != 0) {
                cp.append(File.pathSeparator);
            }
            cp.append(path);
        }
        CommandLineBuilder commandLine = new CommandLineBuilder().append("java").append(vmOptions).append("-cp").append(cp.toString()).append(mainClass).append(programOptions);
        LOG.debug("Start command line [" + Arrays.toString(commandLine.toArray()) + "]");
        String shell = this.getShellScript(commandLine);
        String batch = this.getBatchScript(commandLine);
        try {
            LOG.debug("Writing run scripts.");
            FileWriter sh = new FileWriter(new File(workingDirectory, "run.sh"));
            sh.write(shell);
            sh.close();
            FileWriter bat = new FileWriter(new File(workingDirectory, "run.bat"));
            bat.write(batch);
            bat.close();
        }
        catch (IOException e) {
            throw new PlatformException("Could not write run scripts", e);
        }
    }

    private String getShellScript(CommandLineBuilder commandLine) {
        String newline = "\n";
        StringBuilder script = new StringBuilder();
        script.append("#!/bin/sh");
        script.append("\n");
        for (String s : commandLine.toArray()) {
            script.append(s);
            script.append(" ");
        }
        script.append("\"$@\"");
        script.append("\n");
        return script.toString();
    }

    private String getBatchScript(CommandLineBuilder commandLine) {
        String newline = "\r\n";
        StringBuilder script = new StringBuilder();
        script.append("\r\n");
        for (String s : commandLine.toArray()) {
            script.append(s);
            script.append(" ");
        }
        script.append("%*");
        script.append("\r\n");
        return script.toString();
    }
}

