/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.moduleloader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.felix.moduleloader.IContent;

public class ContentDirectoryContent
implements IContent {
    private IContent m_content = null;
    private String m_rootPath = null;
    private boolean m_opened = false;

    public ContentDirectoryContent(IContent content, String path) {
        this.m_content = content;
        this.m_rootPath = path.length() > 0 && path.charAt(path.length() - 1) != '/' ? path + "/" : path;
    }

    protected void finalize() {
        if (this.m_content != null) {
            this.m_content.close();
        }
    }

    public void open() {
        this.m_content.open();
        this.m_opened = true;
    }

    public synchronized void close() {
        try {
            if (this.m_content != null) {
                this.m_content.close();
            }
        }
        catch (Exception ex) {
            System.err.println("JarContent: " + ex);
        }
        this.m_content = null;
        this.m_opened = false;
    }

    public synchronized boolean hasEntry(String name) throws IllegalStateException {
        if (!this.m_opened) {
            throw new IllegalStateException("ContentDirectoryContent is not open");
        }
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return this.m_content.hasEntry(this.m_rootPath + name);
    }

    public synchronized byte[] getEntry(String name) throws IllegalStateException {
        if (!this.m_opened) {
            throw new IllegalStateException("ContentDirectoryContent is not open");
        }
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return this.m_content.getEntry(this.m_rootPath + name);
    }

    public synchronized InputStream getEntryAsStream(String name) throws IllegalStateException, IOException {
        if (!this.m_opened) {
            throw new IllegalStateException("ContentDirectoryContent is not open");
        }
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return this.m_content.getEntryAsStream(this.m_rootPath + name);
    }

    public synchronized Enumeration getEntries() {
        if (!this.m_opened) {
            throw new IllegalStateException("ContentDirectoryContent is not open");
        }
        return new EntriesEnumeration(this.m_content.getEntries(), this.m_rootPath);
    }

    public String toString() {
        return "CONTENT DIR " + this.m_rootPath + " (" + this.m_content + ")";
    }

    private static class EntriesEnumeration
    implements Enumeration {
        private Enumeration m_enumeration = null;
        private String m_rootPath = null;

        public EntriesEnumeration(Enumeration enumeration, String rootPath) {
            this.m_enumeration = enumeration;
            this.m_rootPath = rootPath;
        }

        public boolean hasMoreElements() {
            return this.m_enumeration.hasMoreElements();
        }

        public Object nextElement() {
            return ((String)this.m_enumeration.nextElement()).substring(this.m_rootPath.length());
        }
    }
}

