/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.scanner;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.ops4j.pax.scanner.MalformedSpecificationException;
import org.ops4j.pax.scanner.UnsupportedSchemaException;

public class ProvisionSpec {
    private static final String DEFAULT_FILTER = "*";
    private final String m_scheme;
    private final String m_path;
    private final String m_filter;
    private Integer m_startLevel;
    private Boolean m_shouldStart;
    private Boolean m_shouldUpdate;
    private Pattern m_filterPattern;

    public ProvisionSpec(String spec) throws MalformedSpecificationException {
        String[] pathSegments;
        String path;
        if (spec == null || spec.trim().length() == 0) {
            throw new MalformedSpecificationException("Specification cannot be null or empty");
        }
        if (!spec.contains(":")) {
            throw new UnsupportedSchemaException("Provisioning scheme is not specified");
        }
        this.m_scheme = spec.substring(0, spec.indexOf(":"));
        String fullPath = spec.substring(spec.indexOf(":") + 1);
        if (fullPath == null || fullPath.trim().length() == 0) {
            throw new MalformedSpecificationException("Path cannot be null or empty.");
        }
        if (fullPath.startsWith("@") || fullPath.endsWith("@")) {
            throw new MalformedSpecificationException("Path cannot start or end with @");
        }
        String[] optionsSegments = fullPath.split("@");
        if (optionsSegments.length > 1) {
            for (int i = 1; i < optionsSegments.length; ++i) {
                this.parseSegment(optionsSegments[i].trim());
            }
        }
        if ((path = (pathSegments = optionsSegments[0].startsWith("jar:") ? new String[]{optionsSegments[0]} : optionsSegments[0].split("!/"))[0]).endsWith("!")) {
            path = path.substring(0, path.length() - 1);
        }
        this.m_path = path;
        if (pathSegments.length > 1) {
            this.m_filter = pathSegments[1];
            this.m_filterPattern = ProvisionSpec.parseFilter(this.m_filter);
        } else {
            this.m_filter = null;
            this.m_filterPattern = ProvisionSpec.parseFilter(DEFAULT_FILTER);
        }
    }

    public ProvisionSpec(String scheme, String path, String filter, Integer startLevel, Boolean shouldStart, Boolean shouldUpdate) throws MalformedSpecificationException {
        this.m_scheme = scheme;
        this.m_path = path;
        this.m_filter = filter;
        this.m_startLevel = startLevel;
        this.m_shouldStart = shouldStart;
        this.m_shouldUpdate = shouldUpdate;
        this.m_filterPattern = this.m_filter == null ? ProvisionSpec.parseFilter(DEFAULT_FILTER) : ProvisionSpec.parseFilter(this.m_filter);
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public String getPath() {
        return this.m_path;
    }

    public URL getPathAsUrl() throws MalformedURLException {
        return new URL(this.getPath());
    }

    public URL getPathAsCachedUrl() throws MalformedURLException {
        if (this.isPathValidCacheUrl()) {
            return new URL("cache:" + this.getPath());
        }
        return this.getPathAsUrl();
    }

    public boolean isPathValidUrl() {
        try {
            new URL(this.getPath());
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public boolean isPathValidCacheUrl() {
        try {
            new URL("cache:" + this.getPath());
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private void parseSegment(String segment) {
        if (segment.equalsIgnoreCase("start")) {
            if (this.m_shouldStart == null) {
                this.m_shouldStart = true;
            }
        } else if (segment.equalsIgnoreCase("nostart")) {
            if (this.m_shouldStart == null) {
                this.m_shouldStart = false;
            }
        } else if (segment.equalsIgnoreCase("update")) {
            if (this.m_shouldUpdate == null) {
                this.m_shouldUpdate = true;
            }
        } else if (segment.equalsIgnoreCase("noupdate")) {
            if (this.m_shouldUpdate == null) {
                this.m_shouldUpdate = false;
            }
        } else if (this.m_startLevel == null) {
            try {
                this.m_startLevel = Integer.parseInt(segment);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static Pattern parseFilter(String spec) throws MalformedSpecificationException {
        StringBuffer sb = new StringBuffer();
        block6: for (int j = 0; j < spec.length(); ++j) {
            char c = spec.charAt(j);
            switch (c) {
                case '.': {
                    sb.append("\\.");
                    continue block6;
                }
                case '*': {
                    if (j < spec.length() - 1 && spec.charAt(j + 1) == '*') {
                        sb.append(".*");
                        ++j;
                        continue block6;
                    }
                    sb.append("[^/]*");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        String s = sb.toString();
        try {
            return Pattern.compile(s);
        }
        catch (Exception e) {
            throw new MalformedSpecificationException("Invalid character used in the filter name", e);
        }
    }

    public Integer getStartLevel() {
        return this.m_startLevel;
    }

    public Boolean shouldStart() {
        return this.m_shouldStart;
    }

    public Boolean shouldUpdate() {
        return this.m_shouldUpdate;
    }

    public String getFilter() {
        return this.m_filter;
    }

    public Pattern getFilterPattern() {
        return this.m_filterPattern;
    }

    public String toExternalForm() {
        StringBuilder form = new StringBuilder().append(this.getScheme()).append(":").append(this.getPath());
        if (this.m_filter != null) {
            form.append("!/").append(this.m_filter);
        }
        if (this.m_startLevel != null) {
            form.append("@").append(this.m_startLevel);
        }
        if (this.m_shouldStart != null) {
            if (this.m_shouldStart.booleanValue()) {
                form.append("@").append("start");
            } else {
                form.append("@").append("nostart");
            }
        }
        if (this.m_shouldUpdate != null) {
            if (this.m_shouldUpdate.booleanValue()) {
                form.append("@").append("update");
            } else {
                form.append("@").append("noupdate");
            }
        }
        return form.toString();
    }
}

