/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.isomorphism.StereoMatch;
import org.openscience.cdk.isomorphism.UniqueAtomMatches;
import org.openscience.cdk.isomorphism.UniqueBondMatches;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;

public final class Mappings
implements Iterable<int[]> {
    private final Iterable<int[]> iterable;
    private IAtomContainer query;
    private IAtomContainer target;

    Mappings(IAtomContainer query, IAtomContainer target, Iterable<int[]> iterable) {
        this.query = query;
        this.target = target;
        this.iterable = iterable;
    }

    public Mappings filter(Predicate<int[]> predicate) {
        return new Mappings(this.query, this.target, Iterables.filter(this.iterable, predicate));
    }

    public <T> Iterable<T> map(Function<int[], T> f) {
        return Iterables.transform(this.iterable, f);
    }

    public Mappings limit(int limit) {
        return new Mappings(this.query, this.target, Iterables.limit(this.iterable, (int)limit));
    }

    @Deprecated
    public Mappings stereochemistry() {
        if (this.query instanceof IQueryAtomContainer) {
            return this;
        }
        return this.filter(new StereoMatch(this.query, this.target));
    }

    public Mappings uniqueAtoms() {
        return new Mappings(this.query, this.target, new Iterable<int[]>(){

            @Override
            public Iterator<int[]> iterator() {
                return Iterators.filter(Mappings.this.iterable.iterator(), (Predicate)new UniqueAtomMatches());
            }
        });
    }

    public Mappings uniqueBonds() {
        final int[][] g = GraphUtil.toAdjList((IAtomContainer)this.query);
        return new Mappings(this.query, this.target, new Iterable<int[]>(){

            @Override
            public Iterator<int[]> iterator() {
                return Iterators.filter(Mappings.this.iterable.iterator(), (Predicate)new UniqueBondMatches(g));
            }
        });
    }

    public int[][] toArray() {
        Object res = new int[14][];
        int size = 0;
        for (int[] map : this) {
            if (size == ((int[][])res).length) {
                res = (int[][])Arrays.copyOf(res, size + (size >> 1));
            }
            res[size++] = (int[])map.clone();
        }
        return (int[][])Arrays.copyOf(res, size);
    }

    public Iterable<Map<IAtom, IAtom>> toAtomMap() {
        return this.map(new ToAtomMap(this.query, this.target));
    }

    public Iterable<Map<IBond, IBond>> toBondMap() {
        return this.map(new ToBondMap(this.query, this.target));
    }

    public Iterable<Map<IChemObject, IChemObject>> toAtomBondMap() {
        return this.map(new ToAtomBondMap(this.query, this.target));
    }

    public Iterable<IChemObject> toChemObjects() {
        return FluentIterable.from(this.map(new ToAtomBondMap(this.query, this.target))).transformAndConcat((Function)new Function<Map<IChemObject, IChemObject>, Iterable<? extends IChemObject>>(){

            public Iterable<? extends IChemObject> apply(Map<IChemObject, IChemObject> map) {
                return map.values();
            }
        });
    }

    public Iterable<IAtomContainer> toSubstructures() {
        return FluentIterable.from(this.map(new ToAtomBondMap(this.query, this.target))).transform((Function)new Function<Map<IChemObject, IChemObject>, IAtomContainer>(){

            public IAtomContainer apply(Map<IChemObject, IChemObject> map) {
                IAtomContainer submol = (IAtomContainer)Mappings.this.target.getBuilder().newInstance(IAtomContainer.class, new Object[]{Mappings.this.query.getAtomCount(), Mappings.this.target.getBondCount(), 0, 0});
                for (IAtom atom : Mappings.this.query.atoms()) {
                    submol.addAtom((IAtom)map.get(atom));
                }
                for (IBond bond : Mappings.this.query.bonds()) {
                    submol.addBond((IBond)map.get(bond));
                }
                return submol;
            }
        });
    }

    public boolean atLeast(int n) {
        return this.limit(n).count() == n;
    }

    public int[] first() {
        return (int[])Iterables.getFirst(this.iterable, (Object)new int[0]);
    }

    public int count() {
        return Iterables.size(this.iterable);
    }

    public int countUnique() {
        return this.uniqueAtoms().count();
    }

    @Override
    public Iterator<int[]> iterator() {
        return this.iterable.iterator();
    }

    private final class ToAtomBondMap
    implements Function<int[], Map<IChemObject, IChemObject>> {
        private final int[][] g1;
        private final GraphUtil.EdgeToBondMap bonds1;
        private final GraphUtil.EdgeToBondMap bonds2;

        private ToAtomBondMap(IAtomContainer query, IAtomContainer target) {
            this.bonds1 = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)query);
            this.bonds2 = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)target);
            this.g1 = GraphUtil.toAdjList((IAtomContainer)query, (GraphUtil.EdgeToBondMap)this.bonds1);
            GraphUtil.toAdjList((IAtomContainer)target, (GraphUtil.EdgeToBondMap)this.bonds2);
        }

        public Map<IChemObject, IChemObject> apply(int[] mapping) {
            ImmutableMap.Builder map = ImmutableMap.builder();
            for (int u = 0; u < this.g1.length; ++u) {
                map.put((Object)Mappings.this.query.getAtom(u), (Object)Mappings.this.target.getAtom(mapping[u]));
                for (int v : this.g1[u]) {
                    if (v <= u) continue;
                    map.put((Object)this.bonds1.get(u, v), (Object)this.bonds2.get(mapping[u], mapping[v]));
                }
            }
            return map.build();
        }
    }

    private final class ToBondMap
    implements Function<int[], Map<IBond, IBond>> {
        private final int[][] g1;
        private final GraphUtil.EdgeToBondMap bonds1;
        private final GraphUtil.EdgeToBondMap bonds2;

        private ToBondMap(IAtomContainer query, IAtomContainer target) {
            this.bonds1 = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)query);
            this.bonds2 = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)target);
            this.g1 = GraphUtil.toAdjList((IAtomContainer)query, (GraphUtil.EdgeToBondMap)this.bonds1);
            GraphUtil.toAdjList((IAtomContainer)target, (GraphUtil.EdgeToBondMap)this.bonds2);
        }

        public Map<IBond, IBond> apply(int[] mapping) {
            ImmutableMap.Builder map = ImmutableMap.builder();
            for (int u = 0; u < this.g1.length; ++u) {
                for (int v : this.g1[u]) {
                    if (v <= u) continue;
                    map.put((Object)this.bonds1.get(u, v), (Object)this.bonds2.get(mapping[u], mapping[v]));
                }
            }
            return map.build();
        }
    }

    private final class ToAtomMap
    implements Function<int[], Map<IAtom, IAtom>> {
        private final IAtomContainer query;
        private final IAtomContainer target;

        private ToAtomMap(IAtomContainer query, IAtomContainer target) {
            this.query = query;
            this.target = target;
        }

        public Map<IAtom, IAtom> apply(int[] mapping) {
            ImmutableMap.Builder map = ImmutableMap.builder();
            for (int i = 0; i < mapping.length; ++i) {
                map.put((Object)this.query.getAtom(i), (Object)this.target.getAtom(mapping[i]));
            }
            return map.build();
        }
    }
}

