/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.indentation;

import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.IndentLevel;
import org.openrewrite.tools.checkstyle.checks.indentation.IndentationCheck;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

public class NewHandler
extends AbstractExpressionHandler {
    private final DetailAST mainAst;

    public NewHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "new", ast, parent);
        this.mainAst = ast;
    }

    @Override
    public void checkIndentation() {
        DetailAST firstChild;
        if (this.isOnStartOfLine(this.mainAst)) {
            int columnNo = this.expandedTabsColumnNo(this.mainAst);
            IndentLevel level = this.getIndentImpl();
            boolean forceStrictCondition = this.getIndentCheck().isForceStrictCondition();
            if (forceStrictCondition && !level.isAcceptable(columnNo) || !forceStrictCondition && level.isGreaterThan(columnNo)) {
                this.logError(this.mainAst, "", columnNo, level);
            }
        }
        if ((firstChild = this.mainAst.getFirstChild()) != null) {
            this.checkExpressionSubtree(firstChild, this.getIndent(), false, false);
        }
        DetailAST lparen = this.mainAst.findFirstToken(76);
        this.checkLeftParen(lparen);
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        int offset = TokenUtil.isOfType(child.getMainAst(), 6) ? this.getBasicOffset() : this.getLineWrappingIndent();
        return new IndentLevel(this.getIndent(), offset);
    }

    @Override
    protected IndentLevel getIndentImpl() {
        IndentLevel result;
        if (this.getLineStart(this.mainAst) == this.mainAst.getColumnNo()) {
            result = super.getIndentImpl();
            boolean isLineWrappedNew = TokenUtil.isOfType(this.mainAst.getParent().getParent(), 80, 88);
            if (isLineWrappedNew || this.doesChainedMethodNeedsLineWrapping()) {
                result = new IndentLevel(result, this.getLineWrappingIndent());
            }
        } else {
            result = new IndentLevel(this.getLineStart(this.mainAst));
        }
        return result;
    }

    private int getLineWrappingIndent() {
        return this.getIndentCheck().getLineWrappingIndentation();
    }

    @Override
    protected boolean shouldIncreaseIndent() {
        return false;
    }

    private boolean doesChainedMethodNeedsLineWrapping() {
        DetailAST ast = this.mainAst.getParent();
        while (TokenUtil.isOfType(ast, 59, 27, 28)) {
            ast = ast.getParent();
        }
        return TokenUtil.isOfType(ast, 80, 88);
    }
}

