/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy.format;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.Marker;

public class OmitParenthesesForLastArgumentLambdaVisitor<P>
extends GroovyIsoVisitor<P> {
    private final @Nullable Tree stopAfter;

    public OmitParenthesesForLastArgumentLambdaVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
        J.MethodInvocation m = super.visitMethodInvocation(method, p);
        return method.withArguments(ListUtils.mapLast((List)m.getArguments(), last -> {
            if (last instanceof J.Lambda) {
                Expression l = last.getPrefix().getWhitespace().isEmpty() ? ((J.Lambda)last).withPrefix(last.getPrefix().withWhitespace(" ")) : last;
                return (Expression)l.withMarkers(l.getMarkers().computeByType((Marker)new OmitParentheses(Tree.randomId()), (s1, s2) -> s1));
            }
            return last;
        }));
    }

    public @Nullable J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    public @Nullable J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }
}

