/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.J;

public final class EnableDevelocityBuildCache
extends Recipe {
    @Option(displayName="Enable remote build cache", description="Value for `//develocity/buildCache/remote/enabled`.", example="true", required=false)
    private final @Nullable String remoteEnabled;
    @Option(displayName="Enable remote build cache push", description="Value for `//develocity/buildCache/remote/storeEnabled`.", example="System.getenv(\"CI\") != null", required=false)
    private final @Nullable String remotePushEnabled;

    public String getDisplayName() {
        return "Enable Develocity build cache";
    }

    public String getDescription() {
        return "Adds `buildCache` configuration to `develocity` where not yet present.";
    }

    public Validated<Object> validate(ExecutionContext ctx) {
        return super.validate(ctx).and(Validated.notBlank((String)"remoteEnabled", (String)this.remoteEnabled).or(Validated.notBlank((String)"remotePushEnabled", (String)this.remotePushEnabled)));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsSettingsGradle(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if ("develocity".equals(method.getSimpleName()) && !this.hasBuildCache(method)) {
                    J.MethodInvocation buildCache = EnableDevelocityBuildCache.this.createBuildCache();
                    return (J.MethodInvocation)this.maybeAutoFormat((J)method, (J)method.withArguments(ListUtils.mapFirst((List)method.getArguments(), arg -> {
                        if (arg instanceof J.Lambda) {
                            J.Lambda lambda = (J.Lambda)arg;
                            J.Block block = (J.Block)lambda.getBody();
                            return lambda.withBody((J)block.withStatements(ListUtils.concat((List)block.getStatements(), (Object)buildCache)));
                        }
                        return arg;
                    })), ctx);
                }
                return method;
            }

            private boolean hasBuildCache(J.MethodInvocation m) {
                return ((AtomicBoolean)new GroovyIsoVisitor<AtomicBoolean>(){

                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean atomicBoolean) {
                        if ("buildCache".equals(method.getSimpleName())) {
                            atomicBoolean.set(true);
                            return method;
                        }
                        return super.visitMethodInvocation(method, (Object)atomicBoolean);
                    }
                }.reduce((Tree)m, (Object)new AtomicBoolean(false), this.getCursor().getParentTreeCursor())).get();
            }
        });
    }

    private J.MethodInvocation createBuildCache() {
        String conf = "buildCache {\n    remote(develocity.buildCache) {\n";
        if (!StringUtils.isBlank((String)this.remoteEnabled)) {
            conf = conf + "        enabled = " + this.remoteEnabled + "\n";
        }
        if (!StringUtils.isBlank((String)this.remotePushEnabled)) {
            conf = conf + "        push = " + this.remotePushEnabled + "\n";
        }
        conf = conf + "    }}";
        return (J.MethodInvocation)GradleParser.builder().build().parse(new String[]{conf}).map(G.CompilationUnit.class::cast).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not parse as Gradle")).getStatements().get(0);
    }

    @Generated
    public EnableDevelocityBuildCache(@Nullable String remoteEnabled, @Nullable String remotePushEnabled) {
        this.remoteEnabled = remoteEnabled;
        this.remotePushEnabled = remotePushEnabled;
    }

    @Generated
    public @Nullable String getRemoteEnabled() {
        return this.remoteEnabled;
    }

    @Generated
    public @Nullable String getRemotePushEnabled() {
        return this.remotePushEnabled;
    }

    @NonNull
    @Generated
    public String toString() {
        return "EnableDevelocityBuildCache(remoteEnabled=" + this.getRemoteEnabled() + ", remotePushEnabled=" + this.getRemotePushEnabled() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnableDevelocityBuildCache)) {
            return false;
        }
        EnableDevelocityBuildCache other = (EnableDevelocityBuildCache)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$remoteEnabled = this.getRemoteEnabled();
        String other$remoteEnabled = other.getRemoteEnabled();
        if (this$remoteEnabled == null ? other$remoteEnabled != null : !this$remoteEnabled.equals(other$remoteEnabled)) {
            return false;
        }
        String this$remotePushEnabled = this.getRemotePushEnabled();
        String other$remotePushEnabled = other.getRemotePushEnabled();
        return !(this$remotePushEnabled == null ? other$remotePushEnabled != null : !this$remotePushEnabled.equals(other$remotePushEnabled));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof EnableDevelocityBuildCache;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $remoteEnabled = this.getRemoteEnabled();
        result = result * 59 + ($remoteEnabled == null ? 43 : $remoteEnabled.hashCode());
        String $remotePushEnabled = this.getRemotePushEnabled();
        result = result * 59 + ($remotePushEnabled == null ? 43 : $remotePushEnabled.hashCode());
        return result;
    }
}

