/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Scanner;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

final class JavaElementFactory {
    JavaElementFactory() {
    }

    static J.Binary newLogicalExpression(J.Binary.Type operator, Expression left, Expression right) {
        return new J.Binary(Tree.randomId(), Space.EMPTY, Markers.EMPTY, left, new JLeftPadded(Space.SINGLE_SPACE, (Object)operator, Markers.EMPTY), right, (JavaType)JavaType.Primitive.Boolean);
    }

    static J.MemberReference newStaticMethodReference(JavaType.Method method, boolean qualified, @Nullable JavaType type) {
        JavaType.FullyQualified declaringType = method.getDeclaringType();
        Expression containing = JavaElementFactory.className((JavaType)declaringType, qualified);
        return JavaElementFactory.newInstanceMethodReference(containing, method, type);
    }

    static Expression className(JavaType type, boolean qualified) {
        Object name = null;
        if (type instanceof JavaType.Parameterized) {
            type = ((JavaType.Parameterized)type).getType();
        }
        if (qualified && type instanceof JavaType.FullyQualified && ((JavaType.FullyQualified)type).getOwningClass() != null) {
            Expression expression = JavaElementFactory.className((JavaType)((JavaType.FullyQualified)type).getOwningClass(), true);
            String simpleName = ((JavaType.FullyQualified)type).getClassName();
            return new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, expression, new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), simpleName.substring(simpleName.lastIndexOf(46) + 1), type, null), Markers.EMPTY), type);
        }
        String qualifiedName = type instanceof JavaType.FullyQualified ? (qualified ? ((JavaType.FullyQualified)type).getFullyQualifiedName() : ((JavaType.FullyQualified)type).getClassName()) : type.toString();
        if (qualifiedName.matches(".*\\$\\d+.*")) {
            String simpleName = qualifiedName.replaceAll(".*\\$\\d+", "");
            if ((simpleName = simpleName.replace('$', '.')).indexOf(46) > 0) {
                simpleName = simpleName.substring(simpleName.lastIndexOf(46) + 1);
            }
            return new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), simpleName, type, null);
        }
        Scanner scanner = new Scanner(qualifiedName.replace('$', '.')).useDelimiter("\\.");
        int i = 0;
        while (scanner.hasNext()) {
            String part = scanner.next();
            JavaType.Unknown typeOfContaining = scanner.hasNext() ? JavaType.Unknown.getInstance() : type;
            name = i > 0 ? new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)name, new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), part, (JavaType)typeOfContaining, null), Markers.EMPTY), (JavaType)typeOfContaining) : new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), part, type, null);
            ++i;
        }
        assert (name != null);
        return name;
    }

    static J.MemberReference newInstanceMethodReference(Expression containing, JavaType.Method method, @Nullable JavaType type) {
        return JavaElementFactory.newInstanceMethodReference(containing, method.getName(), method, type);
    }

    static J.MemberReference newInstanceMethodReference(Expression containing, String methodName, JavaType.Method methodType, @Nullable JavaType type) {
        return new J.MemberReference(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded((Object)containing, Space.EMPTY, Markers.EMPTY), null, new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), methodName, null, null), Markers.EMPTY), type, methodType, null);
    }

    static J.FieldAccess newClassLiteral(JavaType.Class classType, JavaType originalType, J instanceOfClass) {
        JavaType.Parameterized parameterized = new JavaType.Parameterized(null, (JavaType.FullyQualified)classType, Collections.singletonList(originalType));
        return new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)instanceOfClass.withPrefix(Space.EMPTY), new JLeftPadded(Space.EMPTY, (Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "class", (JavaType)parameterized, null), Markers.EMPTY), (JavaType)parameterized);
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable JavaType.Class getClassType(@Nullable JavaType type) {
        if (type instanceof JavaType.Class) {
            JavaType.Class classType = (JavaType.Class)type;
            if ("java.lang.Class".equals(classType.getFullyQualifiedName())) {
                return classType;
            }
            if ("java.lang.Object".equals(classType.getFullyQualifiedName())) {
                for (JavaType.Method method : classType.getMethods()) {
                    if (!"getClass".equals(method.getName())) continue;
                    return JavaElementFactory.getClassType(method.getReturnType());
                }
                return null;
            }
            return JavaElementFactory.getClassType((JavaType)classType.getSupertype());
        }
        if (type instanceof JavaType.Parameterized) {
            return JavaElementFactory.getClassType((JavaType)((JavaType.Parameterized)type).getType());
        }
        if (type instanceof JavaType.GenericTypeVariable) {
            return JavaElementFactory.getClassType((JavaType)((JavaType.GenericTypeVariable)type).getBounds().get(0));
        }
        if (type instanceof JavaType.Array) {
            return JavaElementFactory.getClassType(((JavaType.Array)type).getElemType());
        }
        if (type instanceof JavaType.Variable) {
            return JavaElementFactory.getClassType(((JavaType.Variable)type).getOwner());
        }
        if (type instanceof JavaType.Method) {
            return JavaElementFactory.getClassType((JavaType)((JavaType.Method)type).getDeclaringType());
        }
        return null;
    }

    public static J.Identifier newThis(JavaType type) {
        return new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "this", type, null);
    }
}

