package org.nuiton.wikitty.entities;

/*
 * #%L
 * Wikitty :: dto
 * %%
 * Copyright (C) 2010 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Generated;
import org.nuiton.wikitty.WikittyException;

@Generated(value = "org.nuiton.wikitty.generator.WikittyDTOGenerator", date = "Mon Jul 20 19:15:35 CEST 2015")
public class WikittyAuthorisationDTO implements WikittyAuthorisation {

    @WikittyField(fqn = "WikittyAuthorisation.owner")
    protected String owner;

    @WikittyField(fqn = "WikittyAuthorisation.admin")
    protected Set<String> admin = new LinkedHashSet<String>();

    @WikittyField(fqn = "WikittyAuthorisation.writer")
    protected Set<String> writer = new LinkedHashSet<String>();

    @WikittyField(fqn = "WikittyAuthorisation.reader")
    protected Set<String> reader = new LinkedHashSet<String>();

    @WikittyField(fqn = "WikittyAuthorisation.parent")
    protected Set<String> parent = new LinkedHashSet<String>();

    protected String wikittyId;

    protected int modificationCount = 0;

    protected String wikittyVersion;

    @Override
    public String getOwner() {
        return owner;
}

    @Override
    public void setOwner(String owner) {
        this.owner=owner;
        modificationCount++;
}

    @Override
    public WikittyUser getOwner(boolean exceptionIfNotLoaded) {
        if (exceptionIfNotLoaded) {
            throw new WikittyException("Preload is not implemented in DTO");
        } else {
            return null;
        }
}

    @Override
    public void setOwner(WikittyUser owner) {
        setOwner(owner.getWikittyId());
}

    @Override
    public Set<String> getAdmin() {
        return admin;
}

    @Override
    public void setAdmin(Set<String> admin) {
        if (admin == null){
            this.admin = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.admin=new LinkedHashSet<String>(admin);
        }
        modificationCount++;
}

    @Override
    public void addAllAdmin(Collection<String> admin) {
        if (this.admin == null){
            this.admin = new LinkedHashSet<String>();
        }
        this.admin.addAll(admin);
        modificationCount++;
}

    @Override
    public void addAdmin(String... element) {
        if (this.admin == null){
            this.admin = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.admin.add(v);
        }
        modificationCount++;
}

    @Override
    public void removeAdmin(String... element) {
        if (this.admin != null) {
            for (String v : element) {
                admin.remove(element);
            }
            modificationCount++;
        }
}

    @Override
    public void clearAdmin() {
        if (this.admin != null) {
            admin.clear();
            modificationCount++;
        }
}

    @Override
    public Set<Wikitty> getAdmin(boolean exceptionIfNotLoaded) {
        if (exceptionIfNotLoaded) {
            throw new WikittyException("Preload is not implemented in DTO");
        } else {
            return null;
        }
}

    @Override
    public void setAdminEntity(Collection<Wikitty> admin) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : admin) {
            tmp.add(e.getWikittyId());
        }
        setAdmin(tmp);
}

    @Override
    public void addAllAdminEntity(Collection<Wikitty> admin) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : admin) {
            tmp.add(e.getWikittyId());
        }
        addAllAdmin(tmp);
}

    @Override
    public void addAdmin(Wikitty... element) {
        String[] tmp = new String[element.length];
        for (int i=0; i<element.length; i++) {
            tmp[i] = element[i].getWikittyId();
        }
        addAdmin(tmp);
}

    @Override
    public void removeAdmin(Wikitty... element) {
        String[] tmp = new String[element.length];
        for (int i=0; i<element.length; i++) {
            tmp[i] = element[i].getWikittyId();
        }
        removeAdmin(tmp);
}

    @Override
    public Set<String> getWriter() {
        return writer;
}

    @Override
    public void setWriter(Set<String> writer) {
        if (writer == null){
            this.writer = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.writer=new LinkedHashSet<String>(writer);
        }
        modificationCount++;
}

    @Override
    public void addAllWriter(Collection<String> writer) {
        if (this.writer == null){
            this.writer = new LinkedHashSet<String>();
        }
        this.writer.addAll(writer);
        modificationCount++;
}

    @Override
    public void addWriter(String... element) {
        if (this.writer == null){
            this.writer = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.writer.add(v);
        }
        modificationCount++;
}

    @Override
    public void removeWriter(String... element) {
        if (this.writer != null) {
            for (String v : element) {
                writer.remove(element);
            }
            modificationCount++;
        }
}

    @Override
    public void clearWriter() {
        if (this.writer != null) {
            writer.clear();
            modificationCount++;
        }
}

    @Override
    public Set<Wikitty> getWriter(boolean exceptionIfNotLoaded) {
        if (exceptionIfNotLoaded) {
            throw new WikittyException("Preload is not implemented in DTO");
        } else {
            return null;
        }
}

    @Override
    public void setWriterEntity(Collection<Wikitty> writer) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : writer) {
            tmp.add(e.getWikittyId());
        }
        setWriter(tmp);
}

    @Override
    public void addAllWriterEntity(Collection<Wikitty> writer) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : writer) {
            tmp.add(e.getWikittyId());
        }
        addAllWriter(tmp);
}

    @Override
    public void addWriter(Wikitty... element) {
        String[] tmp = new String[element.length];
        for (int i=0; i<element.length; i++) {
            tmp[i] = element[i].getWikittyId();
        }
        addWriter(tmp);
}

    @Override
    public void removeWriter(Wikitty... element) {
        String[] tmp = new String[element.length];
        for (int i=0; i<element.length; i++) {
            tmp[i] = element[i].getWikittyId();
        }
        removeWriter(tmp);
}

    @Override
    public Set<String> getReader() {
        return reader;
}

    @Override
    public void setReader(Set<String> reader) {
        if (reader == null){
            this.reader = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.reader=new LinkedHashSet<String>(reader);
        }
        modificationCount++;
}

    @Override
    public void addAllReader(Collection<String> reader) {
        if (this.reader == null){
            this.reader = new LinkedHashSet<String>();
        }
        this.reader.addAll(reader);
        modificationCount++;
}

    @Override
    public void addReader(String... element) {
        if (this.reader == null){
            this.reader = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.reader.add(v);
        }
        modificationCount++;
}

    @Override
    public void removeReader(String... element) {
        if (this.reader != null) {
            for (String v : element) {
                reader.remove(element);
            }
            modificationCount++;
        }
}

    @Override
    public void clearReader() {
        if (this.reader != null) {
            reader.clear();
            modificationCount++;
        }
}

    @Override
    public Set<Wikitty> getReader(boolean exceptionIfNotLoaded) {
        if (exceptionIfNotLoaded) {
            throw new WikittyException("Preload is not implemented in DTO");
        } else {
            return null;
        }
}

    @Override
    public void setReaderEntity(Collection<Wikitty> reader) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : reader) {
            tmp.add(e.getWikittyId());
        }
        setReader(tmp);
}

    @Override
    public void addAllReaderEntity(Collection<Wikitty> reader) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : reader) {
            tmp.add(e.getWikittyId());
        }
        addAllReader(tmp);
}

    @Override
    public void addReader(Wikitty... element) {
        String[] tmp = new String[element.length];
        for (int i=0; i<element.length; i++) {
            tmp[i] = element[i].getWikittyId();
        }
        addReader(tmp);
}

    @Override
    public void removeReader(Wikitty... element) {
        String[] tmp = new String[element.length];
        for (int i=0; i<element.length; i++) {
            tmp[i] = element[i].getWikittyId();
        }
        removeReader(tmp);
}

    @Override
    public Set<String> getParent() {
        return parent;
}

    @Override
    public void setParent(Set<String> parent) {
        if (parent == null){
            this.parent = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.parent=new LinkedHashSet<String>(parent);
        }
        modificationCount++;
}

    @Override
    public void addAllParent(Collection<String> parent) {
        if (this.parent == null){
            this.parent = new LinkedHashSet<String>();
        }
        this.parent.addAll(parent);
        modificationCount++;
}

    @Override
    public void addParent(String... element) {
        if (this.parent == null){
            this.parent = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.parent.add(v);
        }
        modificationCount++;
}

    @Override
    public void removeParent(String... element) {
        if (this.parent != null) {
            for (String v : element) {
                parent.remove(element);
            }
            modificationCount++;
        }
}

    @Override
    public void clearParent() {
        if (this.parent != null) {
            parent.clear();
            modificationCount++;
        }
}

    @Override
    public Set<WikittyAuthorisation> getParent(boolean exceptionIfNotLoaded) {
        if (exceptionIfNotLoaded) {
            throw new WikittyException("Preload is not implemented in DTO");
        } else {
            return null;
        }
}

    @Override
    public void setParentEntity(Collection<WikittyAuthorisation> parent) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (WikittyAuthorisation e : parent) {
            tmp.add(e.getWikittyId());
        }
        setParent(tmp);
}

    @Override
    public void addAllParentEntity(Collection<WikittyAuthorisation> parent) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (WikittyAuthorisation e : parent) {
            tmp.add(e.getWikittyId());
        }
        addAllParent(tmp);
}

    @Override
    public void addParent(WikittyAuthorisation... element) {
        String[] tmp = new String[element.length];
        for (int i=0; i<element.length; i++) {
            tmp[i] = element[i].getWikittyId();
        }
        addParent(tmp);
}

    @Override
    public void removeParent(WikittyAuthorisation... element) {
        String[] tmp = new String[element.length];
        for (int i=0; i<element.length; i++) {
            tmp[i] = element[i].getWikittyId();
        }
        removeParent(tmp);
}

    public WikittyAuthorisationDTO() {
}

    public WikittyAuthorisationDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getStaticExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Object getFieldAsObject(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof WikittyAuthorisation)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        WikittyAuthorisation sourceCopy = (WikittyAuthorisation)source;

        setOwner(sourceCopy.getOwner());

        Set<String> admin = sourceCopy.getAdmin();
        if (admin != null){
            setAdmin(new LinkedHashSet<String>(admin));
        }

        Set<String> writer = sourceCopy.getWriter();
        if (writer != null){
            setWriter(new LinkedHashSet<String>(writer));
        }

        Set<String> reader = sourceCopy.getReader();
        if (reader != null){
            setReader(new LinkedHashSet<String>(reader));
        }

        Set<String> parent = sourceCopy.getParent();
        if (parent != null){
            setParent(new LinkedHashSet<String>(parent));
        }

        setWikittyVersion(sourceCopy.getWikittyVersion());
}

} //WikittyAuthorisationDTO
