package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.nuiton.wikitty.WikittyUtil;

@Generated(value = "org.nuiton.wikitty.generator.WikittyHelperGenerator", date = "Mon Jul 20 19:15:08 CEST 2015")
public class WikittyI18nHelper {

    /**
     * utility class all provided methods are accessible the static way
     */
    private WikittyI18nHelper() {// empty
}

    public static Set<String> getTranslatableValues(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES, String.class);
        return result;
}

    public static void setTranslatableValues(Wikitty wikitty, Set<String> translatableValues) {
        wikitty.setField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES, translatableValues);
}

    public static void addAllTranslatableValues(Wikitty wikitty, Collection<String> translatableValues) {
        if(translatableValues != null){
            for (String v:translatableValues){
                addTranslatableValues(wikitty, v);
            }
        }
}

    public static void addTranslatableValues(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.addToField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES, v);
        }
}

    public static void removeTranslatableValues(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.removeFromField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES, v);
        }
}

    public static void clearTranslatableValues(Wikitty wikitty) {
        wikitty.clearField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES);
}

    public static Set<String> getLang(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_LANG, String.class);
        return result;
}

    public static void setLang(Wikitty wikitty, Set<String> lang) {
        wikitty.setField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_LANG, lang);
}

    public static void addAllLang(Wikitty wikitty, Collection<String> lang) {
        if(lang != null){
            for (String v:lang){
                addLang(wikitty, v);
            }
        }
}

    public static void addLang(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.addToField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_LANG, v);
        }
}

    public static void removeLang(Wikitty wikitty, String... element) {
        for (String v : element) {
            wikitty.removeFromField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_LANG, v);
        }
}

    public static void clearLang(Wikitty wikitty) {
        wikitty.clearField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_LANG);
}

    public static String getTranslations(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATIONS);
        return value;
}

    public static String setTranslations(Wikitty wikitty, String translations) {
        String oldValue = getTranslations(wikitty);
        wikitty.setField(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATIONS, translations);
        return oldValue;
}

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES);
            Object f2 = w2.getFieldAsObject(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATABLEVALUES);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_LANG);
            Object f2 = w2.getFieldAsObject(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_LANG);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATIONS);
            Object f2 = w2.getFieldAsObject(WikittyI18n.EXT_WIKITTYI18N, WikittyI18n.FIELD_WIKITTYI18N_TRANSLATIONS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return 
     */
    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * check if wikitty has current extension
     * @param wikitty 
     * @return 
     */
    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyI18n.EXT_WIKITTYI18N);
}

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyI18nAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}

    /**
     * supprime les extensions de cette classe au wikitty en argument
     * @param wikitty 
     */
    public static void removeExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyI18nAbstract.extensions) {
            wikitty.removeExtension(ext.getName());
        }
}

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @param wikitty 
     * @return 
     */
    public static String toString(Wikitty wikitty) {

        return wikitty.toString(WikittyI18n.EXT_WIKITTYI18N);
}

    /**
     * add WikittyI18n meta-extension on given extension to the given wikitty
     * @param extension 
     * @param wikitty 
     */
    public static void addMetaExtension(WikittyExtension extension, Wikitty wikitty) {
        wikitty.addMetaExtension(WikittyI18nAbstract.extensionWikittyI18n, extension);
}

    /**
     * true if given wikitty has WikittyI18n meta-extension on given extension
     * @param extension 
     * @param wikitty 
     * @return 
     */
    public static boolean hasMetaExtension(WikittyExtension extension, Wikitty wikitty) {
        return wikitty.hasMetaExtension(WikittyI18n.EXT_WIKITTYI18N, extension.getName());
}

    /**
     * for extension 'Ext' and field 'f', return 'Ext:WikittyI18n.f'
     * @param extension 
     * @param fieldName 
     * @return 
     */
    public static String getMetaFieldName(WikittyExtension extension, String fieldName) {
        String metaFieldName = getMetaFieldName(extension.getName(), fieldName); 
        return metaFieldName;
}

    /**
     * for extension 'Ext' and field 'f', return 'Ext:WikittyI18n.f'
     * @param extensionName 
     * @param fieldName 
     * @return 
     */
    public static String getMetaFieldName(String extensionName, String fieldName) {
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyI18n", extensionName, fieldName);
        return metaFieldName;
}

    public static Set<String> getTranslatableValues(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "translatableValues");
        Set<String> result = (Set<String>) wikitty.getFqField(fieldName);
        return result;
}

    public static void setTranslatableValues(String extensionName, Wikitty wikitty, Set<String> translatableValues) {
        clearTranslatableValues(extensionName, wikitty);
        addAllTranslatableValues(extensionName, wikitty, translatableValues);
}

    public static void addAllTranslatableValues(String extensionName, Wikitty wikitty, Collection<String> translatableValues) {
        if(translatableValues != null){
            for (String id:translatableValues){
                addTranslatableValues(extensionName, wikitty, id);
            }
        }
}

    public static void addTranslatableValues(String extensionName, Wikitty wikitty, String... element) {
        for (String v : element) {
            String fieldName = getMetaFieldName(extensionName, "translatableValues");
            wikitty.addToField(fieldName, v);
        }
}

    public static void removeTranslatableValues(String extensionName, Wikitty wikitty, String... element) {
        for (String v : element) {
            String fieldName = getMetaFieldName(extensionName, "translatableValues");
            wikitty.removeFromField(fieldName, v);
        }
}

    public static void clearTranslatableValues(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "translatableValues");
        wikitty.clearField(fieldName);
}

    public static Set<String> getLang(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "lang");
        Set<String> result = (Set<String>) wikitty.getFqField(fieldName);
        return result;
}

    public static void setLang(String extensionName, Wikitty wikitty, Set<String> lang) {
        clearLang(extensionName, wikitty);
        addAllLang(extensionName, wikitty, lang);
}

    public static void addAllLang(String extensionName, Wikitty wikitty, Collection<String> lang) {
        if(lang != null){
            for (String id:lang){
                addLang(extensionName, wikitty, id);
            }
        }
}

    public static void addLang(String extensionName, Wikitty wikitty, String... element) {
        for (String v : element) {
            String fieldName = getMetaFieldName(extensionName, "lang");
            wikitty.addToField(fieldName, v);
        }
}

    public static void removeLang(String extensionName, Wikitty wikitty, String... element) {
        for (String v : element) {
            String fieldName = getMetaFieldName(extensionName, "lang");
            wikitty.removeFromField(fieldName, v);
        }
}

    public static void clearLang(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "lang");
        wikitty.clearField(fieldName);
}

    public static String getTranslations(String extensionName, Wikitty wikitty) {
        String fieldName = getMetaFieldName(extensionName, "translations");
        String value = (String) wikitty.getFqField(fieldName);        
        return value;
}

    public static String setTranslations(String extensionName, Wikitty wikitty, String translations) {
        String oldValue = getTranslations(extensionName, wikitty);
        String fieldName = getMetaFieldName(extensionName, "translations");
        wikitty.setFqField(fieldName, translations);
        return oldValue;
}

} //WikittyI18nHelper
