/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.security;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.nuiton.web.SecurityDAOHelper;
import org.nuiton.web.security.SecurityRole;
import org.nuiton.web.security.SecurityUserDAO;
import org.nuiton.web.security.SecurityUtil;

public class TopiaSecurityRealm
extends AuthorizingRealm
implements CredentialsMatcher {
    private static final Log log = LogFactory.getLog(TopiaSecurityRealm.class);
    protected TopiaContext rootContext;
    protected ApplicationConfig config;

    public TopiaSecurityRealm(TopiaContext rootContext, ApplicationConfig config) {
        this.rootContext = rootContext;
        this.config = config;
        this.setCredentialsMatcher(this);
    }

    public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
        char[] tokenCredentials = (char[])token.getCredentials();
        String submittedPassword = String.valueOf(tokenCredentials);
        String submittedHashedPassword = StringUtil.encodeMD5((String)submittedPassword);
        String expectedHashedPassword = (String)info.getCredentials();
        return expectedHashedPassword.equals(submittedHashedPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo result;
        block21: {
            result = null;
            Properties props = this.config.getFlatOptions();
            TopiaContext transaction = null;
            try {
                String login = (String)principals.getPrimaryPrincipal();
                transaction = this.rootContext.beginTransaction();
                SecurityUserDAO securityUserDAO = SecurityDAOHelper.getSecurityUserDAO(transaction);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Build autorisation list for user : " + login));
                }
                Object securityUser = securityUserDAO.findByLogin(login);
                result = new SimpleAuthorizationInfo();
                for (SecurityRole role : securityUser.getSecurityRole()) {
                    for (String permission : role.getPermissions()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("- add permission : " + permission));
                        }
                        for (String prop : props.stringPropertyNames()) {
                            String[] permTab;
                            String endProp;
                            String[] subs;
                            if (!prop.startsWith("topia.security.permission.") || (subs = (endProp = StringUtils.removeStart((String)prop, (String)"topia.security.permission.")).split("\\.")).length != 3 || !subs[2].equals("perm") || !subs[1].equals(permission)) continue;
                            String perms = props.getProperty(prop);
                            for (String perm : permTab = perms.split("\\s*\\;\\s*")) {
                                result.addStringPermission(perm);
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)("  string permission : " + perm));
                            }
                        }
                    }
                }
                if (login.equals("anonymous") && securityUserDAO.count() == 1L) {
                    result.addStringPermission("*");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Grant all rigth (*) because no user exists");
                    }
                }
                if (this.config.getOptionAsBoolean("topia.security.disable")) {
                    result.addStringPermission("*");
                }
                result.addStringPermission("url" + SecurityUtil.convertToShiroPerm(this.config.getOption("topia.security.loginurl"), this.config.getOption("topia.security.separators")));
                result.addStringPermission("url" + SecurityUtil.convertToShiroPerm(this.config.getOption("topia.security.logouturl"), this.config.getOption("topia.security.separators")));
            }
            catch (Exception ex) {
                if (transaction == null) break block21;
                try {
                    transaction.closeContext();
                }
                catch (TopiaException ex2) {
                    throw new TopiaRuntimeException((Throwable)ex2);
                }
            }
            finally {
                if (transaction != null) {
                    try {
                        transaction.closeContext();
                    }
                    catch (TopiaException ex) {
                        throw new TopiaRuntimeException((Throwable)ex);
                    }
                }
            }
        }
        return result;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken usernamePasswordToken = (UsernamePasswordToken)token;
        String login = usernamePasswordToken.getUsername();
        if (log.isDebugEnabled()) {
            log.debug((Object)("doGetAuthenticationInfo for login : " + login));
        }
        SimpleAuthenticationInfo result = null;
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            SecurityUserDAO securityUserDAO = SecurityDAOHelper.getSecurityUserDAO(transaction);
            Object securityUser = securityUserDAO.findByLogin(login);
            if (securityUser != null) {
                result = login.equals("anonymous") ? new SimpleAuthenticationInfo((Object)securityUser.getLogin(), (Object)StringUtil.encodeMD5((String)""), this.getName()) : new SimpleAuthenticationInfo((Object)securityUser.getLogin(), (Object)securityUser.getPassword(), this.getName());
            }
        }
        catch (TopiaException ex) {
            throw new TopiaRuntimeException((Throwable)ex);
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.closeContext();
                }
                catch (TopiaException ex) {
                    throw new TopiaRuntimeException((Throwable)ex);
                }
            }
        }
        return result;
    }
}

