/* *##% 
 * ToPIA :: SOA
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/

package org.nuiton.topia.service.clients;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.service.TopiaApplicationService;
import org.nuiton.topia.service.TopiaProxy;

/**
 * XMLRPCProxy.java
 *
 * @author chatellier
 * @version $Revision: 1715 $
 *
 * Last update : $Date: 2009-12-15 01:26:16 +0100 (mar., 15 déc. 2009) $
 * By : $Author: tchemit $
 */
public class XMLRPCProxy implements TopiaProxy {

    /** Logger (common logging) */
    private static final Log logger = LogFactory.getLog(XMLRPCProxy.class);

    /** location du service */
    protected String serviceLocation = null;

    /** La classe geree par le proxy */
    protected Class<? extends TopiaApplicationService> clazz;

    /* (non-Javadoc)
     * @see java.lang.reflect.InvocationHandler#invoke(java.lang.Object, java.lang.reflect.Method, java.lang.Object[])
     */
    public Object invoke(Object proxy, Method method, Object[] args)
            throws Throwable {

        Object result = null;

        logger.debug("Invoke : " + clazz.getName() + "." + method.getName()
                + "(" + Arrays.toString(args) + ")");

        logger.debug("XML-RPC , Using uri = http:" + this.serviceLocation);

        //Le client XMLRPC de crispy est en version < 3

        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        try {
            config.setServerURL(new URL("http:" + this.serviceLocation));
            XmlRpcClient client = new XmlRpcClient();
            client
                    .setTransportFactory(new XmlRpcCommonsTransportFactory(
                            client));
            client.setConfig(config);
            result = client.execute(clazz.getName() + "." + method.getName(),
                    args);
        } catch (java.net.MalformedURLException e) {
            System.out.println("Caught MalformedURLException\n");
            e.printStackTrace();
        } catch (XmlRpcException e) {
            System.out.println("Caught XmlRpcException\n");
            e.printStackTrace();
        }

        return result;
    }

    /* (non-Javadoc)
     * @see org.nuiton.topia.service.clients.TopiaProxy#setURI(java.net.URI)
     */
    public void setURI(URI uri) {
        serviceLocation = uri.getRawSchemeSpecificPart();
    }

    /* (non-Javadoc)
     * @see org.nuiton.topia.service.clients.TopiaProxy#setClass(java.lang.Class)
     */
    public void setClass(Class<? extends TopiaApplicationService> clazz) {
        this.clazz = clazz;
    }

    public void destroy() {
    }

    public void init(TopiaContext context) {
    }

}
