/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.servers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.service.TopiaApplicationService;
import org.nuiton.topia.service.TopiaServiceServerAbstract;
import org.nuiton.topia.service.servers.RemoteClassLoader;
import sun.rmi.server.UnicastServerRef;

public class RMIServer
extends TopiaServiceServerAbstract
implements Runnable,
InvocationHandler {
    private static final Log logger = LogFactory.getLog(RMIServer.class);
    protected static final int DEFAULT_PORT = 1099;
    protected Registry registry;
    protected boolean alreadyLaunched = false;

    public RMIServer() throws RemoteException {
        this(1099);
    }

    public RMIServer(int port) throws RemoteException {
        this.registry = LocateRegistry.createRegistry(port);
        logger.info((Object)("Starting RMIRegistry on port " + port + "..."));
    }

    @Override
    public void addService(Class<? extends TopiaApplicationService> clazz) {
        try {
            Class<?> clazz2 = RemoteClassLoader.getRemoteClass(clazz);
            Remote meProxy = (Remote)Proxy.newProxyInstance(clazz2.getClassLoader(), new Class[]{clazz2}, (InvocationHandler)this);
            Remote stub = new UnicastServerRef(false).exportObject(meProxy, null, false);
            this.registry.rebind(clazz.getName(), stub);
            logger.info((Object)("Binding new rmi service = " + clazz.getName()));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        logger.info((Object)"RMI Server running...");
        while (true) {
            try {
                while (true) {
                    Thread.sleep(Long.MAX_VALUE);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        logger.debug((Object)("Invoke RMIServer = " + method.getName() + "(" + Arrays.toString(args) + ")"));
        Class<?> clazzToCall = method.getDeclaringClass();
        Class<?> realClass = Class.forName(RemoteClassLoader.getOriginClassName(clazzToCall));
        Method realMethod = realClass.getMethod(method.getName(), method.getParameterTypes());
        Object result = null;
        if (clazzToCall != null) {
            logger.debug((Object)("Requested class = " + realClass.getName()));
            result = super.invoke(realMethod, args);
        }
        return result;
    }

    @Override
    public void launch() {
        if (!this.alreadyLaunched) {
            new Thread(this).start();
            this.alreadyLaunched = true;
        }
    }
}

