/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.taas.jaas;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaSecurityDAOHelper;
import org.nuiton.topia.taas.TaasService;
import org.nuiton.topia.taas.TaasUtil;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserDAO;
import org.nuiton.topia.taas.jaas.TaasPrincipalWrapper;

public class TaasLoginModule
implements LoginModule {
    private Log log = LogFactory.getLog(TaasLoginModule.class);
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Set<TaasPrincipalWrapper> principals;
    protected TaasUser privateCredential;
    protected TaasService taasService;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.principals = null;
        this.privateCredential = null;
        this.taasService = (TaasService)options.get("taas");
    }

    @Override
    public boolean login() throws LoginException {
        block20: {
            try {
                if (this.callbackHandler == null) {
                    throw new LoginException("CallbackHandler cannot be null");
                }
                if (this.taasService == null) {
                    throw new LoginException("TaasService property must be set");
                }
                NameCallback nc = new NameCallback("login");
                PasswordCallback pc = new PasswordCallback("password", false);
                Callback[] callbacks = new Callback[]{nc, pc};
                try {
                    this.callbackHandler.handle(callbacks);
                }
                catch (Exception eee) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)"Utilisation du CallbackHandler impossible", (Throwable)eee);
                    }
                    LoginException le = new LoginException("Utilisation du CallbackHandler impossible");
                    le.initCause(eee);
                    throw le;
                }
                String login = nc.getName();
                String password = new String(pc.getPassword());
                pc.clearPassword();
                String hashed = TaasUtil.hash(password);
                TopiaContext transaction = null;
                try {
                    TopiaContext rootContext = this.taasService.getRootContextNoSecure();
                    transaction = rootContext.beginTransaction();
                    TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO(transaction);
                    Object user = userDAO.findByLogin(login);
                    if (user != null && user.getPassword().equals(hashed) && user.getEnabled()) {
                        this.privateCredential = user;
                        user.setLastConnectionDate(new Date());
                        int numberOfConnection = user.getNumberOfConnection();
                        user.setNumberOfConnection(numberOfConnection + 1);
                        user.update();
                        this.principals = new HashSet<TaasPrincipalWrapper>();
                        Collection<TaasPrincipal> taasPrincipals = user.getPrincipals();
                        for (TaasPrincipal taasPrincipal : taasPrincipals) {
                            this.principals.add(new TaasPrincipalWrapper(taasPrincipal));
                        }
                        break block20;
                    }
                    this.principals = null;
                    this.privateCredential = null;
                    throw new LoginException("Erreur lors de l'authentification " + login);
                }
                catch (Exception e) {
                    LoginException le = new LoginException("Erreur lors de l'authentification" + login);
                    le.initCause(e);
                    this.log.error((Object)e);
                    throw le;
                }
                finally {
                    if (transaction != null) {
                        try {
                            transaction.commitTransaction();
                            transaction.closeContext();
                        }
                        catch (TopiaException e) {
                            throw new LoginException("Erreur lors de l'authentification " + login);
                        }
                    }
                }
            }
            catch (LoginException eee) {
                this.log.error((Object)"LoginException : ", (Throwable)eee);
            }
            catch (Throwable eee) {
                this.log.error((Object)eee);
                throw new LoginException(eee.getMessage());
            }
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        try {
            this.subject.getPrincipals().addAll(this.principals);
            if (this.log.isDebugEnabled()) {
                for (TaasPrincipalWrapper principal : this.principals) {
                    this.log.debug((Object)("Permissions for principal " + principal.getName() + " : " + principal.getPermissions()));
                }
            }
            this.subject.getPrivateCredentials().add(this.privateCredential);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Private credential size : " + this.subject.getPrivateCredentials().size() + " for subject : " + this.subject));
            }
        }
        catch (Exception eee) {
            this.log.error((Object)"Cant commit : ", (Throwable)eee);
            throw new LoginException(eee.getMessage());
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return this.logout();
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.subject = null;
        this.principals.clear();
        this.principals = null;
        this.callbackHandler = null;
        return true;
    }
}

