package org.nuiton.topia.security.entities.user;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class TopiaGroupDAOAbstract<E extends TopiaGroup> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TopiaGroup.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        {
            List<org.nuiton.topia.security.entities.user.TopiaUser> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from topiaUser main, topiagroup_topiauser secondary " +
                    "where main.topiaid=secondary.topiaUser" +
                    " and secondary.topiaGroup='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaSecurityDAOHelper.getImplementationClass(org.nuiton.topia.security.entities.user.TopiaUser.class)).list();
            for (org.nuiton.topia.security.entities.user.TopiaUser item : list) {
                item.removeTopiaGroup(entity);
            }
        }

                {
                List<org.nuiton.topia.security.entities.user.TopiaGroup> list = getContext()
                            .getDAO(org.nuiton.topia.security.entities.user.TopiaGroup.class)
                            .findAllByProperties("superGroup", entity);
                    for (org.nuiton.topia.security.entities.user.TopiaGroup item : list) {
                        item.setSuperGroup(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }

    /**
     * findByDescription :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut description le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByDescription(String v) throws TopiaException {
        E result = findByProperty("description", v);
        return result;
    }

    /**
     * findAllByDescription :
     * Retourne les éléments ayant comme valeur pour l'attribut description le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByDescription(String v) throws TopiaException {
        List<E> result = findAllByProperty("description", v);
        return result;
    }

    /**
     * findContainsTopiaUser :
     * Retourne le premier élément trouvé dont l'attribut topiaUser contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsTopiaUser(TopiaUser... v) throws TopiaException {
        E result = findContainsProperties("topiaUser", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsTopiaUser :
     * Retourne les éléments trouvé dont l'attribut topiaUser contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsTopiaUser(TopiaUser... v) throws TopiaException {
        List<E> results = findAllContainsProperties("topiaUser", Arrays.asList(v));
        return results;
    }

    /**
     * findBySuperGroup :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut superGroup le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySuperGroup(TopiaGroup v) throws TopiaException {
        E result = findByProperty("superGroup", v);
        return result;
    }

    /**
     * findAllBySuperGroup :
     * Retourne les éléments ayant comme valeur pour l'attribut superGroup le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySuperGroup(TopiaGroup v) throws TopiaException {
        List<E> result = findAllByProperty("superGroup", v);
        return result;
    }

    /**
     * findContainsSubGroup :
     * Retourne le premier élément trouvé dont l'attribut subGroup contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsSubGroup(TopiaGroup... v) throws TopiaException {
        E result = findContainsProperties("subGroup", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsSubGroup :
     * Retourne les éléments trouvé dont l'attribut subGroup contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsSubGroup(TopiaGroup... v) throws TopiaException {
        List<E> results = findAllContainsProperties("subGroup", Arrays.asList(v));
        return results;
    }


} //TopiaGroupDAOAbstract<E extends TopiaGroup>
