package org.nuiton.topia.taas.entities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link TaasUser}.
 */
public abstract class TaasUserAbstract extends TopiaEntityAbstract implements TaasUser {

    protected String login;

    protected String password;

    protected String email;

    protected boolean enabled;

    protected Date lastConnectionDate;

    protected int numberOfConnection;

    public String link;

    public Collection<TaasPrincipal> principals;

    /**
     * Constructeur de TaasUserAbstract par défaut.
     */
    public TaasUserAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TaasUser.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TaasUser.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "login", String.class, login);
        visitor.visit(this, "password", String.class, password);
        visitor.visit(this, "email", String.class, email);
        visitor.visit(this, "enabled", boolean.class, enabled);
        visitor.visit(this, "lastConnectionDate", Date.class, lastConnectionDate);
        visitor.visit(this, "numberOfConnection", int.class, numberOfConnection);
        visitor.visit(this, "link", String.class, link);
        visitor.visit(this, "principals", Collection.class, TaasPrincipal.class, principals);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see TaasUser#setLogin(String)
     */
    @Override
    public void setLogin(String value) {
        String _oldValue = this.login;
        fireOnPreWrite("login", _oldValue, value);
        this.login = value;
        fireOnPostWrite("login", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TaasUser#getLogin()
     */
    @Override
    public String getLogin() {
        fireOnPreRead("login", login);
        String result = this.login;
        fireOnPostRead("login", login);
        return result;
    }

    /* (non-Javadoc)
     * @see TaasUser#setPassword(String)
     */
    @Override
    public void setPassword(String value) {
        String _oldValue = this.password;
        fireOnPreWrite("password", _oldValue, value);
        this.password = value;
        fireOnPostWrite("password", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TaasUser#getPassword()
     */
    @Override
    public String getPassword() {
        fireOnPreRead("password", password);
        String result = this.password;
        fireOnPostRead("password", password);
        return result;
    }

    /* (non-Javadoc)
     * @see TaasUser#setEmail(String)
     */
    @Override
    public void setEmail(String value) {
        String _oldValue = this.email;
        fireOnPreWrite("email", _oldValue, value);
        this.email = value;
        fireOnPostWrite("email", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TaasUser#getEmail()
     */
    @Override
    public String getEmail() {
        fireOnPreRead("email", email);
        String result = this.email;
        fireOnPostRead("email", email);
        return result;
    }

    /* (non-Javadoc)
     * @see TaasUser#setEnabled(boolean)
     */
    @Override
    public void setEnabled(boolean value) {
        boolean _oldValue = this.enabled;
        fireOnPreWrite("enabled", _oldValue, value);
        this.enabled = value;
        fireOnPostWrite("enabled", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TaasUser#getEnabled()
     */
    @Override
    public boolean getEnabled() {
        fireOnPreRead("enabled", enabled);
        boolean result = this.enabled;
        fireOnPostRead("enabled", enabled);
        return result;
    }

    /* (non-Javadoc)
     * @see TaasUser#setLastConnectionDate(Date)
     */
    @Override
    public void setLastConnectionDate(Date value) {
        Date _oldValue = this.lastConnectionDate;
        fireOnPreWrite("lastConnectionDate", _oldValue, value);
        this.lastConnectionDate = value;
        fireOnPostWrite("lastConnectionDate", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TaasUser#getLastConnectionDate()
     */
    @Override
    public Date getLastConnectionDate() {
        fireOnPreRead("lastConnectionDate", lastConnectionDate);
        Date result = this.lastConnectionDate;
        fireOnPostRead("lastConnectionDate", lastConnectionDate);
        return result;
    }

    /* (non-Javadoc)
     * @see TaasUser#setNumberOfConnection(int)
     */
    @Override
    public void setNumberOfConnection(int value) {
        int _oldValue = this.numberOfConnection;
        fireOnPreWrite("numberOfConnection", _oldValue, value);
        this.numberOfConnection = value;
        fireOnPostWrite("numberOfConnection", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TaasUser#getNumberOfConnection()
     */
    @Override
    public int getNumberOfConnection() {
        fireOnPreRead("numberOfConnection", numberOfConnection);
        int result = this.numberOfConnection;
        fireOnPostRead("numberOfConnection", numberOfConnection);
        return result;
    }

    /* (non-Javadoc)
     * @see TaasUser#setLink(String)
     */
    @Override
    public void setLink(String value) {
        String _oldValue = this.link;
        fireOnPreWrite("link", _oldValue, value);
        this.link = value;
        fireOnPostWrite("link", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see TaasUser#getLink()
     */
    @Override
    public String getLink() {
        fireOnPreRead("link", link);
        String result = this.link;
        fireOnPostRead("link", link);
        return result;
    }

    /* (non-Javadoc)
     * @see TaasUser#addPrincipals(TaasPrincipal)
     */
    @Override
    public void addPrincipals(TaasPrincipal principals) {
        fireOnPreWrite("principals", null, principals);
        if (this.principals == null) {
            this.principals = new ArrayList<TaasPrincipal>();
        }
        this.principals.add(principals);
        fireOnPostWrite("principals", this.principals.size(), null, principals);
    }

    /* (non-Javadoc)
     * @see TaasUser#addAllPrincipals(Collection<TaasPrincipal>)
     */
    @Override
    public void addAllPrincipals(Collection<TaasPrincipal> values) {
        if (values == null) {
            return;
        }
        for (TaasPrincipal item : values) {
            addPrincipals(item);
        }
    }

    /* (non-Javadoc)
     * @see TaasUser#getPrincipalsByTopiaId(String)
     */
    @Override
    public TaasPrincipal getPrincipalsByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(principals, topiaId);
    }
 
    /* (non-Javadoc)
     * @see TaasUser#setPrincipals(Collection<TaasPrincipal>)
     */
    @Override
    public void setPrincipals(Collection<TaasPrincipal> values) {
        Collection<TaasPrincipal> _oldValue = principals;
        fireOnPreWrite("principals", _oldValue, values);
        principals = values;
        fireOnPostWrite("principals", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see TaasUser#removePrincipals(TaasPrincipal)
     */
    @Override
    public void removePrincipals(TaasPrincipal value) {
        fireOnPreWrite("principals", value, null);
        if ((this.principals == null) || (!this.principals.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite("principals", this.principals.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see TaasUser#clearPrincipals()
     */
    @Override
    public void clearPrincipals() {
        if (this.principals == null) {
            return;
        }
        Collection<TaasPrincipal> _oldValue = new ArrayList<TaasPrincipal>(this.principals);
        fireOnPreWrite("principals", _oldValue, this.principals);
        this.principals.clear();
        fireOnPostWrite("principals", _oldValue, this.principals);
    }

    /* (non-Javadoc)
     * @see TaasUser#getPrincipals()
     */
    @Override
    public Collection<TaasPrincipal> getPrincipals() {
        return principals;
    }

    /* (non-Javadoc)
     * @see TaasUser#sizePrincipals()
     */
    @Override
    public int sizePrincipals() {
        if (principals == null) {
            return 0;
        }
        return principals.size();
    }

    /* (non-Javadoc)
     * @see TaasUser#isPrincipalsEmpty()
     */
    @Override
    public boolean isPrincipalsEmpty() {
        int size = sizePrincipals();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("login", this.login).
            append("password", this.password).
            append("email", this.email).
            append("enabled", this.enabled).
            append("lastConnectionDate", this.lastConnectionDate).
            append("numberOfConnection", this.numberOfConnection).
            append("link", this.link).
            append("principals", this.principals).
         toString();
        return result;
    }
        
} //TaasUserAbstract
