/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.cfg.Configuration;
import org.nuiton.topia.migration.AbstractTopiaMigrationCallback;
import org.nuiton.topia.migration.MigrationServiceException;
import org.nuiton.topia.migration.TopiaMigrationService;
import org.nuiton.topia.migration.mappings.TMSVersion;
import org.nuiton.topia.migration.mappings.TMSVersionHibernateDao;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaConfiguration;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaMigrationServiceException;
import org.nuiton.topia.persistence.internal.AbstractTopiaApplicationContext;
import org.nuiton.topia.persistence.internal.HibernateProvider;
import org.nuiton.topia.persistence.util.TopiaUtil;
import org.nuiton.version.Version;
import org.nuiton.version.VersionBuilder;
import org.nuiton.version.VersionComparator;

public class TopiaMigrationEngine
implements TopiaMigrationService {
    private static final Log log = LogFactory.getLog(TopiaMigrationEngine.class);
    protected Configuration versionConfiguration;
    protected boolean versionTableExist;
    protected Version dbVersion;
    protected boolean dbNotVersioned;
    protected boolean dbEmpty;
    protected AbstractTopiaMigrationCallback callback;
    protected TopiaApplicationContext applicationContext;
    protected boolean init;
    protected boolean versionDetected;
    protected boolean showSql;
    protected boolean showProgression;
    protected SessionFactory sessionFactory;
    protected Metadata metaData;

    public void initTopiaService(TopiaApplicationContext topiaApplicationContext, Map<String, String> serviceConfiguration) {
        Properties config = new Properties();
        config.putAll(serviceConfiguration);
        Preconditions.checkState((boolean)StringUtils.isBlank((CharSequence)config.getProperty("migrateOnInit")), (Object)"migrateOnInit directive is deprecated, you must replace it by setting TopiaConfiguration#isInitSchema to true");
        this.showSql = Boolean.valueOf(config.getProperty("showSql", String.valueOf(Boolean.FALSE)));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Show sql                - " + this.showSql));
        }
        this.showProgression = Boolean.valueOf(config.getProperty("showProgression", String.valueOf(Boolean.FALSE)));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Show progression        - " + this.showProgression));
        }
        String callbackStr = this.getSafeParameter(config, "callback");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Use callback            - " + callbackStr));
        }
        try {
            Class<?> clazz = Class.forName(callbackStr);
            this.callback = (AbstractTopiaMigrationCallback)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new TopiaException("Unable to find callback class " + callbackStr, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new TopiaException("Unable to instantiate callback " + callbackStr, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TopiaException("Unable to instantiate callback " + callbackStr, (Throwable)e);
        }
        this.applicationContext = topiaApplicationContext;
        this.versionConfiguration = TopiaMigrationEngine.createTMSHibernateConfiguration(topiaApplicationContext);
        this.versionConfiguration.getProperties().remove("hibernate.hbm2ddl.auto");
        HibernateProvider hibernateProvider = ((AbstractTopiaApplicationContext)this.applicationContext).getHibernateProvider();
        this.sessionFactory = hibernateProvider.newSessionFactory(this.versionConfiguration);
        this.metaData = hibernateProvider.newMetaData(this.versionConfiguration, this.sessionFactory, Collections.singleton(TMSVersion.class));
        if (this.applicationContext.getConfiguration().isInitSchema() && TopiaUtil.isSchemaEmpty((Configuration)this.versionConfiguration, (Metadata)this.metaData)) {
            TMSVersionHibernateDao.createTMSSchema(this.metaData);
        }
        this.init = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service [" + this.getClass().getName() + "] initialized."));
        }
    }

    @Override
    @Deprecated
    public boolean migrateSchema() throws MigrationServiceException {
        try {
            this.runSchemaMigration();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Unable to complete schema migration", (Throwable)eee);
            }
            throw new MigrationServiceException("Unable to complete schema migration", eee);
        }
        return true;
    }

    public String getSchemaVersion() throws TopiaMigrationServiceException {
        this.checkInit();
        this.detectDbVersion();
        return this.dbVersion.getVersion();
    }

    public void initOnCreateSchema() {
        this.saveApplicationVersion();
    }

    public static List<Version> filterVersions(Set<Version> versions, Version min, Version max, boolean includeMin, boolean includeMax) {
        ArrayList<Version> toApply = new ArrayList<Version>();
        for (Version v : versions) {
            int t;
            if (min != null && ((t = v.compareTo(min)) < 0 || t == 0 && !includeMin) || max != null && ((t = v.compareTo(max)) > 0 || t == 0 && !includeMax)) continue;
            toApply.add(v);
        }
        return toApply;
    }

    public void runSchemaMigration() {
        this.checkInit();
        this.detectDbVersion();
        Version applicationVersion = this.getApplicationVersion();
        log.info((Object)String.format("Starting Topia Migration Service  - Application version : %1$s, Database version : %2$s", applicationVersion.getVersion(), this.dbVersion.getVersion()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Migrate schema to version = " + this.dbVersion));
            log.debug((Object)("is db not versionned ?    = " + this.dbNotVersioned));
            log.debug((Object)("is db empty ?             = " + this.dbEmpty));
            log.debug((Object)("TMSVersion exists         = " + this.versionTableExist));
        }
        if (this.dbEmpty) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"strange case, should never occur");
            }
            return;
        }
        if (this.versionTableExist && this.dbVersion.equals((Object)applicationVersion)) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Database is up to date, no migration needed.");
            }
            return;
        }
        if (this.versionTableExist && this.dbNotVersioned) {
            log.info((Object)"Database is empty, no migration needed.");
            this.saveApplicationVersion();
            return;
        }
        TreeSet<Version> allVersions = new TreeSet<Version>((Comparator<Version>)new VersionComparator());
        allVersions.addAll(Arrays.asList(this.callback.getAvailableVersions()));
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Available versions: %1$s", allVersions));
        }
        boolean migrationDone = false;
        if (this.dbVersion.before(applicationVersion)) {
            List<Version> versionsToApply = TopiaMigrationEngine.filterVersions(allVersions, this.dbVersion, applicationVersion, false, true);
            if (versionsToApply.isEmpty()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"No version to apply, no migration needed.");
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Versions to apply: %1$s", versionsToApply));
                }
                migrationDone = this.callback.doMigration(this.versionConfiguration, this.dbVersion, this.showSql, this.showProgression, versionsToApply);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Handler choose : " + migrationDone));
                }
                if (!migrationDone) {
                    return;
                }
            }
        }
        if (!this.versionTableExist || migrationDone) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set application version in database to " + applicationVersion));
            }
            this.saveApplicationVersion();
        }
    }

    protected void saveApplicationVersion() {
        this.checkInit();
        final Version version = this.getApplicationVersion();
        this.detectDbVersion();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save version     = " + version));
            log.debug((Object)("Table exists     = " + this.versionTableExist));
            log.debug((Object)("Detected version = " + this.dbVersion));
        }
        TopiaUtil.runInSession((Configuration)this.versionConfiguration, (Function)new Function<Session, TMSVersion>(){

            public TMSVersion apply(Session input) {
                TMSVersionHibernateDao.deleteAll(input);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Saving new database version: %1$s", version));
                }
                TMSVersion tmsVersion = TMSVersionHibernateDao.saveVersion(input, version.getVersion());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created version: " + tmsVersion.getVersion()));
                }
                return tmsVersion;
            }
        });
        this.versionTableExist = true;
        this.dbVersion = version;
    }

    protected Version getApplicationVersion() {
        String modelVersion = this.applicationContext.getModelVersion();
        Version result = VersionBuilder.create((String)modelVersion).build();
        return result;
    }

    protected void detectDbVersion() {
        Version v;
        block10: {
            block9: {
                if (this.versionDetected) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Version already detected : " + this.dbVersion));
                    }
                    return;
                }
                this.dbEmpty = this.detectDbEmpty();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Is DB empty ? " + this.dbEmpty));
                }
                v = null;
                try {
                    this.versionTableExist = TopiaUtil.isSchemaExist((Configuration)this.versionConfiguration, (Metadata)this.metaData, (String)TMSVersion.class.getName());
                    Preconditions.checkState((boolean)this.versionTableExist, (Object)"TMSVersion table should have be created during init");
                    TMSVersion tmsVersion = (TMSVersion)TopiaUtil.runInSession((Configuration)this.versionConfiguration, (Function)new Function<Session, TMSVersion>(){

                        public TMSVersion apply(Session object) {
                            TMSVersion tmsVersion = TMSVersionHibernateDao.readVersion(object);
                            return tmsVersion;
                        }
                    });
                    if (tmsVersion != null) {
                        v = tmsVersion.toVersion();
                    }
                    if (log.isWarnEnabled() && v == null) {
                        log.warn((Object)"Version not found on table tms_version");
                    }
                    if (v != null) break block9;
                    v = Version.VZERO;
                    this.dbNotVersioned = true;
                }
                catch (Throwable throwable) {
                    if (v == null) {
                        v = Version.VZERO;
                        this.dbNotVersioned = true;
                        log.info((Object)"Database version not found, so database schema is considered as V0");
                    } else {
                        log.info((Object)String.format("detected database version: %1$s", v));
                    }
                    this.dbVersion = v;
                    this.versionDetected = true;
                    throw throwable;
                }
                log.info((Object)"Database version not found, so database schema is considered as V0");
                break block10;
            }
            log.info((Object)String.format("detected database version: %1$s", v));
        }
        this.dbVersion = v;
        this.versionDetected = true;
    }

    protected boolean detectDbEmpty() {
        HibernateProvider hibernateProvider = ((AbstractTopiaApplicationContext)this.applicationContext).getHibernateProvider();
        Configuration applicationHibernateConfiguration = hibernateProvider.newHibernateConfiguration();
        applicationHibernateConfiguration.getProperties().remove("hibernate.hbm2ddl.auto");
        boolean result = TopiaUtil.isSchemaEmpty((Configuration)applicationHibernateConfiguration, (Metadata)this.metaData);
        return result;
    }

    protected String getSafeParameter(Properties config, String key) {
        String value = config.getProperty(key, null);
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)value), (Object)("'" + key + "' not set."));
        return value;
    }

    protected void checkInit() {
        Preconditions.checkState((boolean)this.init, (Object)"Service is not yet initialized!");
    }

    protected static Configuration createTMSHibernateConfiguration(TopiaApplicationContext appContext) {
        TopiaConfiguration topiaConfiguration = appContext.getConfiguration();
        Properties prop = new Properties();
        prop.put("hibernate.connection.url", topiaConfiguration.getJdbcConnectionUrl());
        prop.put("hibernate.connection.username", topiaConfiguration.getJdbcConnectionUser());
        prop.put("hibernate.connection.password", topiaConfiguration.getJdbcConnectionPassword());
        prop.put("hibernate.connection.driver_class", topiaConfiguration.getJdbcDriverClass().getName());
        prop.put("hibernate.dialect", HibernateProvider.getHibernateDialect((TopiaConfiguration)topiaConfiguration));
        prop.putAll((Map<?, ?>)topiaConfiguration.getHibernateExtraConfiguration());
        Configuration result = new Configuration();
        result.setProperties(prop);
        result.addClass(TMSVersion.class);
        return result;
    }

    public void close() {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
        }
    }
}

