/*
 * #%L
 * ToPIA :: Service Migration
 * 
 * $Id: MapHelper.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.3/topia-service-migration/src/main/java/org/nuiton/topia/migration/transformation/MapHelper.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.migration.transformation;

import java.io.Serializable;
import java.util.Collection;

import org.nuiton.topia.migration.common.MapAdapter;
import org.nuiton.topia.migration.common.ProxyClass;
import org.nuiton.topia.migration.kernel.ObjectNotFound;

/**
 * MapHelper.java
 * 
 * Permet d'acceder aux autres tuples, de l'etape de migration courante
 *
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon Sébastien
 * @author Trève Vincent
 * @version $Revision: 1894 $
 *
 * Last update : $Date: 2010-04-15 17:44:51 +0200 (jeu., 15 avril 2010) $
 */
public interface MapHelper {

    /**
     * Retourne un tuple d'une table des nouvelles bases
     * @param clazz un proxy classe
     * @param id l'id de l'objet
     * @return le tuple
     * @throws ObjectNotFound
     */
    MapAdapter getNewMap(ProxyClass clazz, Serializable id) throws ObjectNotFound;

    /**
     * Retourne un tuple d'une table des nouvelles bases
     * @param clazz le nom qualifié de la classe
     * @param id l'id de l'objet
     * @return le tuple
     */
    MapAdapter getNewMap(String clazz, Serializable id) throws ObjectNotFound;

    /**
     * Retourne un tuple d'une table des annciennes bases
     * @param clazz un proxy classe
     * @param id l'id de l'objet
     * @return le tuple
     * @throws ObjectNotFound si objet non trouve
     */
    MapAdapter getOldMap(ProxyClass clazz, Serializable id) throws ObjectNotFound;

    /**
     * Retourne un tuple d'une table des anciennes bases
     * @param clazz le nom qualifié de la classe
     * @param id l'id de l'objet
     * @return le tuple
     * @throws ObjectNotFound si objet non trouve
     */
    MapAdapter getOldMap(String clazz, Serializable id) throws ObjectNotFound;

    /**
     * Retourne les tuples d'une table des anciennes bases
     * @param clazz le nom qualifié de la classe
     * @return les tuples
     */
    Collection<MapAdapter> getOldMaps(String clazz);

    /**
     * Retourne les tuples d'une table des anciennes bases
     * @param clazz un proxy classe
     * @return les tuples
     */
    Collection<MapAdapter> getOldMaps(ProxyClass clazz);

    /**
     * Retourne les tuples d'une table des nouvelles bases
     * @param clazz le nom qualifié de la classe
     * @return les tuples
     */
    Collection<MapAdapter> getNewMaps(String clazz);

    /**
     * Retourne les tuples d'une table des nouvelles bases
     * @param clazz un proxy classe
     * @return les tuples
     */
    Collection<MapAdapter> getNewMaps(ProxyClass clazz);
}
