/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaDatabase;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.persistence.DepthEntityVisitor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.ExportXMLVisitor;
import org.nuiton.topiatest.Address;
import org.nuiton.topiatest.AddressDAO;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.CompanyDAO;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.DepartmentDAO;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.EmployeDAO;

public class EntityVisitorExportXmlTest {
    private static final Log log = LogFactory.getLog(EntityVisitorExportXmlTest.class);
    @Rule
    public final TopiaDatabase db = new TopiaDatabase();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws TopiaException {
        TopiaContext newContext = this.db.beginTransaction();
        try {
            CompanyDAO companyDAO = TopiaTestDAOHelper.getCompanyDAO(newContext);
            Company clCompany = (Company)companyDAO.create(new Object[]{"name", "CodeLutin"});
            EmployeDAO employeDAO = TopiaTestDAOHelper.getEmployeDAO(newContext);
            Employe empl1 = (Employe)employeDAO.create(new Object[]{"name", "boss", "salary", 30000});
            AddressDAO adressDAO = TopiaTestDAOHelper.getAddressDAO(newContext);
            Address addr1 = (Address)adressDAO.create(new Object[]{"city", "Nantes", "adress", "12 Avenue Jules Vernes"});
            empl1.setAddress(addr1);
            Employe empl2 = (Employe)employeDAO.create(new Object[]{"name", "boss2", "salary", 29000});
            Address addr2 = (Address)adressDAO.create(new Object[]{"city", "Nantes", "adress", "12 Avenue Jules Vernes"});
            empl2.setAddress(addr2);
            DepartmentDAO departmentDAO = TopiaTestDAOHelper.getDepartmentDAO(newContext);
            Department depComm = (Department)departmentDAO.create(new Object[]{"name", "Commercial"});
            depComm.setLeader(empl1);
            Department depDev = (Department)departmentDAO.create(new Object[]{"name", "Dev"});
            depDev.setLeader(empl2);
            clCompany.addDepartment(depComm);
            clCompany.addDepartment(depDev);
            newContext.commitTransaction();
        }
        finally {
            newContext.closeContext();
        }
    }

    @Test
    public void testExportXMLDepth() throws TopiaException {
        TopiaContext context = this.db.beginTransaction();
        CompanyDAO companyDAO = TopiaTestDAOHelper.getCompanyDAO(context);
        Object clCompany = companyDAO.findByName("CodeLutin");
        ExportXMLVisitor delegateVisitor = new ExportXMLVisitor();
        DepthEntityVisitor visitor = new DepthEntityVisitor((EntityVisitor)delegateVisitor);
        clCompany.accept((EntityVisitor)visitor);
        if (log.isInfoEnabled()) {
            log.info((Object)("Export XML = \n" + ((Object)delegateVisitor).toString()));
        }
    }
}

