/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.beans.Introspector;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public class EntityTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(EntityTransformer.class);
    protected ObjectModelInterface outputInterface;
    protected ObjectModelClass outputAbstract;
    protected ObjectModelClass outputImpl;

    protected void clean() {
        this.outputInterface = null;
        this.outputAbstract = null;
        this.outputImpl = null;
    }

    public void transformFromClass(ObjectModelClass input) {
        String prefix;
        if (!input.hasStereotype("entity")) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("for entity : " + input.getQualifiedName()));
            log.info((Object)("Will use classLoader " + this.getClassLoader()));
        }
        if (StringUtils.isEmpty((String)(prefix = this.getConstantPrefix((ObjectModelClassifier)input, ""))) && log.isWarnEnabled()) {
            log.warn((Object)("[" + input.getName() + "] Will generate constants with NO prefix, not a good idea..."));
        }
        this.setConstantPrefix(prefix);
        String clazzName = input.getName();
        String packageName = input.getPackageName();
        Collection attributes = input.getAttributes();
        Collection operations = input.getOperations();
        this.outputInterface = this.createInterface(clazzName, packageName);
        this.outputAbstract = this.createAbstractClass(clazzName + "Abstract", packageName);
        this.generateInterface(input, this.outputInterface, attributes, operations);
        this.generateAbstract(input, this.outputAbstract, attributes, operations);
        boolean generateImpl = this.isGenerateImpl(input, operations);
        if (generateImpl) {
            String implName = clazzName + "Impl";
            if (this.isVerbose()) {
                log.info((Object)("Will generate [" + implName + "]"));
            }
            this.outputImpl = this.isAbstract(input) ? this.createAbstractClass(implName, packageName) : this.createClass(implName, packageName);
            this.generateImpl(input, this.outputImpl);
        }
        this.clean();
    }

    protected boolean isGenerateImpl(ObjectModelClass input, Collection<ObjectModelOperation> operations) {
        String fqn = input.getQualifiedName() + "Impl";
        URL fileLocation = this.getFileInClassPath(fqn);
        if (fileLocation != null) {
            if (this.isVerbose()) {
                log.info((Object)("Will not generate [" + fqn + "], found existing file in class-path : " + fileLocation));
            }
            return false;
        }
        if (!operations.isEmpty()) {
            if (this.isVerbose()) {
                log.info((Object)("Will not generate [" + fqn + "], there is some operations and not only DAO ones"));
            }
            return false;
        }
        for (ObjectModelOperation otherOp : input.getAllOtherOperations(false)) {
            if (!otherOp.isAbstract()) continue;
            if (this.isVerbose()) {
                log.info((Object)("Will not generate [" + fqn + "], there is a abstract operation [" + otherOp.getName() + "] in allOtherOperations."));
            }
            return false;
        }
        return true;
    }

    protected void generateInterface(ObjectModelClass input, ObjectModelInterface output, Collection<ObjectModelAttribute> attributes, Collection<ObjectModelOperation> operations) {
        this.addImport((ObjectModelClassifier)output, TopiaEntity.class);
        Set constants = this.addConstantsFromDependency((ObjectModelClassifier)input, (ObjectModelClassifier)output);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add constants from dependency : " + constants));
        }
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)input)) {
            this.setDocumentation((ObjectModelElement)output, input.getDocumentation());
        }
        for (ObjectModelInterface parent : input.getInterfaces()) {
            this.addInterface((ObjectModelClassifier)output, parent.getQualifiedName());
        }
        boolean needTopiaEntity = true;
        for (ObjectModelClass parent : input.getSuperclasses()) {
            if (!parent.hasStereotype("entity")) continue;
            this.addInterface((ObjectModelClassifier)output, parent.getQualifiedName());
            needTopiaEntity = false;
            break;
        }
        if (needTopiaEntity) {
            this.addInterface((ObjectModelClassifier)output, TopiaEntity.class);
        }
        this.generateInterfaceStaticColumnNames(input, output);
        for (ObjectModelAttribute attr : attributes) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model)) continue;
            if (attr.hasAssociationClass()) {
                this.addInterfaceAssociationAttribute(output, attr);
                continue;
            }
            this.addInterfaceNoneAssociationAttribute(output, attr);
        }
        if (input instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)input;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                String type = attr.getType();
                String name = attr.getName();
                this.generateInterfaceAssociationAccessors(output, name, type);
                if (attr.getReverseAttribute() != null) continue;
                type = ((ObjectModelClassifier)attr.getDeclaringElement()).getQualifiedName();
                name = attr.getDeclaringElement().getName();
                this.generateInterfaceAssociationAccessors(output, name, type);
            }
        }
        for (ObjectModelOperation operation : operations) {
            this.generateInterfaceOperation(operation, output);
        }
    }

    protected void generateAbstract(ObjectModelClass input, ObjectModelClass output, Collection<ObjectModelAttribute> attributes, Collection<ObjectModelOperation> operations) {
        String i18nPrefix;
        String attrName;
        String svUID;
        String clazzName = input.getName();
        String clazzFQN = TopiaGeneratorUtil.getSimpleName((String)input.getQualifiedName());
        this.addInterface((ObjectModelClassifier)output, clazzName);
        this.addImport((ObjectModelClassifier)output, ArrayList.class);
        this.addImport((ObjectModelClassifier)output, List.class);
        this.addImport((ObjectModelClassifier)output, TopiaEntity.class);
        this.addImport((ObjectModelClassifier)output, TopiaContextImplementor.class);
        StringBuilder doc = new StringBuilder();
        doc.append("Implantation POJO pour l'entit\u00e9 {@link ");
        doc.append(StringUtils.capitalize((String)clazzFQN));
        doc.append("}\n");
        String dbName = input.getTagValue("dbName");
        if (dbName != null) {
            doc.append("<p>Nom de l'entit\u00e9 en BD : ");
            doc.append(dbName);
            doc.append(".</p>");
        }
        this.setDocumentation((ObjectModelElement)output, doc.toString());
        for (ObjectModelClass parent : input.getSuperclasses()) {
            String extendClass = parent.getQualifiedName();
            boolean abstractParent = TopiaGeneratorUtil.shouldBeAbstract(parent);
            if (parent.hasStereotype("entity")) {
                extendClass = abstractParent ? extendClass + "Abstract" : extendClass + "Impl";
            }
            this.setSuperClass(output, extendClass);
        }
        if (output.getSuperclasses().isEmpty()) {
            this.setSuperClass(output, TopiaEntityAbstract.class);
        }
        if ((svUID = TopiaGeneratorUtil.findTagValue((String)"serialVersionUID", (ObjectModelElement)input, (Model)this.model)) != null) {
            this.addConstant((ObjectModelClassifier)output, "serialVersionUID", Long.TYPE, svUID, ObjectModelModifier.PRIVATE);
        }
        for (ObjectModelAttribute attr : attributes) {
            String type;
            String name;
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model) && !attr.hasAssociationClass()) continue;
            if (!attr.hasAssociationClass()) {
                name = attrName = attr.getName();
                type = attr.getType();
            } else {
                String assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
                name = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
                type = attr.getAssociationClass().getQualifiedName();
            }
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                String collectionType = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
                type = collectionType + '<' + type + '>';
            }
            String attrVisibility = attr.getVisibility();
            ObjectModelAttribute attr2 = this.addAttribute((ObjectModelClassifier)output, name, type, null, new ObjectModelModifier[]{ObjectModelModifier.toValue((String)attrVisibility), ObjectModelModifier.PROTECTED});
            doc = new StringBuilder();
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr) || attr.hasTagValue("dbName")) {
                if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                    String attrDocumentation = attr.getDocumentation();
                    doc.append(attrDocumentation).append('\n');
                }
                if (attr.hasTagValue("dbName")) {
                    String dbName2 = attr.getTagValue("dbName");
                    doc.append("Nom de l'attribut en BD : ");
                    doc.append(dbName2);
                    doc.append('\n');
                }
            }
            this.setDocumentation((ObjectModelElement)attr2, doc.toString());
            if (!attr.hasTagValue("annotation")) continue;
            String annotation = attr.getTagValue("annotation");
            this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)attr2, annotation);
        }
        if (input instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)input;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                String attrVisibility = attr.getVisibility();
                String attrType = attr.getType();
                attrName = attr.getName();
                this.addAttribute((ObjectModelClassifier)output, GeneratorUtil.toLowerCaseFirstLetter((String)attrName), attrType, null, new ObjectModelModifier[]{ObjectModelModifier.toValue((String)attrVisibility)});
            }
        }
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "update", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.setDocumentation((ObjectModelElement)op, "@deprecated since 2.3.4, use the DAO api instead.");
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Deprecated.class.getSimpleName());
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class.getSimpleName());
        this.setOperationBody(op, "\n        ((TopiaContextImplementor)getTopiaContext()).getDAO(" + clazzName + ".class).update(this);\n" + "");
        op = this.addOperation((ObjectModelClassifier)output, "delete", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.setDocumentation((ObjectModelElement)op, "@deprecated since 2.3.4, use the DAO api instead.");
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Deprecated.class.getSimpleName());
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class.getSimpleName());
        this.setOperationBody(op, "\n        ((TopiaContextImplementor)getTopiaContext()).getDAO(" + clazzName + ".class).delete(this);\n" + "");
        this.generateAcceptMethod(output, input);
        this.generateAggregateMethod(output, input);
        this.generateCompositeMethod(output, input);
        for (ObjectModelAttribute attr : attributes) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model)) continue;
            this.transformAttribute(output, attr, reverse);
        }
        if (input instanceof ObjectModelAssociationClass) {
            for (ObjectModelAttribute attr : ((ObjectModelAssociationClass)input).getParticipantsAttributes()) {
                if (attr == null) continue;
                String attrType = TopiaGeneratorUtil.getSimpleName((String)attr.getType());
                String attrName2 = attr.getName();
                this.generateAssociationAccessors(output, attrName2, attrType);
            }
        }
        this.generateAbstractMethods(output, input);
        boolean doGenerateToString = TopiaGeneratorUtil.generateToString(input, (ObjectModel)this.model);
        if (doGenerateToString) {
            this.addImport((ObjectModelClassifier)output, ToStringBuilder.class);
            this.generateToStringMethod(output, input);
        }
        if (!StringUtils.isEmpty((String)(i18nPrefix = TopiaGeneratorUtil.getI18nPrefix((ObjectModelElement)input, (ObjectModel)this.model)))) {
            this.generateI18n(output, i18nPrefix, input);
        }
    }

    protected void generateImpl(ObjectModelClass input, ObjectModelClass output) {
        this.setDocumentation((ObjectModelElement)output, "Implantation des operations pour l'entit\u00e9 " + input.getName() + ".");
        this.setSuperClass(output, input.getQualifiedName() + "Abstract");
    }

    private void generateInterfaceStaticColumnNames(ObjectModelClass input, ObjectModelInterface output) {
        String attrColName;
        String attrName;
        for (ObjectModelAttribute attr : input.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model) && !attr.hasAssociationClass()) continue;
            if (!attr.hasAssociationClass()) {
                attrName = attr.getName();
            } else {
                String assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
                attrName = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
            }
            attrColName = this.getConstantName(attrName);
            this.addAttribute((ObjectModelClassifier)output, attrColName, String.class, "\"" + attrName + "\"", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        }
        if (input instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)input;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                attrName = attr.getName();
                attrColName = this.getConstantName(attrName);
                this.addAttribute((ObjectModelClassifier)output, attrColName, String.class, "\"" + attrName + "\"", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            }
        }
    }

    protected void addInterfaceNoneAssociationAttribute(ObjectModelInterface output, ObjectModelAttribute attr) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
            ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "set" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)op, attr.getDocumentation());
            }
            ObjectModelParameter attr2 = this.addParameter(op, attrType, GeneratorUtil.toLowerCaseFirstLetter((String)attrName));
            this.setDocumentation((ObjectModelElement)attr2, "La valeur de l'attribut " + attrName + " \u00e0 positionner.");
            this.addSimpleGetterOperation(attr, null);
        } else {
            String collectionInterface = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
            ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "add" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)op, attr.getDocumentation());
            }
            ObjectModelParameter attr2 = this.addParameter(op, attrType, GeneratorUtil.toLowerCaseFirstLetter((String)attrName));
            this.setDocumentation((ObjectModelElement)attr2, "L'instance de " + attrName + " \u00e0 ajouter");
            op = this.addOperation((ObjectModelClassifier)output, "addAll" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)op, attr.getDocumentation());
            }
            attr2 = this.addParameter(op, collectionInterface + "<" + attrType + ">", GeneratorUtil.toLowerCaseFirstLetter((String)attrName));
            this.setDocumentation((ObjectModelElement)attr2, "Les instances de " + attrName + " \u00e0 ajouter");
            op = this.addOperation((ObjectModelClassifier)output, "set" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)op, attr.getDocumentation());
            }
            attr2 = this.addParameter(op, collectionInterface + "<" + attrType + ">", GeneratorUtil.toLowerCaseFirstLetter((String)attrName));
            this.setDocumentation((ObjectModelElement)attr2, "La Collection de " + attrName + " \u00e0 ajouter");
            op = this.addOperation((ObjectModelClassifier)output, "remove" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)op, attr.getDocumentation());
            }
            attr2 = this.addParameter(op, attrType, GeneratorUtil.toLowerCaseFirstLetter((String)attrName));
            this.setDocumentation((ObjectModelElement)attr2, "L'instance de " + attrName + " \u00e0 retirer");
            op = this.addOperation((ObjectModelClassifier)output, "clear" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)op, attr.getDocumentation());
            }
            this.setDocumentation((ObjectModelElement)attr2, "Vide la Collection de " + attrName);
            op = this.addOperation((ObjectModelClassifier)output, "get" + StringUtils.capitalize((String)attrName), collectionInterface + "<" + attrType + ">", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)op, "Retourne la collection.");
            }
            if (!TopiaGeneratorUtil.isPrimitiveType(attr) && !TopiaGeneratorUtil.isDateType(attr)) {
                op = this.addOperation((ObjectModelClassifier)output, "get" + StringUtils.capitalize((String)attrName) + "ByTopiaId", attrType, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
                this.setDocumentation((ObjectModelElement)op, "Recup\u00e8re l'attribut " + attrName + " \u00e0 partir de son topiaId");
                attr2 = this.addParameter(op, String.class, "topiaId");
                this.setDocumentation((ObjectModelElement)attr2, "le topia id de l'entit\u00e9 recherch\u00e9e");
            }
            op = this.addOperation((ObjectModelClassifier)output, "size" + StringUtils.capitalize((String)attrName), Integer.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            this.setDocumentation((ObjectModelElement)op, "Retourne le nombre d'\u00e9l\u00e9ments de la collection " + attrName);
            op = this.addOperation((ObjectModelClassifier)output, "is" + StringUtils.capitalize((String)attrName) + "Empty", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            this.setDocumentation((ObjectModelElement)op, "Retourne {@code true} si la collection " + attrName + " est vide.");
        }
    }

    protected void addInterfaceAssociationAttribute(ObjectModelInterface output, ObjectModelAttribute attr) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        String assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
        String assocClassFQN = attr.getAssociationClass().getQualifiedName();
        String assocClassName = attr.getAssociationClass().getName();
        if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
            ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "set" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            ObjectModelParameter attr2 = this.addParameter(op, assocClassFQN, GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName));
            this.setDocumentation((ObjectModelElement)attr2, "La valeur de l'attribut " + assocClassName + " \u00e0 positionner");
            this.addOperation((ObjectModelClassifier)output, "get" + StringUtils.capitalize((String)assocAttrName), assocClassFQN, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        } else {
            String collectionInterface = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
            ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "add" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            ObjectModelParameter attr2 = this.addParameter(op, assocClassFQN, GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName));
            this.setDocumentation((ObjectModelElement)attr2, "L'instance de " + assocClassName + " \u00e0 ajouter");
            op = this.addOperation((ObjectModelClassifier)output, "addAll" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            attr2 = this.addParameter(op, collectionInterface + "<" + assocClassFQN + ">", GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName));
            this.setDocumentation((ObjectModelElement)attr2, "Les instances de " + assocClassName + " \u00e0 ajouter");
            op = this.addOperation((ObjectModelClassifier)output, "set" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            attr2 = this.addParameter(op, collectionInterface + "<" + assocClassFQN + ">", GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName));
            this.setDocumentation((ObjectModelElement)attr2, "La Collection de " + assocClassName + " \u00e0 ajouter");
            op = this.addOperation((ObjectModelClassifier)output, "remove" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            attr2 = this.addParameter(op, assocClassFQN, GeneratorUtil.toLowerCaseFirstLetter((String)assocClassName));
            this.setDocumentation((ObjectModelElement)attr2, "L'instance de " + assocClassName + " \u00e0 retirer");
            op = this.addOperation((ObjectModelClassifier)output, "clear" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            this.setDocumentation((ObjectModelElement)op, "Vide la Collection de " + assocClassName + " .");
            this.addOperation((ObjectModelClassifier)output, "get" + StringUtils.capitalize((String)assocAttrName), collectionInterface + "<" + assocClassFQN + ">", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            if (!TopiaGeneratorUtil.isPrimitiveType(attr) && !TopiaGeneratorUtil.isDateType(attr)) {
                op = this.addOperation((ObjectModelClassifier)output, "get" + StringUtils.capitalize((String)assocAttrName) + "ByTopiaId", assocClassFQN, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
                this.setDocumentation((ObjectModelElement)op, "Recup\u00e8re l'attribut " + attrName + " \u00e0 partir de son topiaId");
                attr2 = this.addParameter(op, String.class, "topiaId");
                this.setDocumentation((ObjectModelElement)attr2, "le topia id de l'entit\u00e9 recherch\u00e9e");
            }
            op = this.addOperation((ObjectModelClassifier)output, "get" + StringUtils.capitalize((String)assocAttrName), assocClassFQN, new ObjectModelModifier[0]);
            this.addParameter(op, attrType, "value");
            this.addOperation((ObjectModelClassifier)output, "size" + StringUtils.capitalize((String)assocAttrName), Integer.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
            this.addOperation((ObjectModelClassifier)output, "is" + StringUtils.capitalize((String)assocAttrName) + "Empty", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        }
    }

    private void generateInterfaceOperation(ObjectModelOperation op, ObjectModelInterface output) {
        String visibility = op.getVisibility();
        if (op.hasStereotype("dao") || !visibility.equals(ObjectModelModifier.PUBLIC.toString())) {
            return;
        }
        String opName = op.getName();
        String opType = op.getReturnType();
        ObjectModelOperation op2 = this.addOperation((ObjectModelClassifier)output, opName, opType, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)op)) {
            this.setDocumentation((ObjectModelElement)op2, op.getDocumentation());
        }
        for (ObjectModelParameter param : op.getParameters()) {
            String paramName = param.getName();
            String paramType = param.getType();
            ObjectModelParameter param2 = this.addParameter(op2, paramType, paramName);
            if (!TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)param)) continue;
            this.setDocumentation((ObjectModelElement)param2, param.getDocumentation());
        }
        for (String exception : op.getExceptions()) {
            this.addException(op2, exception);
        }
    }

    private void generateInterfaceAssociationAccessors(ObjectModelInterface output, String attrName, String attrType) {
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "set" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        ObjectModelParameter param = this.addParameter(op, attrType, "value");
        this.setDocumentation((ObjectModelElement)param, "La valeur de l'attribut " + attrName + " \u00e0 positionner.");
        op = this.addOperation((ObjectModelClassifier)output, "get" + StringUtils.capitalize((String)attrName), attrType, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        this.setDocumentation((ObjectModelElement)op, "Retourne la valeur de l'attribut " + attrName + ".");
    }

    protected void transformAttribute(ObjectModelClass result, ObjectModelAttribute attr, ObjectModelAttribute reverse) {
        String attrName = attr.getName();
        String attrType = TopiaGeneratorUtil.getSimpleName((String)attr.getType());
        this.addImport((ObjectModelClassifier)result, attrType);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
            if (attr.hasAssociationClass()) {
                String assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
                String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                this.addImport((ObjectModelClassifier)result, assocClassFQN);
                assocClassFQN = TopiaGeneratorUtil.getSimpleName((String)assocClassFQN);
                String name = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
                ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, assocClassFQN, "association");
                this.setOperationBody(op, "\n        " + assocClassFQN + " _oldValue = this." + name + ";\n" + "        fireOnPreWrite(" + this.getConstantName(name) + ", _oldValue, association);\n" + "        this." + name + " = association;\n" + "        fireOnPostWrite(" + this.getConstantName(name) + ", _oldValue, association);\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)assocAttrName), assocClassFQN, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        return " + name + ";\n" + "");
            } else {
                ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, attrType, "value");
                this.setOperationBody(op, "\n        " + attrType + " _oldValue = this." + attrName + ";\n" + "        fireOnPreWrite(" + this.getConstantName(attrName) + ", _oldValue, value);\n" + "        this." + attrName + " = value;\n" + "        fireOnPostWrite(" + this.getConstantName(attrName) + ", _oldValue, value);\n" + "");
            }
        } else {
            String assocClassFQN;
            String assocAttrName;
            ObjectModelOperation op;
            String collectionInterface = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
            String collectionObject = TopiaGeneratorUtil.getNMultiplicityObjectType(attr);
            this.addImport((ObjectModelClassifier)result, collectionInterface);
            this.addImport((ObjectModelClassifier)result, collectionObject);
            collectionInterface = TopiaGeneratorUtil.getSimpleName((String)collectionInterface);
            collectionObject = GeneratorUtil.getSimpleName((String)collectionObject);
            if (!attr.hasAssociationClass()) {
                String reverseAttrName;
                op = this.addOperation((ObjectModelClassifier)result, "add" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, attrType, attrName);
                StringBuilder body = new StringBuilder();
                body.append("\n        fireOnPreWrite(" + this.getConstantName(attrName) + ", null, " + attrName + ");\n" + "        if (this." + attrName + " == null) {\n" + "            this." + attrName + " = new " + collectionObject + "<" + attrType + ">();\n" + "        }\n" + "");
                if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr, (ObjectModel)this.model))) {
                    reverseAttrName = reverse.getName();
                    String reverseAttrType = TopiaGeneratorUtil.getSimpleName((String)reverse.getType());
                    if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                        body.append("        " + attrName + ".set" + StringUtils.capitalize((String)reverseAttrName) + "(this);\n" + "");
                    } else {
                        body.append("        if (" + attrName + ".get" + StringUtils.capitalize((String)reverseAttrName) + "() == null) {\n" + "            " + attrName + ".set" + StringUtils.capitalize((String)reverseAttrName) + "(new " + collectionObject + "<" + reverseAttrType + ">());\n" + "        }\n" + "        " + attrName + ".get" + StringUtils.capitalize((String)reverseAttrName) + "().add(this);\n" + "");
                    }
                }
                body.append("        this." + attrName + ".add(" + attrName + ");\n" + "        fireOnPostWrite(" + this.getConstantName(attrName) + ", this." + attrName + ".size(), null, " + attrName + ");\n" + "");
                this.setOperationBody(op, body.toString());
                op = this.addOperation((ObjectModelClassifier)result, "addAll" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, collectionInterface + '<' + attrType + '>', "values");
                this.setOperationBody(op, "\n        if (values == null) {\n            return;\n        }\n        for (" + attrType + " item : values) {\n" + "            add" + StringUtils.capitalize((String)attrName) + "(item);\n" + "        }\n" + "");
                if (!TopiaGeneratorUtil.isPrimitiveType(attr) && !TopiaGeneratorUtil.isDateType(attr)) {
                    op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)attrName) + "ByTopiaId", attrType, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                    this.addParameter(op, String.class, "topiaId");
                    this.setOperationBody(op, "\n        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(" + attrName + ", topiaId);\n" + " ");
                }
                op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, collectionInterface + '<' + attrType + '>', "values");
                this.setOperationBody(op, "\n        " + collectionInterface + "<" + attrType + "> _oldValue = " + attrName + ";\n" + "        fireOnPreWrite(" + this.getConstantName(attrName) + ", _oldValue, values);\n" + "        " + attrName + " = values;\n" + "        fireOnPostWrite(" + this.getConstantName(attrName) + ", _oldValue, values);\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "remove" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, attrType, "value");
                body = new StringBuilder();
                body.append("\n        fireOnPreWrite(" + this.getConstantName(attrName) + ", value, null);\n" + "        if ((this." + attrName + " == null) || (!this." + attrName + ".remove(value))) {\n" + "            throw new IllegalArgumentException(\"List does not contain given element\");\n" + "        }\n" + "");
                if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr, (ObjectModel)this.model))) {
                    reverseAttrName = reverse.getName();
                    if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                        body.append("        value.set" + StringUtils.capitalize((String)reverseAttrName) + "(null);\n" + "");
                    } else {
                        body.append("        value.get" + StringUtils.capitalize((String)reverseAttrName) + "().remove(this);\n" + "");
                    }
                }
                body.append("        fireOnPostWrite(" + this.getConstantName(attrName) + ", this." + attrName + ".size()+1, value, null);\n" + "");
                this.setOperationBody(op, body.toString());
                op = this.addOperation((ObjectModelClassifier)result, "clear" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                body = new StringBuilder();
                body.append("\n        if (this." + attrName + " == null) {\n" + "            return;\n" + "        }\n" + "");
                if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr, (ObjectModel)this.model))) {
                    reverseAttrName = reverse.getName();
                    body.append("        for (" + attrType + " item : this." + attrName + ") {\n" + "");
                    if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                        body.append("            item.set" + StringUtils.capitalize((String)reverseAttrName) + "(null);\n" + "");
                    } else {
                        body.append("            item.get" + StringUtils.capitalize((String)reverseAttrName) + "().remove(this);\n" + "");
                    }
                    body.append("        }\n");
                }
                body.append("        " + collectionInterface + "<" + attrType + "> _oldValue = new " + collectionObject + "<" + attrType + ">(this." + attrName + ");\n" + "        fireOnPreWrite(" + this.getConstantName(attrName) + ", _oldValue, this." + attrName + ");\n" + "        this." + attrName + ".clear();\n" + "        fireOnPostWrite(" + this.getConstantName(attrName) + ", _oldValue, this." + attrName + ");\n" + "");
                this.setOperationBody(op, body.toString());
            } else {
                String reverseAttrName;
                assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
                assocClassFQN = attr.getAssociationClass().getQualifiedName();
                op = this.addOperation((ObjectModelClassifier)result, "add" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, assocClassFQN, "value");
                StringBuilder body = new StringBuilder();
                body.append("\n        fireOnPreWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", null, value);\n" + "        if (this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " == null) {\n" + "            this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " = new " + collectionObject + "<" + assocClassFQN + ">();\n" + "        }\n" + "");
                if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr, (ObjectModel)this.model))) {
                    reverseAttrName = reverse.getName();
                    body.append("        value.set" + StringUtils.capitalize((String)reverseAttrName) + "(this);\n" + "");
                }
                body.append("        this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ".add(value);\n" + "        fireOnPostWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ".size(), null, value);\n" + "");
                this.setOperationBody(op, body.toString());
                if (!TopiaGeneratorUtil.isPrimitiveType(attr) && !TopiaGeneratorUtil.isDateType(attr)) {
                    op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)assocAttrName) + "ByTopiaId", assocClassFQN, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                    this.addParameter(op, String.class, "topiaId");
                    this.setOperationBody(op, "\n        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(" + assocAttrName + ", topiaId);\n" + "");
                }
                op = this.addOperation((ObjectModelClassifier)result, "addAll" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, collectionInterface + '<' + assocClassFQN + '>', "values");
                this.setOperationBody(op, "\n        if (values == null) {\n            return;\n        }\n        for (" + assocClassFQN + " item : values) {\n" + "            add" + StringUtils.capitalize((String)assocAttrName) + "(item);\n" + "        }\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, collectionInterface + '<' + assocClassFQN + '>', "values");
                this.setOperationBody(op, "\n//        clear" + StringUtils.capitalize((String)assocAttrName) + "();\n" + "//        addAll" + StringUtils.capitalize((String)assocAttrName) + "(values);\n" + "// FIXME\n" + "        " + collectionInterface + "<" + assocClassFQN + "> _oldValue = " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ";\n" + "        fireOnPreWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", _oldValue, values);\n" + "        " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " = values;\n" + "        fireOnPostWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", _oldValue, values);\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "remove" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, assocClassFQN, "value");
                body = new StringBuilder();
                body.append("\n        fireOnPreWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", value, null);\n" + "        if ((this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " == null) || (!this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ".remove(value))) {\n" + "            throw new IllegalArgumentException(\"List does not contain given element\");\n" + "        }\n" + "");
                if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr, (ObjectModel)this.model))) {
                    reverseAttrName = reverse.getName();
                    body.append("        value.set" + StringUtils.capitalize((String)reverseAttrName) + "(null);\n" + "");
                }
                body.append("        fireOnPostWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ".size()+1, value, null);\n" + "");
                this.setOperationBody(op, body.toString());
                op = this.addOperation((ObjectModelClassifier)result, "clear" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                body = new StringBuilder();
                body.append("\n        if (this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " == null) {\n" + "            return;\n" + "        }\n" + "");
                if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attr, (ObjectModel)this.model))) {
                    reverseAttrName = reverse.getName();
                    body.append("        for (" + assocClassFQN + " item : this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ") {\n" + "            item.set" + StringUtils.capitalize((String)reverseAttrName) + "(null);\n" + "        }\n" + "");
                }
                body.append("        " + collectionInterface + "<" + assocClassFQN + "> _oldValue = new " + collectionObject + "<" + assocClassFQN + ">(this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ");\n" + "        fireOnPreWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", _oldValue, null);\n" + "        this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ".clear();\n" + "        fireOnPostWrite(" + this.getConstantName(GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName)) + ", _oldValue, null);\n" + "");
                this.setOperationBody(op, body.toString());
            }
            if (!attr.hasAssociationClass()) {
                op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)attrName), collectionInterface + '<' + attrType + '>', new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        return " + attrName + ";\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "size" + StringUtils.capitalize((String)attrName), Integer.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        if (" + attrName + " == null) {\n" + "            return 0;\n" + "        }\n" + "        return " + attrName + ".size();\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "is" + StringUtils.capitalize((String)attrName) + "Empty", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        int size = size" + StringUtils.capitalize((String)attrName) + "();\n" + "        return size == 0;\n" + "");
            } else {
                assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
                assocClassFQN = attr.getAssociationClass().getQualifiedName();
                op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)assocAttrName), collectionInterface + '<' + assocClassFQN + '>', new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        return " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ";\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)assocAttrName), assocClassFQN, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, attrType, "value");
                this.setOperationBody(op, "\n        if (value == null || " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " == null) {\n" + "            return null;\n" + "        }\n" + "        for (" + assocClassFQN + " item : " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ") {\n" + "            if (value.equals(item.get" + StringUtils.capitalize((String)attrName) + "())) {\n" + "                return item;\n" + "            }\n" + "        }\n" + "        return null;\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "size" + StringUtils.capitalize((String)assocAttrName), Integer.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        if (" + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " == null) {\n" + "            return 0;\n" + "        }\n" + "        return " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ".size();\n" + "");
                op = this.addOperation((ObjectModelClassifier)result, "is" + StringUtils.capitalize((String)assocAttrName) + "Empty", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        int size = size" + StringUtils.capitalize((String)assocAttrName) + "();\n" + "        return size == 0;\n" + "");
            }
        }
    }

    protected void addSimpleGetterOperation(ObjectModelAttribute attribute, String operationPrefix) {
        String attrName = attribute.getName();
        String attrType = attribute.getType();
        if (operationPrefix == null) {
            operationPrefix = "get";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add getter operation for " + attrName + " prefix = " + operationPrefix));
        }
        ObjectModelOperation contract = this.addOperation((ObjectModelClassifier)this.outputInterface, operationPrefix + StringUtils.capitalize((String)attrName), attrType, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attribute)) {
            this.setDocumentation((ObjectModelElement)contract, attribute.getDocumentation());
        }
        ObjectModelOperation impl = this.addOperation((ObjectModelClassifier)this.outputAbstract, contract.getName(), contract.getReturnType(), new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.setOperationBody(impl, "\n        fireOnPreRead(" + this.getConstantName(attrName) + ", " + attrName + ");\n" + "        " + attrType + " result = this." + attrName + ";\n" + "        fireOnPostRead(" + this.getConstantName(attrName) + ", " + attrName + ");\n" + "        return result;\n" + "");
        if (attrType.toLowerCase().contains("boolean") && !operationPrefix.equals("is")) {
            this.addSimpleGetterOperation(attribute, "is");
        }
    }

    protected void generateToStringMethod(ObjectModelClass output, ObjectModelClass clazz) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("generate toString method for clazz " + clazz.getQualifiedName()));
        }
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "toString", String.class, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class.getSimpleName());
        StringBuilder body = new StringBuilder();
        body.append("\n        String result = new ToStringBuilder(this).\n");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelClass attrEntity = null;
            if (((ObjectModel)this.model).hasClass(attr.getType())) {
                attrEntity = ((ObjectModel)this.model).getClass(attr.getType());
            }
            boolean isEntity = attrEntity != null && attrEntity.hasStereotype("entity");
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if ((!isEntity || reverse != null && reverse.isNavigable() || attr.hasAssociationClass()) && isEntity) continue;
            String attrName = attr.getName();
            body.append("            append(" + this.getConstantName(attrName) + ", this." + attrName + ").\n" + "");
        }
        body.append("         toString();\n        return result;\n");
        this.setOperationBody(op, body.length() == 0 ? " " : body.toString());
    }

    protected void generateCompositeMethod(ObjectModelClass output, ObjectModelClass clazz) {
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "getComposite", List.class.getName() + '<' + TopiaEntity.class.getName() + '>', new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class.getSimpleName());
        StringBuilder body = new StringBuilder();
        body.append("\n        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();\n\n        // pour tous les attributs rechecher les composites et les class d'asso\n        // on les ajoute dans tmp\n");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.referenceClassifier() || !attr.getClassifier().hasStereotype("entity")) continue;
            if (attr.isComposite()) {
                String attrName = attr.getName();
                String getterName = "get" + StringUtils.capitalize((String)attrName);
                if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    body.append("        if (" + getterName + "() != null) {\n" + "              tmp.addAll(" + getterName + "());\n" + "           }\n" + "");
                    continue;
                }
                body.append("        tmp.add(" + getterName + "());\n" + "");
                continue;
            }
            if (!attr.hasAssociationClass()) continue;
            String assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            String assocClassFQN = TopiaGeneratorUtil.getSimpleName((String)attr.getAssociationClass().getQualifiedName());
            String ref = "this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                body.append("\n        if (" + ref + " != null) {\n" + "            tmp.add(" + ref + ");\n" + "        }\n" + "");
                continue;
            }
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            String reverseAttrName = reverse.getName();
            body.append("\n        {\n            org.nuiton.topia.persistence.TopiaDAO<" + assocClassFQN + "> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(" + assocClassFQN + ".class);\n" + "            List<" + assocClassFQN + "> findAllByProperties = dao.findAllByProperties(\"" + reverseAttrName + "\", this);\n" + "            if (findAllByProperties != null) {\n" + "                tmp.addAll(findAllByProperties);\n" + "            }\n" + "        }\n" + "");
        }
        body.append("\n        // on refait un tour sur chaque entity de tmp pour recuperer leur\n        // composite\n        List<TopiaEntity> result = new ArrayList<TopiaEntity>();\n        for (TopiaEntity entity : tmp) {\n            if (entity != null) {\n                result.add(entity);\n                result.addAll(entity.getComposite());\n            }\n        }\n\n        return result;\n    ");
        this.setOperationBody(op, body.length() == 0 ? " " : body.toString());
    }

    protected void generateAggregateMethod(ObjectModelClass output, ObjectModelClass clazz) {
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "getAggregate", List.class.getName() + '<' + TopiaEntity.class.getName() + '>', new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class.getSimpleName());
        StringBuilder body = new StringBuilder();
        body.append("\n        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();\n\n        // pour tous les attributs rechecher les composites et les class d'asso\n        // on les ajoute dans tmp\n");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.referenceClassifier() || !attr.getClassifier().hasStereotype("entity") || !attr.isAggregate()) continue;
            String attrName = attr.getName();
            String getterName = "get" + StringUtils.capitalize((String)attrName);
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                body.append("        tmp.addAll(" + getterName + "());\n" + "");
                continue;
            }
            body.append("        tmp.add(" + getterName + "());\n" + "");
        }
        body.append("\n        // on refait un tour sur chaque entity de tmp pour recuperer leur\n        // composite\n        List<TopiaEntity> result = new ArrayList<TopiaEntity>();\n        for (TopiaEntity entity : tmp) {\n            result.add(entity);\n            result.addAll(entity.getAggregate());\n        }\n\n        return result;\n");
        this.setOperationBody(op, body.length() == 0 ? " " : body.toString());
    }

    protected void generateAcceptMethod(ObjectModelClass output, ObjectModelClass clazz) {
        String attrName;
        String attrType;
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "accept", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addException(op, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class.getSimpleName());
        this.setDocumentation((ObjectModelElement)op, "Envoi via les methodes du visitor l'ensemble des champs de l'entity\navec leur nom, type et valeur.");
        ObjectModelParameter attr = this.addParameter(op, EntityVisitor.class, "visitor");
        this.setDocumentation((ObjectModelElement)attr, "le visiteur de l'entite.");
        StringBuilder body = new StringBuilder();
        body.append("\n        visitor.start(this);\n");
        for (ObjectModelAttribute attr2 : clazz.getAttributes()) {
            String collectionType;
            ObjectModelAttribute reverse = attr2.getReverseAttribute();
            if (!attr2.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(reverse, (ObjectModel)this.model) && !attr2.hasAssociationClass()) continue;
            if (!attr2.hasAssociationClass()) {
                attrType = TopiaGeneratorUtil.getSimpleName((String)attr2.getType());
                attrName = attr2.getName();
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr2)) {
                    body.append("        visitor.visit(this, " + this.getConstantName(attrName) + ", " + attrType + ".class, " + attrName + ");\n" + "");
                    continue;
                }
                collectionType = TopiaGeneratorUtil.getSimpleName((String)TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr2));
                body.append("        visitor.visit(this, " + this.getConstantName(attrName) + ", " + collectionType + ".class, " + attrType + ".class, " + attrName + ");\n" + "");
                continue;
            }
            String assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr2);
            assocAttrName = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
            String assocClassFQN = TopiaGeneratorUtil.getSimpleName((String)attr2.getAssociationClass().getQualifiedName());
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr2)) {
                body.append("        visitor.visit(this, " + this.getConstantName(assocAttrName) + ", " + assocClassFQN + ".class, " + assocAttrName + ");\n" + "");
                continue;
            }
            collectionType = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr2);
            body.append("        visitor.visit(this, " + this.getConstantName(assocAttrName) + ", " + collectionType + ".class, " + assocClassFQN + ".class, " + assocAttrName + ");\n" + "");
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr3 : assoc.getParticipantsAttributes()) {
                if (attr3 == null) continue;
                attrType = TopiaGeneratorUtil.getSimpleName((String)attr3.getType());
                attrName = attr3.getName();
                attrName = GeneratorUtil.toLowerCaseFirstLetter((String)attrName);
                body.append("        visitor.visit(this, " + this.getConstantName(attrName) + ", " + attrType + ".class, " + attrName + ");\n" + "");
            }
        }
        body.append("        visitor.end(this);\n");
        this.setOperationBody(op, body.length() == 0 ? " " : body.toString());
    }

    private void generateAssociationAccessors(ObjectModelClass output, String name, String type) {
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "set" + StringUtils.capitalize((String)name), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class.getSimpleName());
        ObjectModelParameter param = this.addParameter(op, type, "value");
        this.setDocumentation((ObjectModelElement)param, "La valeur de l'attribut " + name + " \u00e0 positionner.");
        this.setOperationBody(op, "\n        " + type + " _oldValue = this." + GeneratorUtil.toLowerCaseFirstLetter((String)name) + ";\n" + "        fireOnPreWrite(\"" + name + "\", _oldValue, value);\n" + "        this." + GeneratorUtil.toLowerCaseFirstLetter((String)name) + " = value;\n" + "        fireOnPostWrite(\"" + name + "\", _oldValue, value);\n" + "");
        op = this.addOperation((ObjectModelClassifier)output, "get" + StringUtils.capitalize((String)name), type, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)op, Override.class.getSimpleName());
        this.setOperationBody(op, "\n        return " + GeneratorUtil.toLowerCaseFirstLetter((String)name) + ";\n" + "");
    }

    private void generateAbstractMethods(ObjectModelClass output, ObjectModelClass input) {
        for (ObjectModelOperation op : input.getOperations()) {
            String visibility;
            ObjectModelModifier visibilityModifier;
            if (log.isDebugEnabled()) {
                log.debug((Object)("clazz : " + input.getQualifiedName() + " - method : " + op.getName() + " - visibility : " + op.getVisibility()));
            }
            if ((visibilityModifier = ObjectModelModifier.toValue((String)(visibility = op.getVisibility()))).equals((Object)ObjectModelModifier.PUBLIC)) continue;
            this.addOperation((ObjectModelClassifier)output, op.getName(), op.getReturnType(), new ObjectModelModifier[]{visibilityModifier, ObjectModelModifier.ABSTRACT});
        }
    }

    private void generateI18n(ObjectModelClass result, String i18nPrefix, ObjectModelClass clazz) {
        StringBuilder buffer = new StringBuilder(300);
        this.addI18n(buffer, i18nPrefix, Introspector.decapitalize(clazz.getName()));
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable()) continue;
            this.addI18n(buffer, i18nPrefix, Introspector.decapitalize(attr.getName()));
        }
        ObjectModelOperation op = this.addBlock((ObjectModelClassifier)result, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.setOperationBody(op, buffer.toString());
    }

    private void addI18n(StringBuilder buffer, String i18nPrefix, String suffix) {
        buffer.append("\n    org.nuiton.i18n.I18n.n_(\"");
        buffer.append(i18nPrefix);
        buffer.append(suffix);
        buffer.append("\");");
    }

    protected boolean isAbstract(ObjectModelClass clazz) {
        if (clazz.isAbstract()) {
            return true;
        }
        Collection allInterfaceOperations = clazz.getAllInterfaceOperations(true);
        allInterfaceOperations.removeAll(clazz.getAllOtherOperations(true));
        for (ObjectModelOperation op : allInterfaceOperations) {
            boolean implementationFound = false;
            for (ObjectModelClass superClazz : clazz.getSuperclasses()) {
                ObjectModelOperation matchingOp;
                Iterator i$ = superClazz.getOperations(op.getName()).iterator();
                while (i$.hasNext() && !(implementationFound = op.equals(matchingOp = (ObjectModelOperation)i$.next()) && !matchingOp.isAbstract())) {
                }
                if (!implementationFound) continue;
                break;
            }
            if (implementationFound) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)(clazz.getName() + " : abstract operation " + op));
            }
            return true;
        }
        return false;
    }
}

