/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: DAOImplGenerator.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.3/topia-persistence/src/main/java/org/nuiton/topia/generator/DAOImplGenerator.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */




/* *
* EntityPOJOGenerator.java
*
* Created: 12 déc. 2005
*
* @author Arnaud Thimel <thimel@codelutin.com>
* @version $Revision: 1894 $
*
* Mise a jour: $Date: 2010-04-15 17:44:51 +0200 (jeu., 15 avril 2010) $
* par : $Author: tchemit $
*/

package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;

import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelOperation;
/**
 *
 * @deprecated since 2.3.0, prefer use the corresponding {@link org.nuiton.eugene.Transformer} :
 * {@link DAOImplTransformer}.
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.DAOImplGenerator" 
 */
@Deprecated
public class DAOImplGenerator extends ObjectModelGenerator {

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "DAOImpl.java";
    }

    @Override
    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY) || hasDAOOperations(clazz)) {
            return;
        }
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
output.write(""+copyright+"\n");
output.write("");
        }
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
output.write("package "+clazz.getPackageName()+";\n");
output.write(" \n");
output.write("/**\n");
output.write(" * Implantation du DAO pour l'entité "+clazzName+".\n");
output.write(" * L'utilisateur peut remplacer cette classe par la sienne en la mettant \n");
output.write(" * simplement dans ces sources. Cette classe générée sera alors simplement\n");
output.write(" * écrasée.\n");
output.write(" */\n");
output.write("public class "+clazzName+"DAOImpl<E extends "+clazzName+"> extends "+clazzFQN+"DAOAbstract<E>  {\n");
output.write("\n");
output.write("} //"+clazzName+"DAO\n");
output.write("");
    }

    /**
     * Detect if the class has DAO operations identified with <<dao>> stereotype.
     * @param clazz The ObjectModelClass with operations (Corresponding to the Entity)
     * @return true if the class has some dao operations, false if not
     */
    public static boolean hasDAOOperations(ObjectModelClass clazz) {
        for (ObjectModelOperation op : clazz.getOperations()) {
            if (op.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DAO)) {
                return true;
            }
        }
        return false;
    }

} //DAOGenerator
