package jaxx.runtime.swing.editor.bean;

/*
 * #%L
 * JAXX :: Widgets
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.bean.BeanTypeAware;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.model.JaxxDefaultListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.decorator.JXPathDecorator;
import static org.nuiton.i18n.I18n._;

public class BeanDoubleList<O> extends Table implements BeanTypeAware<O>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_BEAN_TYPE = "beanType";
    public static final String PROPERTY_LABEL_TEXT = "labelText";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_SHOW_RESET = "showReset";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_BUTTON_ENABLED = "addButton.enabled";
    public static final String BINDING_REMOVE_BUTTON_ENABLED = "removeButton.enabled";
    public static final String BINDING_SELECTED_LIST_MODEL = "selectedList.model";
    public static final String BINDING_UNIVERSE_LIST_MODEL = "universeList.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJVUTU8UQRAtVhZcEFGJCIoJIn7FMKvGxANGBZEoWdSwmBj3Yu92hx3SO91O98AQo/En+BP07sXEmyfjwbMHL8a/YIwHr8bqnmF7B8YAe+jMVtfHq9f16t1PKKoQTq2SOPbCKNB+i3kLM48fP6ivsoaeY6oR+lKLEJJfVwEKNeinbbvScLpWMeHlNLx8W7SkCFjQET1dgT6lNzhTTca0hpPZiIZS5Wr7ejqWUbiZtQ0qL+ub378Kr+mrtwWAWCK6QWxlfKco10l3BQo+1XAEK62RMifBCsII/WAF8Q4Y221OlLpPWuwZvITeCvRIEmIyDRO7b9nmsPGx1NA7uUzqnF3SMJUBqtaxrMeoj6FenZHAm8VjTkToXPGVltLm6NGw39wub0imYdBg9Axuz1ZxTiVO6owvsxixHnJeSXcduWQoJAv1hvl/2Nm7TY1MZDIPHQVUU6wvMWVe87BzmxWCY6jzK7YEZVzDlT11u2iCXJLeJgkoR5xwdU9p7iZhLtHA5EK1EQrOH5LAvMExgzxO83RcGfdSO+pAFPhrLFQ2Z9puO8jYjN+4I3VyweTgmP9IxtVas6lLhNLZSGuBbA9lnBOrcTvrgISsJdaYu7qYvc+0d9kYJ7Z0ohjHZ2R0E/UZc3gSdXMiwywq0nOKdJLpqkExjNCsYaS2XcRLeJXId2SLfE1Ce/t3eOjbxx8f5jc1a9bP0VzXjpWDWkon1TelBxPBRtrn5UUip2s4jrYxu4/GcoBV02sEh/WSgTXh3l2impii2Pv90+fhp1/3QWEe+rggdJ4Y/3tQ0s0QWRCcxvLmLYvowPp+PA8ZbG7Ajz+3H94K04/ScbFTfP7Cixj5GMvhow2qXvryZ6j6/tYmJ12IcfS/7o6X4hPo8QPuB8xusnRJ5W6ufqlYRIVbRnnrCbbMukyVc82e09va34fSZIHZZ7hFh1MCfDVD6Z3Eis1r6EMmfRHca5ghHzYynaJWohxLTCUPp6Ff4+pY9mWys0aNm/Py6nbkPVRLHBksNy1L5msGOlW0E+L8B6umqnAPtr1GRjp7Ima0TcySle9/uRnZyk0U5LMzls9Osh1ywXcujl1w1MPJhkBnOHidEk3G635AcSvd2Ja7y5znMOM/BTxR5kkIAAA=";
    private static final Log log = LogFactory.getLog(BeanDoubleList.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addButton;
    protected Object bean;
    protected Class<O> beanType;
    protected BeanDoubleListHandler<O> handler;
    protected String labelText;
    protected BeanDoubleListModel<O> model;
    protected String property;
    protected JButton removeButton;
    protected JList selectedList;
    protected Boolean showReset;
    protected JList universeList;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private BeanDoubleList<O> $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(JXPathDecorator<O> decorator, List<O> universe, List<O> selected) {
        handler.init(decorator, universe, selected);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanDoubleList() {
        $initialize();
    }

    public BeanDoubleList(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.select();
    }

    public void doActionPerformed__on__removeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.unselect();
    }

    public void doFocusGained__on__$JScrollPane0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        universeList.requestFocus();
    }

    public void doFocusGained__on__$JScrollPane1(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        selectedList.requestFocus();
    }

    public void doMouseClicked__on__selectedList(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onSelectedListClicked(event);
    }

    public void doMouseClicked__on__universeList(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onUniverseListClicked(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddButton() {
        return addButton;
    }

    public Object getBean() {
        return bean;
    }

    public Class<O> getBeanType() {
        return beanType;
    }

    public BeanDoubleListHandler<O> getHandler() {
        return handler;
    }

    public String getLabelText() {
        return labelText;
    }

    public BeanDoubleListModel<O> getModel() {
        return model;
    }

    public String getProperty() {
        return property;
    }

    public JButton getRemoveButton() {
        return removeButton;
    }

    public JList getSelectedList() {
        return selectedList;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public JList getUniverseList() {
        return universeList;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Object bean) {
        Object oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setBeanType(Class<O> beanType) {
        Class<O> oldValue = this.beanType;
        this.beanType = beanType;
        firePropertyChange(PROPERTY_BEAN_TYPE, oldValue, beanType);
    }

    public void setLabelText(String labelText) {
        String oldValue = this.labelText;
        this.labelText = labelText;
        firePropertyChange(PROPERTY_LABEL_TEXT, oldValue, labelText);
    }

    public void setProperty(String property) {
        String oldValue = this.property;
        this.property = property;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
    }

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new JButton());
        
        addButton.setName("addButton");
        addButton.setToolTipText(_("beandoublelist.button.add"));
        addButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addButton"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createBeanType() {
        $objectMap.put("beanType", beanType = null);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new BeanDoubleListHandler<O>(this));
    }

    protected void createLabelText() {
        $objectMap.put("labelText", labelText = null);
    }

    protected void createModel() {
        $objectMap.put("model", model = new BeanDoubleListModel<O>());
    }

    protected void createProperty() {
        $objectMap.put("property", property = "");
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new JButton());
        
        removeButton.setName("removeButton");
        removeButton.setToolTipText(_("beandoublelist.button.remove"));
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    protected void createSelectedList() {
        $objectMap.put("selectedList", selectedList = new JList());
        
        selectedList.setName("selectedList");
        selectedList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__selectedList"));
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createUniverseList() {
        $objectMap.put("universeList", universeList = new JList());
        
        universeList.setName("universeList");
        universeList.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__universeList"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($JScrollPane0, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(2, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(universeList);
        // inline complete setup of $JPanel0
        $JPanel0.add(addButton);
        $JPanel0.add(removeButton);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(selectedList);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        addButton.setIcon(SwingUtil.createActionIcon("bean-doublelist-select"));
        removeButton.setIcon(SwingUtil.createActionIcon("bean-doublelist-unselect"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createBeanType();
        createLabelText();
        createProperty();
        createBean();
        createShowReset();
        createModel();
        createHandler();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        $JScrollPane0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$JScrollPane0"));
        createUniverseList();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(0,1));
        createAddButton();
        createRemoveButton();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        $JScrollPane1.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$JScrollPane1"));
        createSelectedList();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_UNIVERSE_LIST_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("universeModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    universeList.setModel(model.getUniverseModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("universeModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("addEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addButton.setEnabled(model.isAddEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("addEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeButton.setEnabled(model.isRemoveEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_LIST_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    selectedList.setModel(model.getSelectedModel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedModel", this);
                }
            }
        });
    }

}