/*
 * #%L
 * JAXX :: Validator
 * 
 * $Id: ValidatorField.java 2178 2011-01-26 14:41:27Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.4.2/jaxx-validator/src/main/java/jaxx/runtime/validator/swing/meta/ValidatorField.java $
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.validator.swing.meta;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation to put on each field or method linked to a validator.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.3
 */
@Target(value = {ElementType.FIELD, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ValidatorField {
    /**
     * Obtain the id of the validator used for the field.
     *
     * @return the id of the validator used for the field.
     */
    String validatorId();

    /**
     * Obtain the name of the bean property to validate.
     *
     * @return the name of the property to validate
     */
    String propertyName();

    /**
     * Obtain the name of the property editor.
     * <p/>
     * If empty, then use the {@link #propertyName()}.
     *
     * @return the name of the property editor
     */
    String editorName() default "";
}
