/*
 * #%L
 * JAXX :: Tutorial Validation
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.validation.ui;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.demo.validation.model.Movie;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Item;
import jaxx.runtime.swing.JAXXComboBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ValidationTableDemo extends JPanel implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_YEAR_TEXT = "year.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL3_TEXT = "$JLabel3.text";
    private static final String BINDING_$JLABEL5_TEXT = "$JLabel5.text";
    private static final String BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW = "$JScrollPane0.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXzW8bRRSfmNqJU9IWTNOUBhKoBUKFNUkatZAoTZrUaiIHaFxCwAcYe0fxlPHOMjsbbzggblz7J8C9FyRunBAHzhy4VPwLCPXQK+LNeD+y8Wa90vqwXs977/d+72PfWz/5BxUdgd54hD3PEK4laY8YOxsHBx+3H5GO3CJOR1BbcoEGn7ECKrTQeTM8dyS63moo85pvXtvkPZtbxDphvdJAk448ZsTpEiIlei1u0XGcWjMUr3i2KwLUkFQS6o/P/i08Nr//qYCQZwO7axDK/CirKJJzDVSgpkQvg6cjXGPYOgQaglqHwHdKnW0y7Dgf4R75Bn2HxhuoZGMBYBK9mT1kjaHtPVuiierOJ9gi7H2JbmimJulx4wgzamJJuWW41NgPfz3EbUa2QMO2NURJomKPH1Ei/ThPW/e4SZixq1Qik3EiBFRqUaLVWHJ8Oy4Mpw9BG0113Q8Od4nj4EOiKewq2AiwHFoGUWSDPEGpqnEhCzMx+4GVlinNcmgQ5G0ByqUq4/mqg1OldDnS7XBLEk9Cb84loKv2hoK1+V3uKYuZISeL6vercVCf8YL6eUVdXj9p1sBtXdM4N32qlOaj8kkqGZRvOqb4ENjWKWFmXDkA1k6rcdm5Y4KFun97yEbHsHR2DIthDO8OuVoMXRlDsqUU2c0U2XKyTNO8mUBzqrrT7AjOmNKApF6J5SoSKfXbodWk7nId4Ok6hP304ZD/5QT/pQ62OoRJVImh3HWl5JbSWQ9VC/xrdbcVPy1VtyXpDZgPtZ8S2adUdYG34VSgazETmIxGNBmj0TXWQkXhwjE8QK3hYboHosEYnTk1RhWglv43Xfnr179/qQezcw58X05UPTH6YabZgttESKpcXxwMTldSVtvF9koLlR3CYG/ovTCbQKzpi4Ec+HtJmRvK3LiPnS5AFMef/vb79Fd/voAKdTTJODbrWOlvo7LsCsgCZ6Zn31nXjF7sT8D1kuIGiWxzYQIxdGEVZg2eb1PLhHSveZCE2YQkhEza5T+eV5o/rweJGANiV89Uj5JR/AKVqMWoRfQa8TdE4to4bzvENXm0CZJ2w5j6vmr7rfFAXz9NjJThY+5KJT/wXPX1uaat7lqZUSaISaX/sKwO4pjHErZf25VkLRl3diSuOv4shdlcJoQvcyHAbFTTX0lJMsb1TCxECou3siOcweGd3Bxu5K7Ge1m6rUvoYTctm6NRRtU0C49iH17VurlppJVkIXdJlnJzWM7N4VbutvggE8IPKVFkQ0hriWwIj3NxkOhShzO3Z90nGFbHPiX9FEYrGfAq2JV8UxAsyR7vN+H9mKQVey0D5AUFuUcc+q1+C8+J9gq817DBLoO/C/cstQDMnJhF/acjJXNZQCoC8hXw2mCM93PzmnICvNyJG9WtG7mf+83cCHVA+B9wDzmczw8AAA==";
    private static final Log log = LogFactory.getLog(ValidationTableDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancel;
    protected JAXXComboBox contexts;
    protected JTable errorTable;
    protected SwingValidatorMessageTableModel errors2;
    protected Movie movie;
    protected JButton ok;
    @ValidatorField( validatorId = "validator",  propertyName = "title",  editorName = "title")
    protected JTextField title;
    @Validator( validatorId = "validator")
    protected SwingValidator<Movie> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    @ValidatorField( validatorId = "validator",  propertyName = "year",  editorName = "year")
    protected JTextField year;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ValidationTableDemo $JPanel0 = this;
    private Table $Table0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private Table $Table1;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JPanel $JPanel3;
    private Table $Table2;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JPanel $JPanel4;
    private JScrollPane $JScrollPane0;
    private JPanel $JPanel5;
    private Item $Item0;
    private Item $Item1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
        SwingValidatorUtil.installUI(errorTable, new SwingValidatorMessageTableRenderer());
    }
    
    protected void changeContext(String context) {
       if (context==null) { return; }
       validator.setContext(context);
       validator.setBean(movie);
       SwingValidatorUtil.installUI(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ValidationTableDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ValidationTableDemo(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidationTableDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ValidationTableDemo(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidationTableDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public ValidationTableDemo(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ValidationTableDemo() {
        $initialize();
    }

    public ValidationTableDemo(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        JOptionPane.showMessageDialog(this, cancel.getText() + " clicked!", "onActionPerformed", JOptionPane.INFORMATION_MESSAGE);
    }

    public void doActionPerformed__on__contexts(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        changeContext(String.valueOf(contexts.getSelectedItem()));
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        JOptionPane.showMessageDialog(this, ok.getText() + " clicked!", "onActionPerformed", JOptionPane.INFORMATION_MESSAGE);
    }

    public void doKeyReleased__on__title(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        movie.setTitle(title.getText());
    }

    public void doKeyReleased__on__year(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        movie.setYear(Integer.valueOf(year.getText()));
    }

    public void doTableChanged__on__errors2(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        ok.setEnabled(errors2.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancel() {
        return cancel;
    }

    public JAXXComboBox getContexts() {
        return contexts;
    }

    public JTable getErrorTable() {
        return errorTable;
    }

    public SwingValidatorMessageTableModel getErrors2() {
        return errors2;
    }

    public Movie getMovie() {
        return movie;
    }

    public JButton getOk() {
        return ok;
    }

    public JTextField getTitle() {
        return title;
    }

    public SwingValidator<Movie> getValidator() {
        return validator;
    }

    public JTextField getYear() {
        return year;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected Item get$Item0() {
        return $Item0;
    }

    protected Item get$Item1() {
        return $Item1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToContexts() {
        if (!allComponentsCreated) {
            return;
        }
        java.util.List<jaxx.runtime.swing.Item> contexts$items = new java.util.ArrayList<jaxx.runtime.swing.Item>();
        contexts$items.add($Item0);
        contexts$items.add($Item1);
        contexts.setItems(contexts$items);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errors2);
        SwingValidatorUtil.registerErrorTableMouseListener(errorTable);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(movie);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createContexts() {
        $objectMap.put("contexts", contexts = new JAXXComboBox());
        
        contexts.setName("contexts");
        contexts.setEditable(false);
        contexts.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__contexts"));
    }

    protected void createErrorTable() {
        $objectMap.put("errorTable", errorTable = new JTable());
        
        errorTable.setName("errorTable");
        errorTable.setAutoCreateRowSorter(true);
        errorTable.setAutoResizeMode(2);
        errorTable.setCellSelectionEnabled(false);
        errorTable.setRowSelectionAllowed(true);
        errorTable.setSelectionMode(0);
    }

    protected void createErrors2() {
        $objectMap.put("errors2", errors2 = new SwingValidatorMessageTableModel());
        
        errors2.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errors2"));
    }

    protected void createMovie() {
        $objectMap.put("movie", movie = new Movie());
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(_("valid"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createTitle() {
        $objectMap.put("title", title = new JTextField());
        
        title.setName("title");
        title.setColumns(15);
        title.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__title"));
        title.putClientProperty("validatorLabel", n_("movie.title"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(Movie.class, "create"));
    }

    protected void createYear() {
        $objectMap.put("year", year = new JTextField());
        
        year.setName("year");
        year.setColumns(15);
        year.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__year"));
        year.putClientProperty("validatorLabel", n_("movie.year"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($Table0);
        addChildrenToValidator();
        // inline complete setup of $Table0
        $Table0.add($JPanel1, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel3, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 3, 0, 0), 0, 0));
        $Table0.add($JPanel4, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel5, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel1
        $JPanel1.add(contexts);
        addChildrenToContexts();
        // inline complete setup of $JPanel2
        $JPanel2.add($Table1);
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(title), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(year), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel3
        $JPanel3.add($Table2);
        // inline complete setup of $Table2
        $Table2.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel3, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel5, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel4
        $JPanel4.add($JScrollPane0);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(errorTable);
        // inline complete setup of $JPanel5
        $JPanel5.add(cancel);
        $JPanel5.add(ok);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        $JPanel1.setBorder(BorderFactory.createTitledBorder("Configuration"));
        $JPanel2.setBorder(BorderFactory.createTitledBorder("Movie"));
        $JPanel3.setBorder(BorderFactory.createTitledBorder("Movie"));
        $JPanel4.setBorder(BorderFactory.createTitledBorder("Messages"));
        errorTable.setModel(errors2);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createMovie();
        createErrors2();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout());
        createContexts();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout());
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("Title :"));
        createTitle();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("Year:"));
        createYear();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        SwingUtil.setComponentHeight($JPanel3,120);
        $JPanel3.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel3,250);
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("Title:"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("Year:"));
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        SwingUtil.setComponentHeight($JPanel4,200);
        $JPanel4.setLayout(new GridLayout());
        SwingUtil.setComponentWidth($JPanel4,500);
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createErrorTable();
        // inline creation of $JPanel5
        $objectMap.put("$JPanel5", $JPanel5 = new JPanel());
        
        $JPanel5.setName("$JPanel5");
        $JPanel5.setLayout(new GridLayout(1,2,0,0));
        createCancel();
        createOk();
        // inline creation of $Item0
        $objectMap.put("$Item0", $Item0 = new Item("$Item0", null, "create", true));
        // inline creation of $Item1
        $objectMap.put("$Item1", $Item1 = new Item("$Item1", null, "update", false));
        // inline creation of $JPanel0
        setName("$JPanel0");
        
        /*protected String[] getSources() {
            return new String[]{ getDefaultSource(), "Validation.css",
                "Identity.java", "Identity-error-validation.xml", "Identity-info-validation.xml", "Identity-warning-validation.xml",
                "Model.java", "Model-error-validation.xml", "Model-info-validation.xml", "Model-warning-validation.xml"
            };
        }*/;// registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TITLE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (movie != null) {
                    movie.addPropertyChangeListener("title", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (movie != null) {
                    SwingUtil.setText(title, movie.getTitle());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (movie != null) {
                    movie.removePropertyChangeListener("title", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_YEAR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (movie != null) {
                    movie.addPropertyChangeListener("year", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (movie != null) {
                    SwingUtil.setText(year, movie.getYear() + "");
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (movie != null) {
                    movie.removePropertyChangeListener("year", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL3_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (movie != null) {
                    movie.addPropertyChangeListener("title", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (movie != null) {
                    $JLabel3.setText(_(movie.getTitle()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (movie != null) {
                    movie.removePropertyChangeListener("title", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL5_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (movie != null) {
                    movie.addPropertyChangeListener("year", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (movie != null) {
                    $JLabel5.setText(_(movie.getYear() + ""));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (movie != null) {
                    movie.removePropertyChangeListener("year", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (errorTable != null) {
                    errorTable.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (errorTable != null) {
                    $JScrollPane0.setColumnHeaderView(errorTable.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (errorTable != null) {
                    errorTable.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
    }

}