/* 
* ##% Copyright (C) 2002, 2003, 2004, 2005, 2006, 2007, 2008 Code Lutin,
* Tony Chemit, Gabriel Landais
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
* ##% */
package org.nuiton.jaxx.tab;

import jaxx.runtime.swing.JAXXTab;

import javax.swing.JTabbedPane;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Pour enregister un tab
 *
 * @author chemit
 */
@Retention(RetentionPolicy.RUNTIME)

@Target(ElementType.FIELD)

public @interface TabContentConfig {

    Class<? extends TabModel> model();

    Class<? extends JAXXTab> impl();

    Class<? extends JTabbedPane> parentImpl();

    boolean useToogle() default false;

    String name();

    String shortDescription();

    String[] dynamicFields() default {};

}
